<?php

namespace App\Imports;

use App\Models\IncidentParentCategory;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class IncidentParentCategoryImport implements ToModel, WithHeadingRow
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        if (!isset($row['code'])) {
            $foundKeys = implode(', ', array_keys($row));
            throw new \Exception("Missing required column 'Code'. Found headers: {$foundKeys}.");
        }

        IncidentParentCategory::updateOrCreate(
            ['code' => $row['code']],
            [
                'description' => $row['description'] ?? null,
                'status' => isset($row['status']) ? (strtolower($row['status']) == 'active' || $row['status'] == '1') : true,
            ]
        );

        return null;
    }
}
