<?php

namespace App\Imports;

use App\Models\IncidentCategory;
use App\Models\IncidentParentCategory;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class IncidentCategoryImport implements ToModel, WithHeadingRow
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        if (!isset($row['parent_code']) || !isset($row['description'])) {
            $missing = [];
            if (!isset($row['parent_code']))
                $missing[] = 'parent_code';
            if (!isset($row['description']))
                $missing[] = 'description';

            $foundKeys = implode(', ', array_keys($row));
            throw new \Exception("Missing required columns: " . implode(', ', $missing) . ". found: " . $foundKeys);
        }

        $parentCode = trim($row['parent_code']);
        $parent = IncidentParentCategory::where('code', $parentCode)->first();

        if (!$parent) {
            throw new \Exception("Parent category with code '{$parentCode}' not found. Please ensure the parent category exists first.");
        }

        return IncidentCategory::updateOrCreate(
            [
                'incident_parent_category_id' => $parent->id,
                'description' => $row['description'],
            ],
            [
                'code' => isset($row['code']) ? $row['code'] : null,
                'priority_level' => isset($row['priority_level']) ? (int) $row['priority_level'] : 5,
                'status' => isset($row['status']) ? (strtolower($row['status']) == 'active' || $row['status'] == '1') : true,
            ]
        );
    }
}
