<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class TwoFactorMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (!auth()->check()) {
            return $next($request);
        }

        $user = auth()->user();

        // Only enforce for 'user' role as requested
        if ($user->role !== 'user') {
            return $next($request);
        }

        $is2faEnabled = \App\Models\Setting::where('key', 'google_authenticator_enabled')->value('value') == '1';

        if (!$is2faEnabled) {
            return $next($request);
        }

        // If 2FA is required but not setup
        if (!$user->google2fa_secret) {
            if ($request->routeIs('2fa.*')) {
                return $next($request);
            }
            return redirect()->route('2fa.setup');
        }

        // If 2FA is setup but not verified in this session
        if (!session('google2fa_verified')) {
            if ($request->routeIs('2fa.*')) {
                return $next($request);
            }
            return redirect()->route('2fa.verify');
        }

        return $next($request);
    }
}
