<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class EnsureEmployeeTimezone
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $employee = null;

        if (Auth::guard('employee')->check()) {
            $employee = Auth::guard('employee')->user();
        } elseif (Auth::check() && method_exists(Auth::user(), 'employee') && Auth::user()->employee) {
            // Fallback for user masquerading or mixed context
            $employee = Auth::user()->employee;
        }

        if ($employee) {

            // Ensure Company ID is in session (useful for other logic)
            if (!session()->has('selected_company_id')) {
                session(['selected_company_id' => $employee->company_id]);
            }

            // Ensure Timezone is in session
            if (!session()->has('selected_company_timezone')) {
                // Eager load company and timezone if possible, or just fetch
                $company = \App\Models\Company::with('timeZone')->find($employee->company_id);
                if ($company && $company->timeZone) {
                    session(['selected_company_timezone' => $company->timeZone->name]);
                } else {
                    // Fallback if no timezone set
                    session(['selected_company_timezone' => config('app.timezone')]);
                }
            }

            // Apply Timezone
            if (session()->has('selected_company_timezone')) {
                $tz = session('selected_company_timezone');
                config(['app.timezone' => $tz]);
                date_default_timezone_set($tz);
            }
        }

        return $next($request);
    }
}
