<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class EnsureCompanySelected
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::check()) {
            // Check if company is already selected
            if (!session()->has('selected_company_id')) {
                // Allow request if we are already on the selection page or doing logout
                $allowedRoutes = ['select.company', 'select.company.store', 'logout'];
                if (!in_array($request->route()->getName(), $allowedRoutes)) {
                    return redirect()->route('select.company');
                }
            } else {
                // Apply Timezone
                if (!session()->has('selected_company_timezone')) {
                    $company = \App\Models\Company::with('timeZone')->find(session('selected_company_id'));
                    if ($company) {
                        session(['selected_company_timezone' => $company->timeZone->name ?? config('app.timezone')]);
                    }
                }

                if (session()->has('selected_company_timezone')) {
                    $tz = session('selected_company_timezone');
                    config(['app.timezone' => $tz]);
                    date_default_timezone_set($tz);
                }
            }
        }

        return $next($request);
    }
}
