<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;

class DeveloperSettingsController extends Controller
{
    public function index()
    {
        return view('developer-settings.index');
    }

    public function runCommand(Request $request)
    {
        $request->validate([
            'command' => 'required|string'
        ]);

        $command = $request->command;

        // Whitelist of allowed commands for security
        $allowedCommands = [
            'jobs:auto-complete-overdue',
            'app:update-schedule-statuses',
            'cache:clear',
            'config:clear',
            'route:clear',
            'view:clear',
        ];

        if (!in_array($command, $allowedCommands)) {
            return redirect()->back()->with('error', 'Command not allowed for security reasons.');
        }

        try {
            // Capture output
            Artisan::call($command);
            $output = Artisan::output();

            return redirect()->back()->with('success', "Command executed successfully!")->with('output', $output);
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Command failed: ' . $e->getMessage());
        }
    }
}
