<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\GuardApplication;
use Illuminate\Support\Facades\Validator;

class PublicAPIController extends Controller
{
    /**
     * Submit a guard application.
     * 
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function storeGuardApplication(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'full_name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|max:20',
            'experience_years' => 'required|integer|min:0',
            'message' => 'required|string',
            'resume' => 'required|file|mimes:pdf,doc,docx,jpeg,png,jpg,gif,svg|max:5120',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Validation failed',
                'errors' => $validator->errors()
            ], 422);
        }

        $validated = $validator->validated();

        $path = null;
        if ($request->hasFile('resume')) {
            $path = $request->file('resume')->store('resumes', 'public');
        }

        $application = GuardApplication::create([
            'full_name' => $validated['full_name'],
            'email' => $validated['email'],
            'phone' => $validated['phone'],
            'experience_years' => $validated['experience_years'],
            'message' => $validated['message'] ?? null,
            'resume_path' => $path,
        ]);

        return response()->json([
            'status' => 'success',
            'message' => 'Your application has been submitted successfully!',
            'data' => $application
        ], 201);
    }
}
