<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Notification;
use App\Models\Employee;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'message' => 'required|string',
            'url' => 'nullable|url|max:255',
            'target_type' => 'required|in:all,selected',
            'employees' => 'required_if:target_type,selected|array',
            'employees.*' => 'exists:employees,id',
        ]);

        $companyId = session('selected_company_id');
        $employeeIds = [];

        if ($request->target_type === 'all') {
            $employeeIds = Employee::where('company_id', $companyId)->where('active', true)->pluck('id')->toArray();
        } else {
            $employeeIds = $request->employees;
        }

        // Create Database Notifications
        foreach ($employeeIds as $id) {
            Notification::create([
                'company_id' => $companyId,
                'employee_id' => $id,
                'title' => $request->title,
                'message' => $request->message,
                'url' => $request->url,
            ]);
        }

        return redirect()->back()->with('success', 'Notification broadcasted successfully.');
    }
}
