<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Lead;
use App\Models\User;
use Carbon\Carbon;

use App\Http\Controllers\LeadController as BaseLeadController;

class LeadController extends BaseLeadController
{
    public function index(Request $request)
    {
        $query = Lead::with('assignee');

        // Filter: Status
        if ($request->filled('status') && $request->status !== 'all') {
            $query->where('status', $request->status);
        }

        // Filter: Date Range (Created At)
        if ($request->filled('date_from')) {
            $query->whereDate('created_at', '>=', $request->date_from);
        }
        if ($request->filled('date_to')) {
            $query->whereDate('created_at', '<=', $request->date_to);
        }

        // Filter: Assigned User
        if ($request->filled('assigned_to')) {
            $query->where('assigned_to', $request->assigned_to);
        }

        // Filter: Company Name
        if ($request->filled('company_name')) {
            $query->where('company_name', 'like', '%' . $request->company_name . '%');
        }

        $leads = $query->latest()->paginate(100);

        // Data for filters
        $users = User::orderBy('name')->get(['id', 'name']); // All users for admin filter

        // Counts for quick stats (optional, but good for admin dashboard view)
        $counts = [
            'total' => Lead::count(),
            'new' => Lead::where('status', 'new')->count(),
            'active' => Lead::whereIn('status', ['contacted', 'matured', 'proposal'])->count(),
            'won' => Lead::where('status', 'won')->count(),
            'lost' => Lead::where('status', 'lost')->count(),
        ];

        return view('admin.leads.index', compact('leads', 'users', 'counts'));
    }
}
