<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class TruncateSchedulesCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'schedules:truncate';

    protected $description = 'Truncate all schedules, incidents, jobs, and related data including files.';

    public function handle()
    {
        if (!$this->confirm('This will wipe all SCHEDULES, INCIDENTS, and JOB DATA. Are you sure?')) {
            return;
        }

        \Illuminate\Support\Facades\DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        // 1. Incidents
        \App\Models\Incident::truncate();
        $this->info('Truncated incidents.');
        \Illuminate\Support\Facades\Storage::disk('public')->deleteDirectory('incident-images'); // Check folder name

        // 2. Addon Schedules
        try {
            \Illuminate\Support\Facades\DB::table('addon_schedules')->truncate();
            $this->info('Truncated addon_schedules.');
            \Illuminate\Support\Facades\Storage::disk('public')->deleteDirectory('addon-evidence');
        } catch (\Exception $e) {
            $this->warn('AddonSchedule table might not exist or error: ' . $e->getMessage());
        }

        // 3. Employee Schedule Pivot (Jobs)
        \Illuminate\Support\Facades\DB::table('employee_schedule')->truncate();
        $this->info('Truncated employee_schedule pivot.');

        // Evidence Cleaning
        \Illuminate\Support\Facades\Storage::disk('public')->deleteDirectory('checkout-evidence');
        \Illuminate\Support\Facades\Storage::disk('public')->deleteDirectory('checkin-evidence');

        // 4. Schedules
        \App\Models\Schedule::truncate();
        $this->info('Truncated schedules.');

        \Illuminate\Support\Facades\DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        $this->info('All schedule data and related files have been cleared.');
    }
}
