<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class TruncateScheduleData extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:truncate-schedule-data {--force : Force the operation to run without confirmation}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Truncate all schedules, incidents, and related data for patrollers and guards.';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Truncating schedule and incident data...');

        if ($this->option('force') || $this->confirm('Are you sure you want to delete all schedule and incident data? This cannot be undone.', true)) {

            Schema::disableForeignKeyConstraints();

            $tables = [
                // Guard Schedule Tables
                'schedules',
                'employee_schedule',
                'schedule_wage_type',
                'incidents',
                'job_location_logs',

                // Patroller Schedule Tables
                'patroller_schedules',
                'patroller_job_sites',
                'patroller_issue_tickets',
                'employee_patroller_schedule',
            ];

            foreach ($tables as $table) {
                if (Schema::hasTable($table)) {
                    DB::table($table)->truncate();
                    $this->line("Truncated table: {$table}");
                } else {
                    $this->warn("Table not found: {$table}");
                }
            }

            Schema::enableForeignKeyConstraints();

            $this->info('All specified data has been truncated successfully.');
        } else {
            $this->info('Operation cancelled.');
        }
    }
}
