<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Employee;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;

class SyncEmployeesToUsers extends Command
{
    protected $signature = 'employees:sync-users';
    protected $description = 'Create user accounts for all existing employees based on their employee_id as password';

    public function handle()
    {
        $employees = Employee::all();
        $this->info("Found " . $employees->count() . " employees. Starting sync...");

        $guardRole = Role::where('name', 'Guard')->first();
        if (!$guardRole) {
            $this->warn("Role 'Guard' not found. Creating it...");
            $guardRole = Role::create(['name' => 'Guard']);
        }

        $count = 0;
        foreach ($employees as $employee) {
            $user = User::updateOrCreate(
                ['email' => $employee->email],
                [
                    'name' => $employee->first_name . ' ' . $employee->last_name,
                    'password' => Hash::make($employee->employee_id),
                    'active' => true,
                ]
            );

            $user->assignRole($guardRole);

            // Sync with company
            if ($employee->company_id) {
                $user->companies()->syncWithoutDetaching([$employee->company_id]);
            }

            // Also update the password on the employee record for sync
            $employee->update(['password' => Hash::make($employee->employee_id)]);

            $count++;
        }

        $this->info("Successfully synced $count employees to user accounts.");
    }
}
