<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\EmailCampaign;
use App\Jobs\SendEmailCampaignJob;

class ProcessScheduledCampaigns extends Command
{
    protected $signature = 'campaigns:process';
    protected $description = 'Dispatch scheduled email campaigns that are due';

    public function handle()
    {
        $campaigns = EmailCampaign::where('status', 'scheduled')
            ->where('scheduled_at', '<=', now())
            ->get();

        foreach ($campaigns as $campaign) {
            $this->info("Dispatching campaign: {$campaign->name} (ID: {$campaign->id})");

            // Mark as sending immediately to avoid race conditions if scheduler overlaps (though simple command usually fine)
            $campaign->update(['status' => 'sending', 'sent_at' => now()]);

            SendEmailCampaignJob::dispatch($campaign);
        }

        if ($campaigns->isNotEmpty()) {
            $this->info("Processed " . $campaigns->count() . " campaigns.");
        }
    }
}
