<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class FixScheduleBillRates extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'schedules:fix-bill-rates';

    protected $description = 'Fix bill_rate in employee_schedule table by copying from schedules.site_rate';

    public function handle()
    {
        $this->info('Fixing bill_rate for existing schedules...');

        // Get all employee_schedule records where bill_rate is NULL or 0
        $records = \DB::table('employee_schedule')
            ->join('schedules', 'employee_schedule.schedule_id', '=', 'schedules.id')
            ->whereNull('employee_schedule.bill_rate')
            ->orWhere('employee_schedule.bill_rate', 0)
            ->select('employee_schedule.schedule_id', 'employee_schedule.employee_id', 'schedules.site_rate')
            ->get();

        $updated = 0;
        foreach ($records as $record) {
            \DB::table('employee_schedule')
                ->where('schedule_id', $record->schedule_id)
                ->where('employee_id', $record->employee_id)
                ->update(['bill_rate' => $record->site_rate]);
            $updated++;
        }

        $this->info("Updated {$updated} employee_schedule records with bill_rate from schedules.site_rate");
        $this->info('Done!');

        return 0;
    }
}
