# /api/employee/requests/meta

**Method**: `GET`  
**URL**: `http://localhost:8000/api/employee/requests/meta`

## Headers
- `Authorization`: `Bearer {token}`
- `Accept`: `application/json`

## Response
```json
{
    "status": "success",
    "data": {
        "types": [
            {"value": "leave", "label": "Leave Request"},
            {"value": "short_leave", "label": "Short Day Leave"},
            {"value": "medical", "label": "Medical Leave"},
            {"value": "complaint", "label": "Complaint (Companion/Colleague)"},
            {"value": "advance", "label": "Advance Request"},
            {"value": "uniform", "label": "Uniform Request"},
            {"value": "resignation", "label": "Resignation"}
        ],
        "templates": {
            "leave": "I would like to request a leave of absence.\n\nFrom: [Start Date]\nTo: [End Date]\nReason: [Enter Reason]",
            "short_leave": "I would like to request a short leave.\n\nDate: [Date]\nTime: [Start Time] to [End Time]\nReason: [Enter Reason]",
            "medical": "I am unable to report to work due to medical reasons.\n\nDate(s): [Date]\nDoctor's Note: [Attached/Will Provide]",
            "complaint": "I wish to report a concern regarding a colleague/incident.\n\nPerson involved (if any): [Name]\nDetails of incident: ",
            "advance": "I would like to request a salary advance.\n\nAmount: [Enter Amount]\nReason for request: ",
            "resignation": "Please accept this message as formal notification that I am resigning from my position.\n\nMy last day will be: [Date]\nReason (Optional): ",
            "uniform": "I would like to request the following uniform items:\n\nItem(s) Needed:\n1. [Uniform Item Name] - Size: [Size] - Color: [Color]\n2. [Add more items if needed]\n\nReason for request: [New Issue/Replacement/Additional]\nUrgency: [Urgent/Normal]"
        }
    }
}
```
