# Employee Dashboard Implementation Guide

This guide details the implementation of the Employee Dashboard, specifically focusing on the synchronization between the Web Portal and the Mobile API.

## Core Features
The dashboard provides a consolidated view for employees, including:
1.  **Job Counters**: Total deployments, active jobs, today's duties, etc.
2.  **Shift Hours**: Total hours worked in the last 30 days.
3.  **Income Analytics**: 12-month earnings trend and 30-day income summary.
4.  **Job Lists**: Active, Today, Upcoming, Completed, and Missed jobs.
5.  **Personal Wishes**: Birthday and Work Anniversary notifications.

## Key Components

### 1. Earnings Calculation (Standardized)
To ensure consistency across the entire platform, all earnings calculations are centralized in a trait.

*   **Trait**: `App\Traits\CalculatesEarnings`
*   **Usage**: Used by both `EmployeeAPIController` (Mobile) and `EmployeeDashboardController` (Web).
*   **Logic**:
    *   **Guard Jobs (`calculateGuardEarnings`)**:
        *   Calculates based on `actual_start_at` and `actual_end_at`.
        *   Supports both flat `wage_rate` and tiered `wage_types` (e.g., specific rates for different hours).
        *   Includes `gas_rate`.
    *   **Patroller Jobs (`calculatePatrollerEarnings`)**:
        *   Sum of `wage_rate`, `gas_rate`, `allowance`, and `other_expense`.

### 2. Dashboard Logic Synchronization

#### Web Controller (`EmployeeDashboardController`)
*   **Shift Hours (30d)**:
    *   Calculated by summing the duration of all **completed** Guard and Patroller schedules within the last 30 days.
    *   Patroller hours are calculated from `from_time` to `to_time` if available.
*   **Income (30d)**:
    *   Sum of earnings for all completed jobs in the last 30 days using the `CalculatesEarnings` trait.
*   **Today's Jobs**:
    *   Strict filtering: `from_datetime` is today, `to_datetime` is in the future, and status is NOT `active`, `completed`, `missed`, or `cancelled`.

#### Mobile API Controller (`EmployeeAPIController`)
*   **Endpoint**: `/api/employee/dashboard`
*   **Structure**: Returns a JSON object matching the data structure required by the mobile app, but with values derived using the **same logic** as the web controller.
*   **Update**: Now includes the `CalculatesEarnings` trait to ensure the "Income" and "Earnings History" values match the web portal exactly.
*   **Shift Hours**: Now returns the 30-day aggregated shift hours instead of just a placeholder or daily count.

### 3. Implementation Steps for Future Updates

If logic changes in the future (e.g., how overtime is calculated), follow these steps:

1.  **Update the Trait**: Modify `App\Traits\CalculatesEarnings.php`. This automatically updates both Web and API.
2.  **Verify Web Dashboard**: Check `EmployeeDashboardController::index` to ensure it passes the correct data to the view.
3.  **Verify API Response**: Check `EmployeeAPIController::dashboard` to ensure it returns the updated values in the JSON response.
4.  **Consistency Check**: Compare `Shift Hours` and `Income` values between the Web Portal (`/employee/dashboard`) and API (`/api/employee/dashboard`).

## Recent Fixes
*   **Shift Hours Discrepancy**: The web dashboard was incorrectly showing `0h` because it was calculating future/pending hours for *today only*. It has been updated to show the **total actual hours worked in the last 30 days**, matching the API.
*   **API Earnings**: The API was using a simplified calculation. It now uses the robust `CalculatesEarnings` trait to handle complex wage types.
