# Complete Employee API Documentation

## Base URL
```
http://192.168.29.141:8000/api/employee
```

## Authentication
All endpoints require Bearer token authentication:
```
Authorization: Bearer {token}
```

---

## 📱 Authentication APIs

### 1. Login
**POST** `/employee/login`

#### Request Payload
```json
{
  "email": "employee@example.com",
  "password": "password123"
}
```

#### Success Response (200)
```json
{
  "status": "success",
  "message": "Login successful",
  "data": {
    "token": "21|gC5uOFMqXEvueAlr5GzzgHhrzgj5Em4BK0u9MVHQb4c931a1",
    "employee": {
      "id": 3,
      "company_id": 4,
      "first_name": "Sahil",
      "last_name": "Mahajan",
      "email": "employee@example.com",
      "phone_number": "+1234567890",
      "employee_id": "FES3293",
      "profile_picture": null,
      "dob": "1990-01-15",
      "employment_date": "2020-06-01",
      "license_number": "LIC123456",
      "license_expiry": "2027-12-31",
      "created_at": "2025-12-28T05:19:04.000000Z",
      "updated_at": "2026-01-26T10:30:00.000000Z"
    }
  }
}
```

#### Error Response (401)
```json
{
  "status": "error",
  "message": "Invalid credentials"
}
```

---

### 2. Logout
**POST** `/employee/logout`

#### Request Headers
```
Authorization: Bearer {token}
```

#### Success Response (200)
```json
{
  "status": "success",
  "message": "Logged out successfully"
}
```

---

### 3. Update FCM Token
**POST** `/employee/fcm-token`

#### Request Payload
```json
{
  "fcm_token": "firebase_cloud_messaging_token_here"
}
```

#### Success Response (200)
```json
{
  "status": "success",
  "message": "FCM token updated successfully"
}
```

---

## 👤 Profile APIs

### 4. Get Profile
**GET** `/employee/profile`

#### Success Response (200)
```json
{
  "status": "success",
  "data": {
    "id": 3,
    "company_id": 4,
    "first_name": "Sahil",
    "last_name": "Mahajan",
    "email": "employee@example.com",
    "phone_number": "+1234567890",
    "employee_id": "FES3293",
    "profile_picture": "profile_pictures/employee_3.jpg",
    "dob": "1990-01-15",
    "gender": "male",
    "address": "123 Main Street",
    "city": "Lahore",
    "state": "Punjab",
    "zip_code": "54000",
    "country": "Pakistan",
    "employment_date": "2020-06-01",
    "job_title": "Security Guard",
    "department": "Operations",
    "license_number": "LIC123456",
    "license_expiry": "2027-12-31",
    "emergency_contact_name": "John Doe",
    "emergency_contact_phone": "+9876543210",
    "visibility_minutes": 30,
    "created_at": "2025-12-28T05:19:04.000000Z",
    "updated_at": "2026-01-26T10:30:00.000000Z"
  }
}
```

---

### 5. Update Profile
**POST** `/employee/profile`

#### Request Payload (multipart/form-data)
```
first_name: Sahil
last_name: Mahajan
phone_number: +1234567890
address: 123 Main Street
city: Lahore
state: Punjab
zip_code: 54000
emergency_contact_name: John Doe
emergency_contact_phone: +9876543210
profile_picture: [File] (optional, max 2MB)
```

#### Success Response (200)
```json
{
  "status": "success",
  "message": "Profile updated successfully",
  "data": {
    "id": 3,
    "first_name": "Sahil",
    "last_name": "Mahajan",
    "profile_picture": "profile_pictures/employee_3_updated.jpg"
  }
}
```

---

## 📊 Dashboard API

### 6. Get Dashboard
**GET** `/employee/dashboard`

#### Success Response (200)
```json
{
  "status": "success",
  "data": {
    "counts": {
      "messages": 0,
      "deployments": 8,
      "active": 1,
      "shift_hours": 8.0,
      "income_30d": 53.51
    },
    "active_jobs": [
      {
        "id": 2,
        "duty_number": "DTY0377",
        "from_datetime": "2026-01-26T12:00:00.000000Z",
        "to_datetime": "2026-01-26T20:00:00.000000Z",
        "status": "active",
        "pivot": {
          "employee_id": 3,
          "schedule_id": 2,
          "wage_rate": "0.00",
          "gas_rate": null,
          "wage_types": "[{\"id\":\"1\",\"rate\":\"20.00\",\"name\":\"SIN\",\"allocated_hours\":\"1.00\"}]",
          "actual_start_at": "2026-01-26T12:01:20.000000Z",
          "actual_end_at": null,
          "start_lat": "31.64230741",
          "start_lng": "74.87661243",
          "checkin_images": "[\"images/Gleichner_PLC_Site_2026-01-26_12-01-20_DTY0377/checkin_images/photo1.png\"]",
          "checkout_images": null
        },
        "site": {
          "id": 5,
          "name": "Gleichner PLC Site",
          "address_line_1": "55180 Moore Well",
          "city": "Medhurstside",
          "latitude": "-74.21711",
          "longitude": "66.277576"
        }
      }
    ],
    "today_jobs": [
      {
        "id": 5,
        "duty_number": "DTY0380",
        "from_datetime": "2026-01-26T18:00:00.000000Z",
        "to_datetime": "2026-01-27T02:00:00.000000Z",
        "status": "scheduled",
        "site": {
          "id": 8,
          "name": "Downtown Plaza",
          "city": "Lahore"
        }
      }
    ],
    "completed_jobs": [
      {
        "id": 1,
        "duty_number": "DTY0376",
        "from_datetime": "2026-01-25T08:00:00.000000Z",
        "to_datetime": "2026-01-25T16:00:00.000000Z",
        "status": "completed",
        "site": {
          "id": 3,
          "name": "Corporate Tower"
        }
      }
    ],
    "active_patroller_jobs": [],
    "today_patroller_jobs": [],
    "completed_patroller_jobs": [],
    "incident_categories": [
      {
        "id": 1,
        "code": "100",
        "description": "Accident",
        "status": 1,
        "incident_categories": []
      },
      {
        "id": 25,
        "code": "t-101",
        "description": "Unsecure",
        "status": 1,
        "incident_categories": [
          {
            "id": 1,
            "incident_parent_category_id": 25,
            "code": "150-A",
            "description": "Unsecure / Door",
            "priority_level": 2,
            "status": 1
          }
        ]
      }
    ],
    "earnings_history": [
      {"month": "Feb", "total": 0},
      {"month": "Mar", "total": 0},
      {"month": "Apr", "total": 0},
      {"month": "May", "total": 0},
      {"month": "Jun", "total": 0},
      {"month": "Jul", "total": 0},
      {"month": "Aug", "total": 0},
      {"month": "Sep", "total": 0},
      {"month": "Oct", "total": 0},
      {"month": "Nov", "total": 0},
      {"month": "Dec", "total": 0},
      {"month": "Jan", "total": 53.51}
    ],
    "wishes": {
      "birthday": null,
      "anniversary": null
    },
    "issued_uniforms": [
      {
        "id": 4,
        "employee_id": 3,
        "uniform_variant_id": 1,
        "quantity": 1,
        "issued_at": "2026-01-21T00:00:00.000000Z",
        "variant": {
          "id": 1,
          "size": "S",
          "color": "White",
          "uniform": {
            "id": 1,
            "name": "Shirts",
            "code": "Sh101"
          }
        }
      }
    ]
  }
}
```

---

## 💼 Jobs API

### 7. Get Jobs List
**GET** `/employee/jobs?type={type}&per_page={per_page}&search={search}`

#### Query Parameters
- `type`: `all` | `active` | `today` | `upcoming` | `completed` | `missed` | `pending` | `cancelled` (default: `all`)
- `per_page`: Number of items per page (default: 50)
- `search`: Search by Duty Number or Site Name

#### Success Response (200)
```json
{
  "status": "success",
  "data": {
    "jobs": {
      "current_page": 1,
      "data": [ ... ],
      "total": 8
    },
    "counts": {
      "all": 8,
      "active": 1,
      "today": 1,
      "upcoming": 1,
      "completed": 3,
      "missed": 1,
      "cancelled": 1,
      "pending": 0
    }
  }
}
```

---

## 📈 Analytics API

### 8. Get Analytics
**GET** `/employee/analytics`

#### Success Response (200)
```json
{
  "status": "success",
  "data": {
    "summary": {
      "attendance_rate": 95,
      "avg_shift_duration": 8.2,
      "incident_count": 2,
      "patroller_tickets": 0,
      "total_field_reports": 2
    },
    "guard_operations": {
      "total_shifts": 8,
      "completed": 3,
      "missed": 0,
      "upcoming": 2,
      "cancelled": 1
    },
    "patroller_operations": {
      "total_routes": 0,
      "completed": 0,
      "missed": 0,
      "upcoming": 0
    },
    "trends": {
      "income": [
        {"month": "Feb", "total": 0},
        {"month": "Mar", "total": 0},
        {"month": "Apr", "total": 0},
        {"month": "May", "total": 0},
        {"month": "Jun", "total": 0},
        {"month": "Jul", "total": 0},
        {"month": "Aug", "total": 0},
        {"month": "Sep", "total": 0},
        {"month": "Oct", "total": 0},
        {"month": "Nov", "total": 0},
        {"month": "Dec", "total": 0},
        {"month": "Jan", "total": 53.51}
      ],
      "reporting": [
        {"month": "Feb", "total": 0},
        {"month": "Mar", "total": 0},
        {"month": "Apr", "total": 0},
        {"month": "May", "total": 0},
        {"month": "Jun", "total": 0},
        {"month": "Jul", "total": 0},
        {"month": "Aug", "total": 0},
        {"month": "Sep", "total": 0},
        {"month": "Oct", "total": 0},
        {"month": "Nov", "total": 0},
        {"month": "Dec", "total": 0},
        {"month": "Jan", "total": 2}
      ]
    }
  }
}
```

---

## 🎯 Job Management APIs

### 9. Start Job
**POST** `/employee/jobs/{id}/start`

#### Request Payload
```json
{
  "latitude": 31.5204,
  "longitude": 74.3587
}
```

#### Success Response (200)
```json
{
  "status": "success",
  "message": "Job initiated. Deployment is now ACTIVE. Please submit check-in evidence.",
  "data": {
    "job_id": 2,
    "duty_number": "DTY0377",
    "started_at": "2026-01-26T12:01:20+05:30"
  }
}
```

#### Error Response - Not in Visibility Window (422)
```json
{
  "status": "error",
  "message": "Job is not yet cleared for initiation.",
  "details": {
    "scheduled": "2026-01-26T14:00:00+05:30",
    "deadline": "2026-01-26T13:30:00+05:30",
    "window_minutes": 30
  }
}
```

#### Error Response - Concurrent Job (422)
```json
{
  "status": "error",
  "message": "You are already active on Duty #DTY0376. Please end that duty before starting a new one.",
  "active_job": {
    "id": 1,
    "duty_number": "DTY0376",
    "from_time": "10:00",
    "to_time": "18:00"
  }
}
```

#### Error Response - Job Expired (422)
```json
{
  "status": "error",
  "message": "Job has expired and cannot be initiated.",
  "scheduled_end": "2026-01-26T10:00:00+05:30"
}
```

---

### 10. Upload Check-in Evidence
**POST** `/employee/jobs/{id}/checkin`

#### Request (multipart/form-data)
```
images[]: File (required, min 1, max 10MB each)
images[]: File
images[]: File
```

#### Success Response (200)
```json
{
  "status": "success",
  "message": "Check-in evidence successfully archived. Job profile updated.",
  "data": {
    "images_count": 3,
    "images": [
      "images/Gleichner_PLC_Site_2026-01-26_12-01-20_DTY0377/checkin_images/photo_1.jpg",
      "images/Gleichner_PLC_Site_2026-01-26_12-01-20_DTY0377/checkin_images/photo_2.jpg",
      "images/Gleichner_PLC_Site_2026-01-26_12-01-20_DTY0377/checkin_images/photo_3.jpg"
    ]
  }
}
```

#### Error Response - Validation (422)
```json
{
  "message": "The images field is required.",
  "errors": {
    "images": [
      "The images field is required."
    ]
  }
}
```

---

### 11. Report Incident
**POST** `/employee/jobs/{id}/incident`

#### Request (multipart/form-data)
```
subject: Broken Window
description: Found a broken window on the 3rd floor near the emergency exit. Glass shattered on the floor.
incident_parent_category_id: 25
incident_category_id: 1 # Optional (if subcategory exists)
images[]: File (optional, max 5MB each)
images[]: File
```

#### Success Response (200)
```json
{
  "status": "success",
  "message": "Incident report filed and prioritized for review.",
  "data": {
    "incident_id": 45,
    "images_count": 2
  }
}
```

#### Error Response - Validation (422)
```json
{
  "message": "The subject field is required. (and 1 more error)",
  "errors": {
    "subject": [
      "The subject field is required."
    ],
    "incident_parent_category_id": [
      "The incident parent category id field is required."
    ]
  }
}
```

---

### 12. Get Incident Categories
**GET** `/employee/incident-categories`

#### Success Response (200)
```json
{
  "status": "success",
  "data": [
    {
      "id": 1,
      "code": "100",
      "description": "Accident",
      "status": 1,
      "incident_categories": []
    },
    {
      "id": 25,
      "code": "t-101",
      "description": "Unsecure",
      "status": 1,
      "incident_categories": [
        {
          "id": 1,
          "incident_parent_category_id": 25,
          "code": "150-A",
          "description": "Unsecure / Door",
          "priority_level": 2,
          "status": 1
        }
      ]
    }
  ]
}
```

---

### 13. Upload Checkout Evidence
**POST** `/employee/jobs/{id}/checkout-evidence`

#### Request (multipart/form-data)
```
images[]: File (required, min 1, max 5MB each)
images[]: File
```

#### Success Response (200)
```json
{
  "status": "success",
  "message": "Checkout images uploaded successfully.",
  "data": {
    "total_images": 5,
    "new_images": 2,
    "images": [
      "images/Gleichner_PLC_Site_2026-01-26_12-01-20_DTY0377/checkout_images/photo_1.jpg",
      "images/Gleichner_PLC_Site_2026-01-26_12-01-20_DTY0377/checkout_images/photo_2.jpg",
      "images/Gleichner_PLC_Site_2026-01-26_12-01-20_DTY0377/checkout_images/photo_3.jpg",
      "images/Gleichner_PLC_Site_2026-01-26_12-01-20_DTY0377/checkout_images/photo_4.jpg",
      "images/Gleichner_PLC_Site_2026-01-26_12-01-20_DTY0377/checkout_images/photo_5.jpg"
    ]
  }
}
```

**Note:** This endpoint appends new images to existing ones. You can call it multiple times.

---

### 13. End Job
**POST** `/employee/jobs/{id}/end`

#### Request Payload
```json
{
  "latitude": 31.5204,
  "longitude": 74.3587
}
```

#### Success Response (200)
```json
{
  "status": "success",
  "message": "Job Terminated. Extraction complete.",
  "data": {
    "job_id": 2,
    "duty_number": "DTY0377",
    "ended_at": "2026-01-26T18:30:00+05:30",
    "job_status": "completed"
  }
}
```

#### Error Response - Missing Evidence (422)
```json
{
  "status": "error",
  "message": "Job Clearance Denied",
  "errors": [
    "Infiltration Evidence (Check-in Photos) missing.",
    "Extraction Evidence (Checkout Photos) missing."
  ]
}
```

---

### 14. Delete Evidence
**DELETE** `/employee/jobs/{id}/evidence/{type}/{index}`

#### URL Parameters
- `id`: Job ID (e.g., 2)
- `type`: `checkin` or `checkout`
- `index`: Image index starting from 0

#### Example Request
```
DELETE /api/employee/jobs/2/evidence/checkin/0
```

#### Success Response (200)
```json
{
  "status": "success",
  "message": "Evidence deleted successfully."
}
```

---

## 🔔 Notifications APIs

### 15. Get Notifications
**GET** `/employee/notifications`

#### Success Response (200)
```json
{
  "status": "success",
  "data": [
    {
      "id": 1,
      "employee_id": 3,
      "title": "New Job Assignment",
      "message": "You have been assigned to Duty #DTY0380 on 2026-01-27",
      "url": null,
      "read_at": null,
      "created_at": "2026-01-26T10:00:00.000000Z"
    },
    {
      "id": 2,
      "employee_id": 3,
      "title": "Schedule Update",
      "message": "Your schedule for tomorrow has been updated",
      "url": null,
      "read_at": "2026-01-26T11:00:00.000000Z",
      "created_at": "2026-01-26T09:00:00.000000Z"
    }
  ]
}
```

---

### 16. Mark Notification as Read
**POST** `/employee/notifications/{id}/read`

#### Success Response (200)
```json
{
  "status": "success",
  "message": "Notification marked as read"
}
```

---

## 👕 Uniforms API

### 17. Get Issued Uniforms
**GET** `/employee/uniforms`

#### Success Response (200)
```json
{
  "status": "success",
  "data": [
    {
      "id": 4,
      "employee_id": 3,
      "uniform_variant_id": 1,
      "quantity": 1,
      "issued_at": "2026-01-21T00:00:00.000000Z",
      "notes": null,
      "variant": {
        "id": 1,
        "uniform_id": 1,
        "size": "S",
        "color": "White",
        "stock_quantity": 98,
        "uniform": {
          "id": 1,
          "company_id": 4,
          "name": "Shirts",
          "code": "Sh101",
          "description": "white formal shirts"
        }
      }
    },
    {
      "id": 5,
      "employee_id": 3,
      "uniform_variant_id": 4,
      "quantity": 1,
      "issued_at": "2026-01-21T00:00:00.000000Z",
      "notes": null,
      "variant": {
        "id": 4,
        "uniform_id": 2,
        "size": "30",
        "color": "Black",
        "stock_quantity": 49,
        "uniform": {
          "id": 2,
          "company_id": 4,
          "name": "Trousers",
          "code": "T-101",
          "description": "Black Formal Trousers"
        }
      }
    }
  ]
}
```

---

## 📝 Requests APIs

### 18. Get Requests List
**GET** `/employee/requests`

#### Success Response (200)
```json
{
  "status": "success",
  "data": [
    {
      "id": 1,
      "employee_id": 3,
      "type": "leave",
      "subject": "Medical Leave Request",
      "description": "Requesting 2 days leave for medical reasons",
      "status": "pending",
      "admin_response": null,
      "created_at": "2026-01-25T10:00:00.000000Z",
      "updated_at": "2026-01-25T10:00:00.000000Z"
    }
  ]
}
```

---

### 19. Get Request Metadata
**GET** `/employee/requests/meta`

#### Success Response (200)
```json
{
  "status": "success",
  "data": {
    "types": [
      {"value": "leave", "label": "Leave Request"},
      {"value": "support", "label": "Support Request"},
      {"value": "complaint", "label": "Complaint"},
      {"value": "other", "label": "Other"}
    ]
  }
}
```

---

### 20. Create Request
**POST** `/employee/requests`

#### Request Payload
```json
{
  "type": "leave",
  "subject": "Medical Leave Request",
  "description": "I need 2 days leave for medical treatment on Jan 28-29"
}
```

#### Success Response (200)
```json
{
  "status": "success",
  "message": "Request submitted successfully",
  "data": {
    "id": 2,
    "employee_id": 3,
    "type": "leave",
    "subject": "Medical Leave Request",
    "description": "I need 2 days leave for medical treatment on Jan 28-29",
    "status": "pending",
    "created_at": "2026-01-26T15:30:00.000000Z"
  }
}
```

---

### 21. Reply to Request
**POST** `/employee/requests/{id}/reply`

#### Request Payload
```json
{
  "message": "Thank you for the update. I will provide the medical certificate tomorrow."
}
```

#### Success Response (200)
```json
{
  "status": "success",
  "message": "Reply added successfully"
}
```

---

## ⚙️ Settings APIs

### 22. Get Settings
**GET** `/employee/settings`

#### Success Response (200)
```json
{
  "status": "success",
  "data": {
    "notifications_enabled": true,
    "location_tracking": true,
    "app_version": "1.0.0",
    "visibility_minutes": 30
  }
}
```

---

### 23. Update Password
**POST** `/employee/settings/password`

#### Request Payload
```json
{
  "current_password": "oldpassword123",
  "password": "newpassword456",
  "password_confirmation": "newpassword456"
}
```

#### Success Response (200)
```json
{
  "status": "success",
  "message": "Password updated successfully"
}
```

#### Error Response - Wrong Current Password (422)
```json
{
  "status": "error",
  "message": "Current password is incorrect"
}
```

---

## 🔄 Complete Job Workflow Example

### Step 1: Get Today's Jobs
```bash
GET /api/employee/jobs?type=today
Authorization: Bearer {token}
```

### Step 2: Start a Job
```bash
POST /api/employee/jobs/2/start
Authorization: Bearer {token}
Content-Type: application/json

{
  "latitude": 31.5204,
  "longitude": 74.3587
}
```

### Step 3: Upload Check-in Evidence
```bash
POST /api/employee/jobs/2/checkin
Authorization: Bearer {token}
Content-Type: multipart/form-data

images[]: [File]
images[]: [File]
```

### Step 4: Report Incident (Optional)
```bash
POST /api/employee/jobs/2/incident
Authorization: Bearer {token}
Content-Type: multipart/form-data

subject: Broken Window
description: Found broken window on 3rd floor
incident_parent_category_id: 25
incident_category_id: 1
images[]: [File]
```

### Step 5: Upload Checkout Evidence
```bash
POST /api/employee/jobs/2/checkout-evidence
Authorization: Bearer {token}
Content-Type: multipart/form-data

images[]: [File]
images[]: [File]
```

### Step 6: End Job
```bash
POST /api/employee/jobs/2/end
Authorization: Bearer {token}
Content-Type: application/json

{
  "latitude": 31.5204,
  "longitude": 74.3587
}
```

---

## 📱 Mobile App Integration Notes

### Image Upload Best Practices
1. **Compress images** before upload (recommended max 1MB per image)
2. **Use JPEG format** for better compression
3. **Show upload progress** to user
4. **Handle network failures** with retry mechanism
5. **Cache images locally** before upload for offline support

### Location Tracking
1. Request location permissions on app start
2. Use **high accuracy** mode for job start/end
3. Implement **background location** for active jobs
4. Handle location permission denials gracefully

### Error Handling
1. Always check `status` field in response
2. Display `message` to user for errors
3. Log detailed errors for debugging
4. Implement retry logic for network failures

### Offline Support
1. Queue job actions when offline
2. Sync when connection restored
3. Show offline indicator to user
4. Cache job data for offline viewing

### Real-time Updates
1. Implement FCM for push notifications
2. Refresh dashboard on app resume
3. Poll for updates during active jobs
4. Show real-time job status changes

---

## 🧪 Testing with cURL

### Login
```bash
curl -X POST http://192.168.29.141:8000/api/employee/login \
  -H "Content-Type: application/json" \
  -d '{"email":"employee@example.com","password":"password123"}'
```

### Get Dashboard
```bash
curl -X GET http://192.168.29.141:8000/api/employee/dashboard \
  -H "Authorization: Bearer YOUR_TOKEN"
```

### Start Job
```bash
curl -X POST http://192.168.29.141:8000/api/employee/jobs/2/start \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Content-Type: application/json" \
  -d '{"latitude":31.5204,"longitude":74.3587}'
```

### Upload Check-in
```bash
curl -X POST http://192.168.29.141:8000/api/employee/jobs/2/checkin \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -F "images[]=@/path/to/photo1.jpg" \
  -F "images[]=@/path/to/photo2.jpg"
```

### End Job
```bash
curl -X POST http://192.168.29.141:8000/api/employee/jobs/2/end \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Content-Type: application/json" \
  -d '{"latitude":31.5204,"longitude":74.3587}'
```

---

## 📊 HTTP Status Codes

| Code | Meaning | Usage |
|------|---------|-------|
| 200 | OK | Successful request |
| 201 | Created | Resource created successfully |
| 401 | Unauthorized | Invalid or missing token |
| 404 | Not Found | Resource not found |
| 422 | Unprocessable Entity | Validation error |
| 500 | Internal Server Error | Server error |

---

## 🔐 Security Notes

1. **Always use HTTPS** in production
2. **Store tokens securely** (Keychain/KeyStore)
3. **Implement token refresh** mechanism
4. **Never log sensitive data** (passwords, tokens)
5. **Validate all user inputs** before sending
6. **Handle token expiration** gracefully
7. **Implement certificate pinning** for production

---

## 📞 Support

For API issues or questions, contact the backend team or refer to the web panel implementation at:
- `/app/Http/Controllers/Employee/EmployeeJobController.php`
- `/app/Http/Controllers/Employee/EmployeeDashboardController.php`
