@extends('layouts.user')

@section('title', 'Vehicle Management')

@section('content')
    <div class="flex flex-col h-full">
        <!-- Toolbar & Filters -->
        <div class="bg-white border-b border-gray-100 px-8 py-6">
            <div class="flex flex-col lg:flex-row lg:items-center justify-between gap-6">
                <div>
                    <h1 class="text-2xl font-black text-slate-900 tracking-tight">Vehicle Management</h1>
                    <p class="text-xs text-slate-500 font-medium mt-1">Manage and monitor all {{ $vehicles->total() }}
                        vehicles.</p>
                </div>

                <div class="flex flex-wrap items-center gap-3">
                    <form action="{{ route('vehicles.index') }}" method="GET" class="flex items-center gap-3">
                        <!-- Search by VIN -->
                        <div class="relative group">
                            <input type="text" name="search" value="{{ request('search') }}" placeholder="Search by VIN..."
                                class="w-64 pl-10 pr-4 py-2.5 bg-slate-50 border border-slate-200 rounded-2xl text-xs focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all group-hover:bg-white">
                            <svg class="absolute left-3.5 top-1/2 -translate-y-1/2 w-4 h-4 text-slate-400" fill="none"
                                stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                        </div>

                        <!-- Filter by Ownership -->
                        <select name="ownership"
                            class="px-4 py-2.5 bg-slate-50 border border-slate-200 rounded-2xl text-xs focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                            <option value="">All Ownership</option>
                            <option value="Purchased" {{ request('ownership') == 'Purchased' ? 'selected' : '' }}>Purchased
                            </option>
                            <option value="Leased" {{ request('ownership') == 'Leased' ? 'selected' : '' }}>Leased</option>
                            <option value="Rented" {{ request('ownership') == 'Rented' ? 'selected' : '' }}>Rented</option>
                        </select>

                        <!-- Filter by Status -->
                        <select name="status"
                            class="px-4 py-2.5 bg-slate-50 border border-slate-200 rounded-2xl text-xs focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                            <option value="">All Status</option>
                            <option value="Active" {{ request('status') == 'Active' ? 'selected' : '' }}>Active</option>
                            <option value="Inactive" {{ request('status') == 'Inactive' ? 'selected' : '' }}>Inactive</option>
                            <option value="Maintenance" {{ request('status') == 'Maintenance' ? 'selected' : '' }}>Maintenance
                            </option>
                            <option value="Sold" {{ request('status') == 'Sold' ? 'selected' : '' }}>Sold</option>
                        </select>

                        <button type="submit"
                            class="p-2.5 bg-blue-600 text-white rounded-2xl shadow-lg shadow-blue-500/30 hover:bg-blue-700 transition-all">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                        </button>
                    </form>

                    <div class="h-8 w-px bg-slate-200 mx-2"></div>

                    <a href="{{ route('vehicles.create') }}"
                        class="flex items-center gap-2 px-6 py-2.5 bg-slate-900 text-white rounded-2xl shadow-lg shadow-slate-200/50 hover:bg-slate-800 transition-all text-xs font-bold uppercase tracking-wider">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                        </svg>
                        Create Vehicle
                    </a>
                </div>
            </div>
        </div>

        @if(session('success'))
            <div
                class="m-4 p-3 bg-emerald-50 border border-emerald-100 text-emerald-700 rounded text-xs flex items-center gap-2">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                </svg>
                {{ session('success') }}
            </div>
        @endif

        <!-- Table -->
        <div class="flex-1 overflow-auto bg-white">
            <table class="min-w-full divide-y divide-gray-200 border-separate border-spacing-0">
                <thead class="bg-[#1e293b] text-white">
                    <tr>
                        <th scope="col" class="px-3 py-4 text-left text-[11px] font-bold uppercase tracking-wider w-24">
                            Vehicle ID</th>
                        <th scope="col" class="px-4 py-4 text-left text-[11px] font-bold uppercase tracking-wider">
                            Make/Model</th>
                        <th scope="col" class="px-4 py-4 text-left text-[11px] font-bold uppercase tracking-wider">Year
                        </th>
                        <th scope="col" class="px-4 py-4 text-left text-[11px] font-bold uppercase tracking-wider">VIN
                        </th>
                        <th scope="col" class="px-4 py-4 text-left text-[11px] font-bold uppercase tracking-wider">
                            License Plate</th>
                        <th scope="col" class="px-4 py-4 text-left text-[11px] font-bold uppercase tracking-wider">
                            Ownership</th>
                        <th scope="col" class="px-4 py-4 text-center text-[11px] font-bold uppercase tracking-wider">
                            Status</th>
                        <th scope="col" class="px-4 py-4 text-right text-[11px] font-bold uppercase tracking-wider">
                            Action</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-100">
                    @forelse($vehicles as $vehicle)
                        <tr class="hover:bg-slate-50 transition-colors group">
                            <td class="px-3 py-4 whitespace-nowrap">
                                <span
                                    class="bg-blue-50 text-blue-700 px-2 py-1 rounded-lg text-xs font-bold border border-blue-100 shadow-sm">
                                    {{ $vehicle->vehicle_id }}
                                </span>
                            </td>
                            <td class="px-4 py-4 whitespace-nowrap text-xs font-bold text-gray-900">
                                <div class="flex flex-col">
                                    <span>{{ $vehicle->make }} {{ $vehicle->model }}</span>
                                </div>
                            </td>
                            <td class="px-4 py-4 whitespace-nowrap text-xs text-gray-500 font-medium">
                                {{ $vehicle->year }}
                            </td>
                            <td class="px-4 py-4 whitespace-nowrap text-[11px] font-bold text-gray-900">
                                {{ $vehicle->vin_number }}
                            </td>
                            <td class="px-4 py-4 whitespace-nowrap text-xs text-gray-500 font-medium italic">
                                {{ $vehicle->license_plate }}
                            </td>
                            <td class="px-4 py-4 whitespace-nowrap">
                                <span class="px-2 py-1 rounded text-[10px] font-bold 
                                            {{ $vehicle->ownership == 'Purchased' ? 'bg-green-100 text-green-700' : '' }}
                                            {{ $vehicle->ownership == 'Leased' ? 'bg-blue-100 text-blue-700' : '' }}
                                            {{ $vehicle->ownership == 'Rented' ? 'bg-purple-100 text-purple-700' : '' }}">
                                    {{ $vehicle->ownership }}
                                </span>
                            </td>
                            <td class="px-4 py-4 whitespace-nowrap text-center">
                                <span class="px-2 py-1 rounded text-[10px] font-bold 
                                            {{ $vehicle->status == 'Active' ? 'bg-emerald-100 text-emerald-700' : '' }}
                                            {{ $vehicle->status == 'Inactive' ? 'bg-gray-100 text-gray-700' : '' }}
                                            {{ $vehicle->status == 'Maintenance' ? 'bg-amber-100 text-amber-700' : '' }}
                                            {{ $vehicle->status == 'Sold' ? 'bg-red-100 text-red-700' : '' }}">
                                    {{ $vehicle->status }}
                                </span>
                            </td>
                            <td class="px-4 py-4 whitespace-nowrap text-right">
                                <div class="flex items-center justify-end gap-2">
                                    <a href="{{ route('vehicles.show', $vehicle) }}"
                                        class="p-2 text-slate-400 hover:text-blue-600 hover:bg-blue-50 rounded-xl transition-all group/tooltip relative">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                        </svg>
                                        <span
                                            class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 px-2 py-1 bg-slate-900 text-white text-[10px] font-bold rounded opacity-0 group-hover/tooltip:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">View
                                            Details</span>
                                    </a>
                                    <a href="{{ route('vehicles.edit', $vehicle) }}"
                                        class="p-2 text-slate-400 hover:text-amber-600 hover:bg-amber-50 rounded-xl transition-all group/tooltip relative">
                                        <svg class="w-4.5 h-4.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                                            </path>
                                        </svg>
                                        <span
                                            class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 px-2 py-1 bg-slate-900 text-white text-[10px] font-bold rounded opacity-0 group-hover/tooltip:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">Edit
                                            Vehicle</span>
                                    </a>

                                    <form action="{{ route('vehicles.destroy', $vehicle) }}" method="POST"
                                        onsubmit="return confirm('Are you sure you want to delete this vehicle?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit"
                                            class="p-2 text-slate-400 hover:text-red-600 hover:bg-red-50 rounded-xl transition-all group/tooltip relative">
                                            <svg class="w-4.5 h-4.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                                </path>
                                            </svg>
                                            <span
                                                class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 px-2 py-1 bg-slate-900 text-white text-[10px] font-bold rounded opacity-0 group-hover/tooltip:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">Delete
                                                Vehicle</span>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="px-6 py-12 text-center text-gray-500 text-xs">
                                No vehicles found.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        @if($vehicles->hasPages())
            <div class="px-4 py-3 border-t border-gray-200 bg-gray-50">
                {{ $vehicles->links() }}
            </div>
        @endif
    </div>
@endsection