@extends('layouts.user')

@section('title', 'Help Guide')

@section('content')
    <div class="space-y-6">
        <!-- Header -->
        <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm">
            <h1 class="text-2xl font-bold text-gray-800">Help Guide & Documentation</h1>
            <p class="text-gray-500 mt-2">Comprehensive guide for managing employees, schedules, analytics, and more.
            </p>
        </div>

        <!-- Employee Management -->
        <h3 class="text-xl font-bold text-gray-800 px-1 pt-2">Employee Management</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Employee Views -->
            <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm">
                <div class="flex items-center gap-3 mb-4">
                    <div class="p-2 bg-green-50 rounded-lg text-green-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                    </div>
                    <h2 class="text-lg font-bold text-gray-800">Employee Details View</h2>
                </div>
                <div class="space-y-4 text-sm text-gray-600">
                    <p>When you click on an employee (e.g., <code>/employees/83</code>), you access their full profile
                        management:</p>
                    <ul class="list-disc list-inside space-y-1 ml-1 text-gray-500">
                        <li><strong>Profile Info:</strong> Edit personal details, contact info, and role assignments.</li>
                        <li><strong>Wage Settings:</strong> Configure unique hourly rates, holiday rates, and wage types
                            (Regular, Overtime).</li>
                        <li><strong>Documents:</strong> Upload and track expiry for Licenses, ID Cards, and Certifications.
                        </li>
                        <li><strong>Site Access:</strong> Use the "Ban Sites" feature to restrict an employee from specific
                            locations.</li>
                        <li><strong>History:</strong> View a complete history of their assigned schedules and attendance.
                        </li>
                    </ul>
                    <div class="bg-green-50 p-3 rounded-lg border border-green-100 mt-2">
                        <span class="text-xs font-bold text-green-700 uppercase">Feature</span>
                        <p class="text-xs text-green-600 mt-1">Check the <strong>"Analytics"</strong> tab on their profile
                            for a graphical view of their punctuality and performance ratings.</p>
                    </div>
                </div>
            </div>

            <!-- Schedule Templates -->
            <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm">
                <div class="flex items-center gap-3 mb-4">
                    <div class="p-2 bg-purple-50 rounded-lg text-purple-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z">
                            </path>
                        </svg>
                    </div>
                    <h2 class="text-lg font-bold text-gray-800">Schedule Templates</h2>
                </div>
                <div class="space-y-4 text-sm text-gray-600">
                    <p>Create reusable shift patterns for specific sites to speed up rostering:</p>
                    <ol class="list-decimal list-inside space-y-1 ml-1 text-gray-500">
                        <li>Navigate to <strong>Sites</strong> and select a specific site.</li>
                        <li>Click the <strong>"Schedule Templates"</strong> button (or accessed via the Site Action menu).
                        </li>
                        <li><strong>Create Template:</strong> Name your template (e.g., "Weekdays - Night Shift").</li>
                        <li><strong>Add Shifts:</strong> Define start/end times and the number of guards needed for each
                            shift slot.</li>
                        <li><strong>Roll Schedule:</strong> Use the "Roll" feature to apply this template to future dates.
                            The system will create "Draft" schedules which you can then assign employees to.</li>
                    </ol>
                </div>
            </div>
        </div>

        <!-- Advanced Employee Actions -->
        <h3 class="text-xl font-bold text-gray-800 px-1 pt-2">Advanced Employee Actions</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Banning Employees -->
            <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm">
                <div class="flex items-center gap-3 mb-4">
                    <div class="p-2 bg-red-50 rounded-lg text-red-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                            </path>
                        </svg>
                    </div>
                    <h2 class="text-lg font-bold text-gray-800">Review & Ban Access</h2>
                </div>
                <div class="space-y-4 text-sm text-gray-600">
                    <p><strong>Ban from Site:</strong></p>
                    <ol class="list-decimal list-inside space-y-1 ml-1 text-gray-500">
                        <li>Go to <strong>Employees > [Select Employee]</strong>.</li>
                        <li>Click on the <strong>"Ban Sites"</strong> tab.</li>
                        <li>Select the sites you want to restrict them from and click **Update**. They will no longer appear
                            in the schedule dropdown for those sites.</li>
                    </ol>

                    <p class="pt-2"><strong>Global Deactivation:</strong></p>
                    <ul class="list-disc list-inside space-y-1 ml-1 text-gray-500">
                        <li>In the **Employees List**, find the employee.</li>
                        <li>Toggle the **Status Switch** (Active/Inactive).</li>
                        <li>Inactive employees cannot log in to the mobile app.</li>
                    </ul>
                </div>
            </div>

            <!-- Password Management -->
            <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm">
                <div class="flex items-center gap-3 mb-4">
                    <div class="p-2 bg-yellow-50 rounded-lg text-yellow-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 19l-1 1-1-1-1 1-1-1-1 1H6a2 2 0 00-2 2v4a2 2 0 002 2h14a2 2 0 002-2v-4a2 2 0 00-2-2h-1">
                            </path>
                        </svg>
                    </div>
                    <h2 class="text-lg font-bold text-gray-800">Password Management</h2>
                </div>
                <div class="space-y-4 text-sm text-gray-600">
                    <p>If an employee forgets their password:</p>
                    <ol class="list-decimal list-inside space-y-1 ml-1 text-gray-500">
                        <li>Navigate to <strong>Employees > [Select Employee]</strong>.</li>
                        <li>Click the <strong>"Change Password"</strong> button (usually top right or in profile actions).
                        </li>
                        <li>Enter a new temporary password (e.g., `Password@123`).</li>
                        <li>Click **Update**. The employee can now login with this new credential.</li>
                    </ol>
                    <p class="text-xs text-yellow-600 mt-2">
                        <span class="font-bold">Note:</span> Advise employees to change their password immediately after
                        logging in for security.
                    </p>
                </div>
            </div>
        </div>

        <!-- Communication & System Logs -->
        <h3 class="text-xl font-bold text-gray-800 px-1 pt-2">Communication & System Logs</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Notifications & Campaigns -->
            <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm">
                <div class="flex items-center gap-3 mb-4">
                    <div class="p-2 bg-blue-50 rounded-lg text-blue-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z">
                            </path>
                        </svg>
                    </div>
                    <h2 class="text-lg font-bold text-gray-800">Communication Tools</h2>
                </div>
                <div class="space-y-4 text-sm text-gray-600">
                    <p><strong>Send Notifications (Broadcast):</strong></p>
                    <ul class="list-disc list-inside space-y-1 ml-1 text-gray-500">
                        <li>Click the **Megaphone Icon** in the top header bar.</li>
                        <li>Select "All Employees" or choose specific individuals.</li>
                        <li>Enter Title, Message, and optional Redirect URL.</li>
                        <li>Click **Send**. This pushes a notification to their mobile app immediately.</li>
                    </ul>

                    <p class="pt-2"><strong>Email Campaigns:</strong></p>
                    <ul class="list-disc list-inside space-y-1 ml-1 text-gray-500">
                        <li>Navigate to <strong>Campaigns</strong> in the sidebar.</li>
                        <li>Click **Create Campaign**.</li>
                        <li>Compose your email using the rich text editor.</li>
                        <li>Select target audience (e.g., "All Guards at Site X").</li>
                        <li>Send immediately or schedule for later.</li>
                    </ul>
                </div>
            </div>

            <!-- Activity Logs -->
            <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm">
                <div class="flex items-center gap-3 mb-4">
                    <div class="p-2 bg-gray-100 rounded-lg text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                            </path>
                        </svg>
                    </div>
                    <h2 class="text-lg font-bold text-gray-800">System Logs & Audits</h2>
                </div>
                <div class="space-y-4 text-sm text-gray-600">
                    <p>Track all actions performed within the system for security and accountability:</p>
                    <ol class="list-decimal list-inside space-y-1 ml-1 text-gray-500">
                        <li>Click the **Activity Logs** icon <svg class="w-4 h-4 inline" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg> in the sidebar (bottom section).</li>
                        <li>You will see a chronological list of actions (Logins, Creations, Deletes, Updates).</li>
                        <li>Use the filters to find actions by specific users or date ranges.</li>
                        <li><strong>Click "Export PDF"</strong> at the top right to download a formal audit report.</li>
                    </ol>
                </div>
            </div>
        </div>

        <h3 class="text-xl font-bold text-gray-800 px-1">Scheduling Operations</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">

            <!-- Guard Schedules -->
            <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm">
                <div class="flex items-center gap-3 mb-4">
                    <div class="p-2 bg-blue-50 rounded-lg text-blue-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z">
                            </path>
                        </svg>
                    </div>
                    <h2 class="text-lg font-bold text-gray-800">Guard Schedules</h2>
                </div>
                <div class="space-y-4 text-sm text-gray-600">
                    <p><strong>Creating a Schedule:</strong></p>
                    <ol class="list-decimal list-inside space-y-1 ml-1 text-gray-500">
                        <li>Navigate to <strong>Schedules > Guard Schedule</strong>.</li>
                        <li>Click <strong>Add Schedule</strong>.</li>
                        <li>Select the <strong>Site</strong> from the dropdown.</li>
                        <li>Choose <strong>Date & Time</strong>. For overnight shifts (e.g., 10 PM to 6 AM), the system
                            handles the date crossover automatically.</li>
                    </ol>

                    <p class="pt-2"><strong>Assigning Multiple Employees:</strong></p>
                    <ul class="list-disc list-inside space-y-1 ml-1 text-gray-500">
                        <li>In the "Employees" verification section, you can search and select multiple guards.</li>
                        <li>The system will automatically validate availability for ALL selected employees.</li>
                        <li>If "Individual Pricing" is enabled, you can set specific rates for each guard in the list.</li>
                    </ul>

                    <div class="bg-blue-50 p-3 rounded-lg border border-blue-100 mt-2">
                        <span class="text-xs font-bold text-blue-700 uppercase">Tip</span>
                        <p class="text-xs text-blue-600 mt-1">Use the <strong>"Recurrence"</strong> option to create valid
                            shifts for weeks or months in advance automatically.</p>
                    </div>
                </div>
            </div>

            <!-- Patroller Schedules -->
            <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm">
                <div class="flex items-center gap-3 mb-4">
                    <div class="p-2 bg-indigo-50 rounded-lg text-indigo-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                    </div>
                    <h2 class="text-lg font-bold text-gray-800">Patroller Schedules</h2>
                </div>
                <div class="space-y-4 text-sm text-gray-600">
                    <p><strong>Setting up Patrols:</strong></p>
                    <ol class="list-decimal list-inside space-y-1 ml-1 text-gray-500">
                        <li>Navigate to <strong>Schedules > Patroller Schedule</strong>.</li>
                        <li>Select a defined <strong>Route</strong> (created in Masters > Routes).</li>
                        <li>Assign a <strong>Driver/Patroller</strong>.</li>
                        <li>The system will list all checkpoints (sites) associated with that route automatically.</li>
                    </ol>

                    <p class="pt-2"><strong>Execution:</strong></p>
                    <ul class="list-disc list-inside space-y-1 ml-1 text-gray-500">
                        <li>Patrollers check in at the route level to start the shift.</li>
                        <li>They must then visit each site in sequence to complete the route.</li>
                        <li>Tickets and Incidents can be reported per site.</li>
                    </ul>
                </div>
            </div>

            <!-- Addon Jobs -->
            <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm">
                <div class="flex items-center gap-3 mb-4">
                    <div class="p-2 bg-orange-50 rounded-lg text-orange-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h2 class="text-lg font-bold text-gray-800">Addon / Manual Jobs</h2>
                </div>
                <div class="space-y-4 text-sm text-gray-600">
                    <p>Used for unscheduled or emergency deployments handled manually.</p>
                    <ol class="list-decimal list-inside space-y-1 ml-1 text-gray-500">
                        <li>Go to <strong>Schedules > Addon Schedule</strong>.</li>
                        <li>This table tracks jobs that were not pre-planned in the roster.</li>
                        <li><strong>Manual Completion:</strong> If an employee cannot use the app, an admin can click
                            "Complete Manually" here.</li>
                        <li>You will need to upload evidence (Check-in/out photos) and set the times manually.</li>
                    </ol>
                </div>
            </div>

            <!-- Bulk Operations -->
            <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm">
                <div class="flex items-center gap-3 mb-4">
                    <div class="p-2 bg-purple-50 rounded-lg text-purple-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10">
                            </path>
                        </svg>
                    </div>
                    <h2 class="text-lg font-bold text-gray-800">Bulk Operations</h2>
                </div>
                <div class="space-y-4 text-sm text-gray-600">
                    <p><strong>Employees:</strong></p>
                    <ul class="list-disc list-inside space-y-1 ml-1 text-gray-500">
                        <li>In the <strong>Employees</strong> list, select checkboxes next to names.</li>
                        <li>Use the "Bulk Actions" dropdown to update status (Active/Inactive) or assign common settings.
                        </li>
                    </ul>

                    <p class="pt-2"><strong>Schedules:</strong></p>
                    <ul class="list-disc list-inside space-y-1 ml-1 text-gray-500">
                        <li>In the <strong>Schedules</strong> view, use the selection checkboxes.</li>
                        <li><strong>Bulk Publish:</strong> Convert multiple "Draft" schedules to "Published" instantly.</li>
                        <li><strong>Bulk Delete:</strong> Remove multiple erroneous entries at once.</li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Management & Analytics -->
        <h3 class="text-xl font-bold text-gray-800 px-1 pt-4">Analytics & Reporting</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">

            <!-- Checking Analytics -->
            <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm">
                <div class="flex items-center gap-3 mb-4">
                    <div class="p-2 bg-teal-50 rounded-lg text-teal-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z">
                            </path>
                        </svg>
                    </div>
                    <h2 class="text-lg font-bold text-gray-800">Checking Analytics</h2>
                </div>
                <div class="space-y-4 text-sm text-gray-600">
                    <p>Gain insights into your workforce performance:</p>
                    <ul class="list-disc list-inside space-y-1 ml-1 text-gray-500">
                        <li><strong>Live Dashboard:</strong> Shows real-time attendance stats, upcoming shifts, and active
                            issues.</li>
                        <li><strong>Attendance Chart:</strong> Visualizes punctuality trends over weeks or months.</li>
                        <li><strong>Employee Analytics:</strong> Go to an Employee's profile and click the "Analytics" tab
                            to see their personal attendance rating, total hours, and incident history.</li>
                    </ul>
                </div>
            </div>

            <!-- Reports -->
            <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm">
                <div class="flex items-center gap-3 mb-4">
                    <div class="p-2 bg-rose-50 rounded-lg text-rose-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                            </path>
                        </svg>
                    </div>
                    <h2 class="text-lg font-bold text-gray-800">Reports</h2>
                </div>
                <div class="space-y-4 text-sm text-gray-600">
                    <p>Exportable data for payroll and compliance:</p>
                    <ul class="list-disc list-inside space-y-1 ml-1 text-gray-500">
                        <li><strong>Operational Reports:</strong> Detailed breakdown of sites visited vs. scheduled.</li>
                        <li><strong>Payout Reports:</strong> Auto-calculated wage sheets based on verified check-in hours.
                        </li>
                        <li><strong>Incident Reports:</strong> Summaries of all reported issues, downloadable as PDF or ZIP
                            (with evidence).</li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Technical Support -->
        <div class="bg-slate-900 rounded-xl p-8 text-white shadow-lg mt-8">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <!-- Contact Info -->
                <div>
                    <h2 class="text-2xl font-bold mb-4">Technical Support</h2>
                    <p class="text-slate-300 mb-6">Encountering an issue or have a bug to report? Our support team is ready
                        to help 24/7. Please fill out the form or email us directly.</p>

                    <div class="flex items-center gap-4 bg-white/10 p-4 rounded-lg backdrop-blur-sm mb-4">
                        <div class="p-2 bg-white/20 rounded-full">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                                </path>
                            </svg>
                        </div>
                        <div>
                            <span class="block text-xs uppercase tracking-wider text-slate-400">Email Us</span>
                            <a href="mailto:itsupport@thefalconsecurity.com"
                                class="font-bold hover:underline">itsupport@thefalconsecurity.com</a>
                        </div>
                    </div>
                </div>

                <!-- Report Issue Form -->
                <div class="bg-white rounded-lg p-6 text-gray-800">
                    <h3 class="text-lg font-bold mb-4">Report an Issue</h3>
                    <form action="{{ route('user.help.report') }}" method="POST" class="space-y-4">
                        @csrf
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Subject</label>
                            <input type="text" name="subject" required
                                class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm p-2 border"
                                placeholder="e.g., Cannot upload schedule">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                            <textarea name="message" rows="3" required
                                class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm p-2 border"
                                placeholder="Describe the issue you are facing..."></textarea>
                        </div>
                        <button type="submit"
                            class="w-full bg-blue-600 text-white rounded-md py-2 px-4 hover:bg-blue-700 font-medium transition-colors">
                            Submit Ticket
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection