@extends('layouts.user')

@section('title', 'Tutorial Videos')

@section('content')
    <div class="p-6">
        <div class="mb-6">
            <h1 class="text-2xl font-bold text-gray-800">Tutorial Videos</h1>
            <p class="text-gray-500">Learn how to use the Shift Matrix platform effectively.</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <!-- Add Site Tutorial -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
                <div class="aspect-video bg-gray-100 relative group cursor-pointer"
                    onclick="playVideo('{{ asset('videos/add_site_tutorial.webp') }}', 'How to Add a Site')">
                    <div class="absolute inset-0 flex items-center justify-center">
                        <div
                            class="w-16 h-16 bg-white/90 rounded-full flex items-center justify-center shadow-lg group-hover:scale-110 transition-transform">
                            <svg class="w-8 h-8 text-blue-600 ml-1" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M8 5v14l11-7z" />
                            </svg>
                        </div>
                    </div>
                    <div class="absolute bottom-0 left-0 right-0 p-4 bg-gradient-to-t from-black/60 to-transparent">
                        <span class="text-white font-bold text-sm">How to Add a Site</span>
                    </div>
                </div>
                <div class="p-4">
                    <h3 class="font-bold text-gray-900 mb-1">How to Add a Site</h3>
                    <p class="text-sm text-gray-500">Step-by-step guide on creating and configuring new client sites.</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Video Modal -->
    <div x-data="{ show: false, src: '', title: '' }"
        @open-video.window="show = true; src = $event.detail.src; title = $event.detail.title" x-show="show"
        class="fixed inset-0 z-50 flex items-center justify-center p-4" x-cloak style="display: none;">
        <div class="absolute inset-0 bg-black/80 backdrop-blur-sm" @click="show = false; src = ''"></div>
        <div class="relative bg-black rounded-xl shadow-2xl w-full max-w-5xl overflow-hidden">
            <div class="p-4 flex justify-between items-center bg-gray-900 text-white">
                <h3 class="font-bold" x-text="title"></h3>
                <button @click="show = false; src = ''" class="text-gray-400 hover:text-white">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            <div class="aspect-video bg-black flex items-center justify-center">
                <template x-if="show">
                    <img :src="src" class="w-full h-full object-contain">
                </template>
            </div>
        </div>
    </div>

    <script>
        function playVideo(src, title) {
            window.dispatchEvent(new CustomEvent('open-video', { detail: { src, title } }));
        }
    </script>
@endsection