@extends('layouts.user')

@section('title', 'Site List')

@section('content')
    <div class="flex flex-col h-full">
        <!-- Toolbar & Filters -->
        <div class="bg-white border-b border-gray-100 px-8 py-6">
            <div class="flex flex-col lg:flex-row lg:items-center justify-between gap-6">
                <div>
                    <h1 class="text-2xl font-black text-slate-900 tracking-tight">Site Management</h1>
                    <p class="text-xs text-slate-500 font-medium mt-1">Manage and monitor all {{ $sites->total() }} service
                        locations.</p>
                </div>

                <div class="flex flex-wrap items-center gap-3">
                    <form id="search-form" action="{{ route('sites.index') }}" method="GET" class="flex items-center gap-3">
                        <div class="relative group">
                            <input type="text" name="search" id="search-input" value="{{ request('search') }}" placeholder="Search sites..."
                                class="w-64 pl-10 pr-10 py-2.5 bg-slate-50 border border-slate-200 rounded-2xl text-xs focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all group-hover:bg-white">
                            <svg class="absolute left-3.5 top-1/2 -translate-y-1/2 w-4 h-4 text-slate-400" fill="none"
                                stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                            <a href="{{ route('sites.index') }}" id="clear-search"
                                class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-red-500 transition-colors {{ request('search') ? '' : 'hidden' }}"
                                title="Clear Search">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                                    </path>
                                </svg>
                            </a>
                        </div>

                        <button type="submit"
                            class="p-2.5 bg-blue-600 text-white rounded-2xl shadow-lg shadow-blue-500/30 hover:bg-blue-700 transition-all">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                        </button>
                    </form>

                    <div class="h-8 w-px bg-slate-200 mx-2"></div>

                    <a href="{{ route('sites.export-excel', request()->all()) }}" target="_blank"
                        class="flex items-center gap-2 px-6 py-2.5 bg-green-600 text-white rounded-2xl shadow-lg shadow-green-200/50 hover:bg-green-700 transition-all text-xs font-bold uppercase tracking-wider">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                        </svg>
                        Export Excel
                    </a>

                    <a href="{{ route('sites.export-pdf', request()->all()) }}" target="_blank"
                        class="flex items-center gap-2 px-6 py-2.5 bg-red-600 text-white rounded-2xl shadow-lg shadow-red-200/50 hover:bg-red-700 transition-all text-xs font-bold uppercase tracking-wider">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                        </svg>
                        Export PDF
                    </a>

                    @can('create site')
                        <a href="{{ route('sites.create') }}"
                            class="flex items-center gap-2 px-6 py-2.5 bg-slate-900 text-white rounded-2xl shadow-lg shadow-slate-200/50 hover:bg-slate-800 transition-all text-xs font-bold uppercase tracking-wider">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                            </svg>
                            Add New Site
                        </a>
                    @endcan

                    @can('edit site')
                        <button type="button" onclick="openBulkUpdateModal()" id="bulk-update-btn" style="display: none;"
                            class="px-4 py-2.5 bg-purple-600 text-white font-bold rounded-2xl hover:bg-purple-700 transition-all shadow-lg shadow-purple-500/20 flex items-center gap-2 text-xs uppercase tracking-wider">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                                </path>
                            </svg>
                            Bulk Update <span id="selected-count"
                                class="bg-purple-800 text-white text-[10px] px-1.5 py-0.5 rounded-md ml-1">0</span>
                        </button>

                        <button type="button" onclick="openCopyModal()" id="copy-btn" style="display: none;"
                            class="px-4 py-2.5 bg-amber-600 text-white font-bold rounded-2xl hover:bg-amber-700 transition-all shadow-lg shadow-amber-500/20 flex items-center gap-2 text-xs uppercase tracking-wider">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z">
                                </path>
                            </svg>
                            Copy <span id="copy-count"
                                class="bg-amber-800 text-white text-[10px] px-1.5 py-0.5 rounded-md ml-1">0</span>
                        </button>
                    @endcan
                </div>
            </div>
        </div>

        @if(session('success'))
            <div
                class="m-4 p-3 bg-emerald-50 border border-emerald-100 text-emerald-700 rounded text-xs flex items-center gap-2">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                </svg>
                {{ session('success') }}
            </div>
        @endif

        <!-- Table -->
        <div id="table-wrapper" class="flex-1 overflow-auto bg-white">
            @include('sites._table')
        </div>
    </div>

    <!-- Bulk Update Modal -->
    <div id="bulk-update-modal"
        class="fixed inset-0 bg-slate-900/50 backdrop-blur-sm z-[9999] hidden items-center justify-center">
        <div class="bg-white w-full max-w-7xl h-[90vh] rounded-2xl shadow-2xl overflow-hidden flex flex-col">
            <div class="flex justify-between items-center p-6 border-b border-gray-100 bg-gray-50">
                <div>
                    <h3 class="text-xl font-bold text-gray-900">Bulk Update Sites</h3>
                    <p class="text-xs text-gray-500 mt-1">Edit values for individual sites below.</p>
                </div>
                <button type="button" onclick="closeBulkUpdateModal()" class="text-gray-400 hover:text-gray-600">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                        </path>
                    </svg>
                </button>
            </div>

            <form action="{{ route('sites.bulk-update') }}" method="POST" class="flex-1 overflow-hidden flex flex-col">
                @csrf
                <div class="flex-1 overflow-y-auto p-6">
                    <table class="min-w-full divide-y divide-gray-200 border-separate border-spacing-0">
                        <thead class="bg-gray-50">
                            <tr>
                                <th
                                    class="px-3 py-2 text-left text-xs font-bold text-gray-500 uppercase tracking-wider sticky top-0 bg-gray-50 z-10">
                                    Site</th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-bold text-gray-500 uppercase tracking-wider sticky top-0 bg-gray-50 z-10 w-28">
                                    Rate
                                    <div
                                        class="flex items-center gap-1 mt-1 opacity-50 hover:opacity-100 transition-opacity">
                                        <input type="checkbox" id="copy-rate-all" onchange="copyValueToAll('rate', this)"
                                            class="rounded border-gray-300 text-purple-600 focus:ring-purple-500 w-3 h-3 cursor-pointer">
                                        <label for="copy-rate-all"
                                            class="text-[9px] text-gray-400 cursor-pointer select-none">Copy 1st</label>
                                    </div>
                                </th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-bold text-gray-500 uppercase tracking-wider sticky top-0 bg-gray-50 z-10 w-48">
                                    Address 1
                                    <div
                                        class="flex items-center gap-1 mt-1 opacity-50 hover:opacity-100 transition-opacity">
                                        <input type="checkbox" id="copy-address-all"
                                            onchange="copyValueToAll('address_line_1', this)"
                                            class="rounded border-gray-300 text-purple-600 focus:ring-purple-500 w-3 h-3 cursor-pointer">
                                        <label for="copy-address-all"
                                            class="text-[9px] text-gray-400 cursor-pointer select-none">Copy 1st</label>
                                    </div>
                                </th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-bold text-gray-500 uppercase tracking-wider sticky top-0 bg-gray-50 z-10 w-32">
                                    Country
                                    <div
                                        class="flex items-center gap-1 mt-1 opacity-50 hover:opacity-100 transition-opacity">
                                        <input type="checkbox" id="copy-country-all"
                                            onchange="copySelectToAll('country_id', this)"
                                            class="rounded border-gray-300 text-purple-600 focus:ring-purple-500 w-3 h-3 cursor-pointer">
                                        <label for="copy-country-all"
                                            class="text-[9px] text-gray-400 cursor-pointer select-none">Copy 1st</label>
                                    </div>
                                </th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-bold text-gray-500 uppercase tracking-wider sticky top-0 bg-gray-50 z-10 w-32">
                                    State
                                    <div
                                        class="flex items-center gap-1 mt-1 opacity-50 hover:opacity-100 transition-opacity">
                                        <input type="checkbox" id="copy-state-all"
                                            onchange="copySelectToAll('state_id', this)"
                                            class="rounded border-gray-300 text-purple-600 focus:ring-purple-500 w-3 h-3 cursor-pointer">
                                        <label for="copy-state-all"
                                            class="text-[9px] text-gray-400 cursor-pointer select-none">Copy 1st</label>
                                    </div>
                                </th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-bold text-gray-500 uppercase tracking-wider sticky top-0 bg-gray-50 z-10 w-32">
                                    City
                                    <div
                                        class="flex items-center gap-1 mt-1 opacity-50 hover:opacity-100 transition-opacity">
                                        <input type="checkbox" id="copy-city-all" onchange="copyValueToAll('city', this)"
                                            class="rounded border-gray-300 text-purple-600 focus:ring-purple-500 w-3 h-3 cursor-pointer">
                                        <label for="copy-city-all"
                                            class="text-[9px] text-gray-400 cursor-pointer select-none">Copy 1st</label>
                                    </div>
                                </th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-bold text-gray-500 uppercase tracking-wider sticky top-0 bg-gray-50 z-10 w-24">
                                    Zipcode
                                    <div
                                        class="flex items-center gap-1 mt-1 opacity-50 hover:opacity-100 transition-opacity">
                                        <input type="checkbox" id="copy-zip-all" onchange="copyValueToAll('zip_code', this)"
                                            class="rounded border-gray-300 text-purple-600 focus:ring-purple-500 w-3 h-3 cursor-pointer">
                                        <label for="copy-zip-all"
                                            class="text-[9px] text-gray-400 cursor-pointer select-none">Copy 1st</label>
                                    </div>
                                </th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-bold text-gray-500 uppercase tracking-wider sticky top-0 bg-gray-50 z-10 w-24">
                                    Lat
                                    <div
                                        class="flex items-center gap-1 mt-1 opacity-50 hover:opacity-100 transition-opacity">
                                        <input type="checkbox" id="copy-lat-all" onchange="copyValueToAll('latitude', this)"
                                            class="rounded border-gray-300 text-purple-600 focus:ring-purple-500 w-3 h-3 cursor-pointer">
                                        <label for="copy-lat-all"
                                            class="text-[9px] text-gray-400 cursor-pointer select-none">Copy 1st</label>
                                    </div>
                                </th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-bold text-gray-500 uppercase tracking-wider sticky top-0 bg-gray-50 z-10 w-24">
                                    Long
                                    <div
                                        class="flex items-center gap-1 mt-1 opacity-50 hover:opacity-100 transition-opacity">
                                        <input type="checkbox" id="copy-long-all"
                                            onchange="copyValueToAll('longitude', this)"
                                            class="rounded border-gray-300 text-purple-600 focus:ring-purple-500 w-3 h-3 cursor-pointer">
                                        <label for="copy-long-all"
                                            class="text-[9px] text-gray-400 cursor-pointer select-none">Copy 1st</label>
                                    </div>
                                </th>
                            </tr>
                        </thead>
                        <tbody id="bulk-update-tbody" class="bg-white divide-y divide-gray-100">
                            <!-- Rows will be injected by JS -->
                        </tbody>
                    </table>
                </div>

                <div class="p-6 border-t border-gray-100 bg-gray-50 flex justify-end gap-3 z-20">
                    <button type="button" onclick="closeBulkUpdateModal()"
                        class="px-4 py-2 bg-white text-gray-700 font-bold rounded-xl border border-gray-200 hover:bg-gray-50 transition-all text-sm">Cancel</button>
                    <button type="submit"
                        class="px-6 py-2 bg-purple-600 text-white font-bold rounded-xl hover:bg-purple-700 transition-all shadow-md shadow-purple-500/20 text-sm">Save
                        Changes</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Copy Modal -->
    <div id="copy-modal" class="fixed inset-0 bg-slate-900/50 backdrop-blur-sm z-[9999] hidden items-center justify-center">
        <div class="bg-white p-8 rounded-3xl shadow-2xl flex flex-col gap-6 max-w-md w-full">
            <div>
                <h3 class="text-xl font-bold text-gray-900">Copy Sites</h3>
                <p class="text-sm text-gray-500 mt-1">Select the target company to copy <span id="copy-modal-count"
                        class="font-bold text-gray-800">0</span> sites to.</p>
            </div>

            <form action="{{ route('sites.copy') }}" method="POST" class="flex flex-col gap-4">
                @csrf
                <div id="copy-hidden-inputs"></div>

                <div>
                    <label class="block text-xs font-bold text-gray-700 uppercase tracking-wider mb-2">Target
                        Company</label>
                    <select name="target_company_id" required
                        class="w-full bg-gray-50 border border-gray-200 rounded-xl px-4 py-3 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                        <option value="">Select Company</option>
                        @foreach($targetCompanies as $company)
                            <option value="{{ $company->id }}">{{ $company->name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="flex justify-end gap-3 mt-2">
                    <button type="button" onclick="closeCopyModal()"
                        class="px-5 py-2.5 bg-white text-gray-700 font-bold rounded-xl border border-gray-200 hover:bg-gray-50 transition-all text-sm">Cancel</button>
                    <button type="submit"
                        class="px-5 py-2.5 bg-blue-600 text-white font-bold rounded-xl hover:bg-blue-700 transition-all shadow-md shadow-blue-500/20 text-sm">Copy
                        Sites</button>
                </div>
            </form>
        </div>
    </div>

    @push('scripts')
        <script>
            function toggleSelectAll() {
                const selectAll = document.getElementById('select-all');
                const checkboxes = document.querySelectorAll('.site-checkbox');
                checkboxes.forEach(cb => cb.checked = selectAll.checked);
                updateBulkButton();
            }

            function updateBulkButton() {
                const checked = document.querySelectorAll('.site-checkbox:checked').length;
                const btn = document.getElementById('bulk-update-btn');
                const copyBtn = document.getElementById('copy-btn');
                const countSpan = document.getElementById('selected-count');
                const copyCountSpan = document.getElementById('copy-count');
                if (countSpan) countSpan.innerText = checked;
                if (copyCountSpan) copyCountSpan.innerText = checked;

                if (btn) {
                    if (checked > 0) {
                        btn.style.display = 'flex';
                        if (copyBtn) {
                            copyBtn.classList.remove('hidden');
                            copyBtn.style.display = 'flex';
                        }
                    } else {
                        btn.style.display = 'none';
                        if (copyBtn) {
                            copyBtn.classList.add('hidden');
                            copyBtn.style.display = 'none';
                        }
                    }
                }
            }

            function openCopyModal() {
                const checked = document.querySelectorAll('.site-checkbox:checked');
                if (checked.length === 0) return;

                document.getElementById('copy-modal-count').innerText = checked.length;
                const container = document.getElementById('copy-hidden-inputs');
                container.innerHTML = '';

                checked.forEach(cb => {
                    const input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = 'site_ids[]';
                    input.value = cb.value;
                    container.appendChild(input);
                });

                document.getElementById('copy-modal').classList.remove('hidden');
                document.getElementById('copy-modal').classList.add('flex');
            }

            function closeCopyModal() {
                document.getElementById('copy-modal').classList.add('hidden');
                document.getElementById('copy-modal').classList.remove('flex');
            }

            function copyValueToAll(field, checkbox) {
                if (!checkbox.checked) return;

                const inputs = document.querySelectorAll(`input[name*="[${field}]"]`);
                if (inputs.length === 0) return;

                const firstValue = inputs[0].value;
                if (!firstValue) return;

                inputs.forEach(input => {
                    input.value = firstValue;
                });

                setTimeout(() => checkbox.checked = false, 200);
            }

            function copySelectToAll(field, checkbox) {
                if (!checkbox.checked) return;

                const selects = document.querySelectorAll(`select[name*="[${field}]"]`);
                if (selects.length === 0) return;

                const firstValue = selects[0].value;
                if (!firstValue) return;

                selects.forEach(select => {
                    select.value = firstValue;
                });

                setTimeout(() => checkbox.checked = false, 200);
            }

            function openBulkUpdateModal() {
                const checked = document.querySelectorAll('.site-checkbox:checked');
                const tbody = document.getElementById('bulk-update-tbody');
                tbody.innerHTML = '';

                // Countries and States
                const countries = @json(\App\Models\Country::all());
                const states = @json(\App\Models\State::all());

                let countryOptions = '<option value="">Select Country</option>';
                countries.forEach(c => {
                    countryOptions += `<option value="${c.id}">${c.name}</option>`;
                });

                let stateOptions = '<option value="">Select State</option>';
                states.forEach(s => {
                    stateOptions += `<option value="${s.id}">${s.name}</option>`;
                });

                checked.forEach(cb => {
                    const id = cb.value;
                    const name = cb.dataset.name;
                    const rate = cb.dataset.rate || '';
                    const address = cb.dataset.address || '';
                    const countryId = cb.dataset.country;
                    const stateId = cb.dataset.state;
                    const city = cb.dataset.city || '';
                    const zip = cb.dataset.zip || '';
                    const lat = cb.dataset.lat || '';
                    const long = cb.dataset.long || '';

                    const row = `
                                                <tr class="hover:bg-gray-50 group">
                                                    <td class="px-3 py-3 whitespace-nowrap">
                                                        <span class="text-xs font-bold text-gray-700">${name}</span>
                                                        <span class="block text-[9px] text-gray-400">ID: ${id}</span>
                                                    </td>
                                                    <td class="px-3 py-3 whitespace-nowrap">
                                                        <input type="number" step="0.01" name="sites[${id}][rate]" value="${rate}" class="w-24 bg-white border border-gray-200 rounded-lg px-2 py-1.5 text-xs focus:ring-1 focus:ring-blue-500 outline-none" placeholder="Rate">
                                                    </td>
                                                    <td class="px-3 py-3 whitespace-nowrap">
                                                        <input type="text" name="sites[${id}][address_line_1]" value="${address}" class="w-40 bg-white border border-gray-200 rounded-lg px-2 py-1.5 text-xs focus:ring-1 focus:ring-blue-500 outline-none" placeholder="Address">
                                                    </td>
                                                    <td class="px-3 py-3 whitespace-nowrap">
                                                        <select name="sites[${id}][country_id]" class="w-32 bg-white border border-gray-200 rounded-lg px-2 py-1.5 text-xs focus:ring-1 focus:ring-blue-500 outline-none">
                                                            ${countryOptions.replace(`value="${countryId}"`, `value="${countryId}" selected`)}
                                                        </select>
                                                    </td>
                                                    <td class="px-3 py-3 whitespace-nowrap">
                                                        <select name="sites[${id}][state_id]" class="w-32 bg-white border border-gray-200 rounded-lg px-2 py-1.5 text-xs focus:ring-1 focus:ring-blue-500 outline-none">
                                                            ${stateOptions.replace(`value="${stateId}"`, `value="${stateId}" selected`)}
                                                        </select>
                                                    </td>
                                                    <td class="px-3 py-3 whitespace-nowrap">
                                                        <input type="text" name="sites[${id}][city]" value="${city}" class="w-32 bg-white border border-gray-200 rounded-lg px-2 py-1.5 text-xs focus:ring-1 focus:ring-blue-500 outline-none" placeholder="City">
                                                    </td>
                                                    <td class="px-3 py-3 whitespace-nowrap">
                                                        <input type="text" name="sites[${id}][zip_code]" value="${zip}" class="w-24 bg-white border border-gray-200 rounded-lg px-2 py-1.5 text-xs focus:ring-1 focus:ring-blue-500 outline-none" placeholder="Zip">
                                                    </td>
                                                    <td class="px-3 py-3 whitespace-nowrap">
                                                        <input type="text" name="sites[${id}][latitude]" value="${lat}" class="w-24 bg-white border border-gray-200 rounded-lg px-2 py-1.5 text-xs focus:ring-1 focus:ring-blue-500 outline-none" placeholder="Lat">
                                                    </td>
                                                    <td class="px-3 py-3 whitespace-nowrap">
                                                        <input type="text" name="sites[${id}][longitude]" value="${long}" class="w-24 bg-white border border-gray-200 rounded-lg px-2 py-1.5 text-xs focus:ring-1 focus:ring-blue-500 outline-none" placeholder="Long">
                                                    </td>
                                                </tr>
                                            `;
                    tbody.innerHTML += row;
                });

                document.getElementById('bulk-update-modal').classList.remove('hidden');
                document.getElementById('bulk-update-modal').classList.add('flex');
            }

            function closeBulkUpdateModal() {
                document.getElementById('bulk-update-modal').classList.add('hidden');
                document.getElementById('bulk-update-modal').classList.remove('flex');
            }

            document.addEventListener('DOMContentLoaded', function() {
                const searchInput = document.getElementById('search-input');
                const searchForm = document.getElementById('search-form');
                const tableWrapper = document.getElementById('table-wrapper');
                const clearSearch = document.getElementById('clear-search');
                let debounceTimer;

                function fetchSites(url = null) {
                    const formData = new FormData(searchForm);
                    const params = new URLSearchParams(formData);
                    
                    if (!url) {
                        url = "{{ route('sites.index') }}?" + params.toString();
                    } else {
                        const targetUrl = new URL(url);
                        params.forEach((value, key) => {
                            if (key !== 'sort' && key !== 'direction' && key !== 'page') {
                                if (!targetUrl.searchParams.has(key)) {
                                    targetUrl.searchParams.append(key, value);
                                }
                            }
                        });
                        url = targetUrl.toString();
                    }

                    window.history.pushState({}, '', url);

                    fetch(url, {
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    })
                    .then(response => response.text())
                    .then(html => {
                        tableWrapper.innerHTML = html;
                        attachListeners();
                        updateBulkButton();
                    })
                    .catch(error => console.error('Error fetching sites:', error));
                }

                function attachListeners() {
                    const paginationLinks = tableWrapper.querySelectorAll('.table-pagination a, .ajax-sort');
                    paginationLinks.forEach(link => {
                        link.addEventListener('click', function(e) {
                            e.preventDefault();
                            fetchSites(this.getAttribute('href'));
                            window.scrollTo({ top: 0, behavior: 'smooth' });
                        });
                    });
                }

                searchInput.addEventListener('input', function() {
                    if (this.value) {
                        clearSearch.classList.remove('hidden');
                    } else {
                        clearSearch.classList.add('hidden');
                    }
                    
                    clearTimeout(debounceTimer);
                    debounceTimer = setTimeout(() => {
                        fetchSites();
                    }, 500);
                });

                searchForm.addEventListener('submit', function(e) {
                    e.preventDefault();
                    fetchSites();
                });

                clearSearch.addEventListener('click', function(e) {
                    e.preventDefault();
                    searchInput.value = '';
                    this.classList.add('hidden');
                    fetchSites();
                });

                window.addEventListener('popstate', function() {
                    location.reload();
                });

                attachListeners();
            });
        </script>
    @endpush
    @push('scripts')
        <script>
            async function toggleSiteStatus(url, button) {
                const circle = button.querySelector('span');
                const isActive = button.getAttribute('aria-checked') === 'true';

                try {
                    // Optimistic UI
                    button.setAttribute('aria-checked', !isActive);
                    if (!isActive) {
                        button.classList.remove('bg-gray-200');
                        button.classList.add('bg-blue-600');
                        circle.classList.remove('translate-x-0');
                        circle.classList.add('translate-x-4');
                    } else {
                        button.classList.remove('bg-blue-600');
                        button.classList.add('bg-gray-200');
                        circle.classList.remove('translate-x-4');
                        circle.classList.add('translate-x-0');
                    }

                    const response = await fetch(url, {
                        method: 'PATCH',
                        headers: {
                            'X-CSRF-TOKEN': '{{ csrf_token() }}',
                            'Accept': 'application/json',
                            'Content-Type': 'application/json'
                        }
                    });

                    const data = await response.json();
                    if (!data.success) throw new Error(data.message || 'Failed to update status');

                } catch (error) {
                    console.error('Error:', error);
                    // Revert UI
                    button.setAttribute('aria-checked', isActive);
                    if (isActive) {
                        button.classList.remove('bg-gray-200');
                        button.classList.add('bg-blue-600');
                        circle.classList.remove('translate-x-0');
                        circle.classList.add('translate-x-4');
                    } else {
                        button.classList.remove('bg-blue-600');
                        button.classList.add('bg-gray-200');
                        circle.classList.remove('translate-x-4');
                        circle.classList.add('translate-x-0');
                    }
                    alert(error.message || 'An error occurred while updating status');
                }
            }
        </script>
    @endpush

@endsection