<table class="min-w-full divide-y divide-gray-200 border-separate border-spacing-0">
    <thead class="bg-[#1e293b] text-white">
        <tr>
            <th scope="col" class="px-6 py-4 text-left border-b border-slate-700 w-8">
                <input type="checkbox" id="select-all" onclick="toggleSelectAll()"
                    class="rounded border-slate-700 bg-slate-800 text-blue-500 focus:ring-blue-500/20">
            </th>
            <th scope="col" class="px-3 py-4 text-left text-[11px] font-bold uppercase tracking-wider w-24">
                <a href="{{ route('sites.index', array_merge(request()->except('page'), ['sort' => 'site_id', 'direction' => request('sort') == 'site_id' && request('direction') == 'asc' ? 'desc' : 'asc'])) }}"
                    class="ajax-sort group flex items-center gap-1 cursor-pointer hover:text-blue-200 transition-colors">
                    Site ID
                    @if(request('sort') == 'site_id')
                        <span class="text-[10px]">{{ request('direction') == 'asc' ? '▲' : '▼' }}</span>
                    @else
                        <span class="text-[10px] opacity-20 group-hover:opacity-100 transition-opacity">↕</span>
                    @endif
                </a>
            </th>
            <th scope="col" class="px-4 py-4 text-left text-[11px] font-bold uppercase tracking-wider">
                <a href="{{ route('sites.index', array_merge(request()->except('page'), ['sort' => 'name', 'direction' => request('sort') == 'name' && request('direction') == 'asc' ? 'desc' : 'asc'])) }}"
                    class="ajax-sort group flex items-center gap-1 cursor-pointer hover:text-blue-200 transition-colors">
                    Site Name
                    @if(request('sort') == 'name')
                        <span class="text-[10px]">{{ request('direction') == 'asc' ? '▲' : '▼' }}</span>
                    @else
                        <span class="text-[10px] opacity-20 group-hover:opacity-100 transition-opacity">↕</span>
                    @endif
                </a>
            </th>
            <th scope="col" class="px-4 py-4 text-left text-[11px] font-bold uppercase tracking-wider">
                <a href="{{ route('sites.index', array_merge(request()->except('page'), ['sort' => 'account_type', 'direction' => request('sort') == 'account_type' && request('direction') == 'asc' ? 'desc' : 'asc'])) }}"
                    class="ajax-sort group flex items-center gap-1 cursor-pointer hover:text-blue-200 transition-colors">
                    Type
                    @if(request('sort') == 'account_type')
                        <span class="text-[10px]">{{ request('direction') == 'asc' ? '▲' : '▼' }}</span>
                    @else
                        <span class="text-[10px] opacity-20 group-hover:opacity-100 transition-opacity">↕</span>
                    @endif
                </a>
            </th>
            <th scope="col" class="px-4 py-4 text-left text-[11px] font-bold uppercase tracking-wider">
                <a href="{{ route('sites.index', array_merge(request()->except('page'), ['sort' => 'rate', 'direction' => request('sort') == 'rate' && request('direction') == 'asc' ? 'desc' : 'asc'])) }}"
                    class="ajax-sort group flex items-center gap-1 cursor-pointer hover:text-blue-200 transition-colors">
                    Rate
                    @if(request('sort') == 'rate')
                        <span class="text-[10px]">{{ request('direction') == 'asc' ? '▲' : '▼' }}</span>
                    @else
                        <span class="text-[10px] opacity-20 group-hover:opacity-100 transition-opacity">↕</span>
                    @endif
                </a>
            </th>
            <th scope="col" class="px-4 py-4 text-left text-[11px] font-bold uppercase tracking-wider">City</th>
            <th scope="col" class="px-4 py-4 text-left text-[11px] font-bold uppercase tracking-wider">Latitude
            </th>
            <th scope="col" class="px-4 py-4 text-left text-[11px] font-bold uppercase tracking-wider">Longitude
            </th>
            <th scope="col" class="px-4 py-4 text-left text-[11px] font-bold uppercase tracking-wider">Contact
            </th>
            <th scope="col" class="px-4 py-4 text-center text-[11px] font-bold uppercase tracking-wider">Status
            </th>
            <th scope="col" class="px-4 py-4 text-right text-[11px] font-bold uppercase tracking-wider">Action
            </th>
        </tr>
    </thead>
    <tbody class="bg-white divide-y divide-gray-100">
        @forelse($sites as $site)
            <tr class="hover:bg-slate-50 transition-colors group">
                <td class="px-6 py-4 whitespace-nowrap">
                    <input type="checkbox" name="site_ids[]" value="{{ $site->id }}" data-name="{{ $site->name }}"
                        data-rate="{{ $site->rate }}" data-address="{{ $site->address_line_1 }}"
                        data-country="{{ $site->country_id }}" data-state="{{ $site->state_id }}"
                        data-city="{{ $site->city }}" data-zip="{{ $site->zip_code }}"
                        data-lat="{{ $site->latitude }}" data-long="{{ $site->longitude }}"
                        onchange="updateBulkButton()"
                        class="site-checkbox rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                </td>
                <td class="px-3 py-4 whitespace-nowrap">
                    <span
                        class="bg-blue-50 text-blue-700 px-2 py-1 rounded-lg text-xs font-bold border border-blue-100 shadow-sm">
                        {{ $site->site_id }}
                    </span>
                </td>
                <td class="px-4 py-4 whitespace-nowrap text-xs font-bold text-gray-900">
                    <div class="flex flex-col">
                        <span>{{ $site->name }}</span>
                        @if(!$site->isProfileComplete())
                            <span
                                class="text-[8px] text-amber-600 font-black uppercase tracking-widest mt-0.5 flex items-center gap-1">
                                <div class="w-1 h-1 rounded-full bg-amber-500 animate-pulse"></div>
                                Complete Info
                            </span>
                        @else
                            <span
                                class="text-[8px] text-emerald-600 font-black uppercase tracking-widest mt-0.5 flex items-center gap-1">
                                <div class="w-1 h-1 rounded-full bg-emerald-500"></div>
                                Completed
                            </span>
                        @endif
                    </div>
                </td>
                <td class="px-4 py-4 whitespace-nowrap text-xs text-gray-500 font-medium">
                    {{ $site->account_type }}
                </td>
                <td class="px-4 py-4 whitespace-nowrap text-[11px] font-bold text-gray-900">
                    ${{ number_format($site->rate, 2) }}
                </td>
                <td class="px-4 py-4 whitespace-nowrap text-xs text-gray-500 font-medium italic">
                    {{ $site->city }}
                </td>
                <td class="px-4 py-4 whitespace-nowrap text-xs text-gray-500 font-medium">
                    <span
                        class="font-mono text-[10px] bg-slate-50 px-2 py-1 rounded border border-slate-200">{{ $site->latitude ?? 'N/A' }}</span>
                </td>
                <td class="px-4 py-4 whitespace-nowrap text-xs text-gray-500 font-medium">
                    <span
                        class="font-mono text-[10px] bg-slate-50 px-2 py-1 rounded border border-slate-200">{{ $site->longitude ?? 'N/A' }}</span>
                </td>
                <td class="px-4 py-4 whitespace-nowrap text-xs text-gray-600 font-medium">
                    <div class="flex items-center gap-3">
                        <div
                            class="w-8 h-8 rounded-xl bg-slate-50 flex items-center justify-center text-slate-400 group-hover:bg-blue-50 group-hover:text-blue-500 transition-colors">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                        </div>
                        <div>
                            <div class="font-bold text-gray-900">{{ $site->contact_first_name }}
                                {{ $site->contact_last_name }}
                            </div>
                            <div class="text-[10px] text-gray-400 mt-0.5">{{ $site->contact_phone_main }}</div>
                        </div>
                    </div>
                </td>
                <td class="px-4 py-4 whitespace-nowrap text-center">
                    @can('edit site')
                        <button type="button"
                            onclick="toggleSiteStatus('{{ route('sites.toggle-status', $site) }}', this)"
                            class="relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-blue-600 focus:ring-offset-2 {{ $site->active ? 'bg-blue-600' : 'bg-gray-200' }}"
                            role="switch" aria-checked="{{ $site->active ? 'true' : 'false' }}">
                            <span aria-hidden="true"
                                class="pointer-events-none inline-block h-5 w-5 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out {{ $site->active ? 'translate-x-5' : 'translate-x-0' }}"></span>
                        </button>
                    @else
                        <span
                            class="px-2 py-1 rounded text-[10px] font-bold {{ $site->active ? 'bg-emerald-100 text-emerald-700' : 'bg-red-100 text-red-700' }}">
                            {{ $site->active ? 'ACTIVE' : 'INACTIVE' }}
                        </span>
                    @endcan
                </td>
                <td class="px-4 py-4 whitespace-nowrap text-right">
                    <div class="flex items-center justify-end gap-2">
                        <a href="{{ route('sites.show', $site) }}"
                            class="p-2 text-slate-400 hover:text-blue-600 hover:bg-blue-50 rounded-xl transition-all group/tooltip relative">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                            </svg>
                            <span
                                class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 px-2 py-1 bg-slate-900 text-white text-[10px] font-bold rounded opacity-0 group-hover/tooltip:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">View
                                Details</span>
                        </a>
                        @can('edit site')
                            <a href="{{ route('sites.edit', $site) }}"
                                class="p-2 text-slate-400 hover:text-amber-600 hover:bg-amber-50 rounded-xl transition-all group/tooltip relative">
                                <svg class="w-4.5 h-4.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                                    </path>
                                </svg>
                                <span
                                    class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 px-2 py-1 bg-slate-900 text-white text-[10px] font-bold rounded opacity-0 group-hover/tooltip:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">Edit
                                    Site</span>
                            </a>
                        @endcan

                        @can('delete site')
                            <form action="{{ route('sites.destroy', $site) }}" method="POST"
                                onsubmit="return confirm('Are you sure you want to delete this site?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit"
                                    class="p-2 text-slate-400 hover:text-red-600 hover:bg-red-50 rounded-xl transition-all group/tooltip relative">
                                    <svg class="w-4.5 h-4.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                        </path>
                                    </svg>
                                    <span
                                        class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 px-2 py-1 bg-slate-900 text-white text-[10px] font-bold rounded opacity-0 group-hover/tooltip:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">Delete
                                        Site</span>
                                </button>
                            </form>
                        @endcan
                    </div>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="11" class="px-6 py-12 text-center text-gray-500 text-xs">
                    No sites found.
                </td>
            </tr>
        @endforelse
    </tbody>
</table>

<!-- Pagination -->
@if($sites->hasPages())
    <div class="px-4 py-3 border-t border-gray-200 bg-gray-50 table-pagination">
        {{ $sites->links() }}
    </div>
@endif
