@extends('layouts.user')

@section('title', 'Search Results')

@section('content')
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-900 mb-2 tracking-tight">Search Results</h1>
        <p class="text-gray-500">Showing matches for "<span class="font-bold text-gray-900">{{ $query }}</span>"</p>
    </div>

    <div class="space-y-10">
        {{-- Employees --}}
        @if($employees->isNotEmpty())
            <section>
                <div class="flex items-center justify-between mb-4">
                    <h2 class="text-lg font-bold text-gray-900 border-b-2 border-blue-500 inline-block pb-1">Employees</h2>
                    <span class="text-xs font-bold text-gray-500 bg-gray-100 px-2 py-1 rounded-full">{{ $employees->count() }}
                        found</span>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    @foreach($employees as $emp)
                        <a href="{{ route('employees.show', $emp) }}"
                            class="block bg-white p-4 rounded-xl border border-gray-100 shadow-sm hover:shadow-md hover:border-blue-200 transition-all group">
                            <div class="flex items-center gap-4">
                                <div
                                    class="w-12 h-12 rounded-full bg-blue-50 flex items-center justify-center text-blue-600 font-bold text-lg group-hover:bg-blue-600 group-hover:text-white transition-colors">
                                    {{ substr($emp->first_name, 0, 1) }}
                                </div>
                                <div class="overflow-hidden">
                                    <h3 class="font-bold text-gray-900 truncate">{{ $emp->first_name }} {{ $emp->last_name }}</h3>
                                    <p class="text-xs text-gray-500 truncate">{{ $emp->email }}</p>
                                    <p class="text-xs text-gray-400 mt-1 truncate">{{ $emp->phone_number }}</p>
                                </div>
                            </div>
                        </a>
                    @endforeach
                </div>
            </section>
        @endif

        {{-- Sites --}}
        @if($sites->isNotEmpty())
            <section>
                <div class="flex items-center justify-between mb-4">
                    <h2 class="text-lg font-bold text-gray-900 border-b-2 border-emerald-500 inline-block pb-1">Sites</h2>
                    <span class="text-xs font-bold text-gray-500 bg-gray-100 px-2 py-1 rounded-full">{{ $sites->count() }}
                        found</span>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    @foreach($sites as $site)
                        <a href="{{ route('sites.show', $site) }}"
                            class="block bg-white p-5 rounded-xl border border-gray-100 shadow-sm hover:shadow-md hover:border-emerald-200 transition-all">
                            <h3 class="font-bold text-gray-900 mb-1 text-lg">{{ $site->name }}</h3>
                            <div class="flex items-start gap-2 text-xs text-gray-500 mt-2">
                                <svg class="w-4 h-4 shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                                    </path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                </svg>
                                <p class="line-clamp-2">{{ $site->address }}</p>
                            </div>
                        </a>
                    @endforeach
                </div>
            </section>
        @endif

        {{-- Schedules --}}
        @if($schedules->isNotEmpty())
            <section>
                <h2 class="text-lg font-bold text-gray-900 mb-4 border-b-2 border-purple-500 inline-block pb-1">Schedules</h2>
                <div class="bg-white rounded-xl border border-gray-100 overflow-hidden shadow-sm">
                    <table class="w-full text-left text-sm">
                        <thead class="bg-gray-50 text-gray-500 font-bold uppercase text-xs tracking-wider">
                            <tr>
                                <th class="px-5 py-3">ID</th>
                                <th class="px-5 py-3">Site</th>
                                <th class="px-5 py-3">Employee</th>
                                <th class="px-5 py-3">Date</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-50">
                            @foreach($schedules as $sched)
                                <tr class="hover:bg-gray-50 cursor-pointer transition-colors"
                                    onclick="window.location='{{ route('schedules.index', ['date' => $sched->date]) }}'">
                                    <td class="px-5 py-3 font-mono text-gray-600 font-semibold">#{{ $sched->id }}</td>
                                    <td class="px-5 py-3 font-bold text-gray-900">{{ $sched->site->name ?? '-' }}</td>
                                    <td class="px-5 py-3 text-gray-600">{{ $sched->employee->first_name ?? '-' }}</td>
                                    <td class="px-5 py-3 text-gray-500">{{ $sched->date }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </section>
        @endif

        {{-- Emails --}}
        @if($emails->isNotEmpty())
            <section>
                <h2 class="text-lg font-bold text-gray-900 mb-4 border-b-2 border-amber-500 inline-block pb-1">Emails /
                    Campaigns</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    @foreach($emails as $campaign)
                        <div class="bg-white p-4 rounded-xl border border-gray-100 shadow-sm flex justify-between items-center">
                            <div>
                                <h3 class="font-bold text-gray-900">{{ $campaign->name }}</h3>
                                <p class="text-xs text-gray-500 mt-1">
                                    Status: <span class="uppercase font-bold text-gray-700">{{ $campaign->status }}</span>
                                </p>
                            </div>
                            <a href="{{ route('email-campaigns.index') }}"
                                class="px-3 py-1.5 bg-gray-100 text-gray-600 text-xs font-bold rounded-lg hover:bg-gray-200 transition-colors">View</a>
                        </div>
                    @endforeach
                </div>
            </section>
        @endif

        {{-- Routes --}}
        @if($routes->isNotEmpty())
            <section>
                <h2 class="text-lg font-bold text-gray-900 mb-4 border-b-2 border-indigo-500 inline-block pb-1">Routes</h2>
                <div class="space-y-2">
                    @foreach($routes as $route)
                        <div class="bg-white p-4 rounded-xl border border-gray-100 shadow-sm">
                            <h3 class="font-bold text-gray-900">{{ $route->name }}</h3>
                        </div>
                    @endforeach
                </div>
            </section>
        @endif

        {{-- Messages --}}
        @if($messages->isNotEmpty())
            <section>
                <h2 class="text-lg font-bold text-gray-900 mb-4 border-b-2 border-rose-500 inline-block pb-1">Messages /
                    Requests</h2>
                <div class="grid grid-cols-1 gap-3">
                    @foreach($messages as $msg)
                        <a href="{{ route('employee-requests.show', $msg) }}"
                            class="block bg-white p-4 rounded-xl border border-gray-100 shadow-sm hover:shadow-md hover:border-rose-200 transition-all">
                            <div class="flex justify-between items-start mb-2">
                                <div class="flex items-center gap-2">
                                    <span
                                        class="text-[10px] font-bold text-rose-600 uppercase bg-rose-50 px-2 py-0.5 rounded tracking-wide">{{ $msg->type }}</span>
                                    <span class="font-bold text-gray-900 text-sm">{{ $msg->employee->first_name }}
                                        {{ $msg->employee->last_name }}</span>
                                </div>
                                <span class="text-xs text-gray-400 opacity-70">{{ $msg->created_at->format('M d, H:i') }}</span>
                            </div>
                            <p class="text-sm text-gray-600 font-medium truncate">{{ $msg->subject ?: $msg->message }}</p>
                        </a>
                    @endforeach
                </div>
            </section>
        @endif

        @if($employees->isEmpty() && $sites->isEmpty() && $schedules->isEmpty() && $emails->isEmpty() && $messages->isEmpty() && $routes->isEmpty())
            <div class="text-center py-24">
                <div class="bg-gray-100 rounded-full w-20 h-20 flex items-center justify-center mx-auto mb-6 text-gray-400">
                    <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-gray-900 mb-2">No results found</h3>
                <p class="text-gray-500 max-w-sm mx-auto">We couldn't find any matches for "<span
                        class="font-semibold">{{ $query }}</span>". Try searching for a name, address, or ID.</p>
            </div>
        @endif
    </div>
@endsection