<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Schedules Export</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 10px;
            color: #333;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #f4f4f4;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 9px;
        }

        .header {
            margin-bottom: 20px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }

        .title {
            font-size: 16px;
            font-weight: bold;
        }

        .meta {
            font-size: 10px;
            color: #666;
            margin-top: 5px;
        }

        .status-badge {
            font-weight: bold;
            text-transform: uppercase;
        }

        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            font-size: 8px;
            text-align: center;
            color: #999;
            border-top: 1px solid #eee;
            padding-top: 5px;
        }
    </style>
</head>

<body>
    <div class="header">
        <div class="title">Duty Schedules Report</div>
        <div class="meta">
            Generated: {{ now()->format('Y-m-d H:i') }} |
            Type: {{ ucfirst($type) }} |
            Filter: {{ request('site_id') ? 'Site: ' . $schedules->first()?->site->name : 'All Sites' }}
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>Duty #</th>
                <th>Date</th>
                <th>Time</th>
                <th>Site</th>
                <th>Guards</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @forelse($schedules as $schedule)
                <tr>
                    <td>{{ $schedule->duty_number }}</td>
                    <td>{{ $schedule->schedule_date->format('Y-m-d') }}</td>
                    <td>
                        {{ $schedule->from_datetime->format('H:i') }} - {{ $schedule->to_datetime->format('H:i') }}
                        <br>
                        <span style="color: #666; font-size: 8px;">({{ $schedule->duration_hours }} hrs)</span>
                    </td>
                    <td>
                        <strong>{{ $schedule->site->name }}</strong><br>
                        <span style="color: #666; font-size: 8px;">{{ $schedule->site->site_id }}</span>
                    </td>
                    <td>
                        @foreach($schedule->employees as $emp)
                            <div>{{ $emp->first_name }} {{ $emp->last_name }} ({{ $emp->employee_id }})</div>
                        @endforeach
                    </td>
                    <td>
                        <span class="status-badge">{{ $schedule->status }}</span>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" style="text-align: center; font-style: italic; padding: 20px;">No schedules found
                        matching the criteria.</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="footer">
        Confidential Report - Generated by Crimson Vanguard Intelligence System
    </div>
</body>

</html>