@extends('layouts.user')

@section('title', 'Route Details')

@section('content')
    <div class="max-w-7xl mx-auto" x-data="{ activeTab: 'overview' }">
        <!-- Header Section (Dark Blue) -->
        <div class="bg-[#1e293b] text-white px-8 pt-10 pb-0 rounded-t-3xl mb-0 shadow-xl relative overflow-hidden">
            <!-- Subtle background decorative element -->
            <div class="absolute -right-20 -top-20 w-64 h-64 bg-blue-500/10 rounded-full blur-3xl"></div>

            <div class="flex flex-col md:flex-row md:items-center gap-6 mb-8 relative z-10">
                <div class="relative group">
                    <div
                        class="w-20 h-20 rounded-2xl bg-gradient-to-br from-indigo-400 to-indigo-600 flex items-center justify-center text-3xl font-bold border-4 border-slate-800 shadow-2xl overflow-hidden shadow-indigo-500/20">
                        <span class="text-white">{{ substr($route->name, 0, 1) }}</span>
                    </div>
                </div>
                <div>
                    <div class="flex items-center gap-3">
                        <h1 class="text-3xl font-extrabold tracking-tight">{{ $route->name }}</h1>
                        <span
                            class="px-3 py-1 bg-indigo-500/20 text-indigo-300 text-[10px] font-bold uppercase rounded-full border border-indigo-500/30">Route
                            Details</span>
                    </div>
                    <div class="flex flex-wrap items-center gap-4 mt-2 text-sm text-slate-400 font-medium">
                        <span class="flex items-center gap-1.5">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            Code: {{ $route->route_code }}
                        </span>
                        <span class="flex items-center gap-1.5">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z">
                                </path>
                            </svg>
                            Rate: ${{ number_format($route->rate, 2) }}/hr
                        </span>
                        <span class="flex items-center gap-1.5 font-bold text-slate-300">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4">
                                </path>
                            </svg>
                            {{ $route->sites->count() }} Sites Linked
                        </span>
                    </div>
                </div>

                <div class="md:ml-auto flex items-center gap-2">
                    <a href="{{ route('routes.edit', $route->id) }}"
                        class="px-5 py-2.5 bg-indigo-600 text-white text-xs font-bold rounded-xl shadow-lg shadow-indigo-500/30 hover:bg-indigo-700 transition-all uppercase tracking-wider flex items-center gap-2 border border-indigo-400/30">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                            </path>
                        </svg>
                        Edit Route
                    </a>
                </div>
            </div>

            <!-- Primary Tabs -->
            <div class="flex items-center gap-8 text-sm font-bold relative z-10">
                <a href="#" @click.prevent="activeTab = 'overview'"
                    :class="activeTab === 'overview' ? 'border-white text-white' : 'border-transparent text-slate-400 hover:text-white'"
                    class="pb-4 border-b-4 transition-all uppercase tracking-widest text-[11px]">Overview</a>
                <a href="#" @click.prevent="activeTab = 'sites'"
                    :class="activeTab === 'sites' ? 'border-white text-white' : 'border-transparent text-slate-400 hover:text-white'"
                    class="pb-4 border-b-4 transition-all uppercase tracking-widest text-[11px]">Linked Sites</a>
            </div>
        </div>

        <!-- Actions Bar (White) -->
        <div
            class="bg-white px-8 py-5 border-b border-gray-100 shadow-sm flex items-center justify-between mb-8 rounded-b-3xl">
            <div class="flex gap-10">
                <div>
                    <div class="text-[10px] text-gray-400 font-bold uppercase tracking-widest mb-1">Status</div>
                    <div class="flex items-center gap-2">
                        <span
                            class="w-2 h-2 rounded-full {{ $route->active ? 'bg-green-500 shadow-[0_0_8px_rgba(34,197,94,0.6)]' : 'bg-red-500' }}"></span>
                        <span class="text-xs font-bold text-gray-700">{{ $route->active ? 'Active' : 'Inactive' }}</span>
                    </div>
                </div>
                <div>
                    <div class="text-[10px] text-gray-400 font-bold uppercase tracking-widest mb-1">Route ID</div>
                    <div
                        class="text-xs font-bold text-indigo-600 bg-indigo-50 px-2 py-0.5 rounded border border-indigo-100 leading-none inline-block mt-0.5 tracking-wider">
                        {{ $route->route_code }}</div>
                </div>
            </div>

            <a href="{{ route('routes.index') }}"
                class="flex items-center gap-2 px-4 py-2 bg-gray-50 text-gray-600 text-[10px] font-black rounded-xl border border-gray-200 hover:bg-white transition-all uppercase tracking-widest">
                <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18">
                    </path>
                </svg>
                Back to List
            </a>
        </div>

        <!-- Tab Content -->
        <div class="space-y-8 pb-12">
            <!-- Overview Tab -->
            <div x-show="activeTab === 'overview'" class="grid grid-cols-1 lg:grid-cols-3 gap-8"
                x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4"
                x-transition:enter-end="opacity-100 translate-y-0">
                <!-- Main Info -->
                <div class="lg:col-span-2 space-y-8">
                    <div class="bg-white rounded-3xl shadow-xl shadow-slate-200/50 border border-gray-100 overflow-hidden">
                        <div class="px-8 py-6 border-b border-gray-50 flex items-center justify-between bg-slate-50/50">
                            <div class="flex items-center gap-3">
                                <div
                                    class="w-10 h-10 rounded-xl bg-indigo-600 flex items-center justify-center text-white shadow-lg shadow-indigo-500/20">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                </div>
                                <h2 class="text-xs font-black text-slate-900 uppercase tracking-widest leading-none">Route
                                    Description</h2>
                            </div>
                        </div>
                        <div class="p-8">
                            <p class="text-sm font-medium text-gray-600 leading-relaxed italic">
                                {{ $route->description ?: 'No description provided for this route.' }}
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Financial Summary -->
                <div class="bg-white rounded-3xl shadow-xl shadow-slate-200/50 border border-gray-100 p-8 h-fit">
                    <h3
                        class="text-xs font-black text-slate-900 uppercase tracking-widest mb-6 border-l-4 border-indigo-600 pl-3">
                        Route Economics</h3>
                    <div class="text-center py-6 bg-slate-50 rounded-2xl border border-gray-100 mb-6">
                        <div class="text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-1">Billing Rate</div>
                        <div class="text-4xl font-black text-slate-900">${{ number_format($route->rate, 2) }}</div>
                        <div class="text-[10px] text-gray-400 mt-1 font-medium italic">Standard Hourly Billing</div>
                    </div>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between text-xs px-2">
                            <span class="text-gray-400 font-bold uppercase tracking-wider">Total Linked Sites</span>
                            <span class="text-slate-900 font-black">{{ $route->sites->count() }}</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sites Tab -->
            <div x-show="activeTab === 'sites'"
                class="bg-white rounded-3xl shadow-xl shadow-slate-200/50 border border-gray-100 overflow-hidden"
                x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4"
                x-transition:enter-end="opacity-100 translate-y-0">
                <div class="px-8 py-6 border-b border-gray-50 flex items-center justify-between bg-slate-50/50">
                    <h2 class="text-xs font-black text-slate-900 uppercase tracking-widest leading-none">Linked Sites
                        Breakdown</h2>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full text-left">
                        <thead class="bg-gray-50/50">
                            <tr>
                                <th class="px-8 py-4 text-[11px] font-black text-gray-400 uppercase tracking-widest">Site
                                    Name</th>
                                <th class="px-8 py-4 text-[11px] font-black text-gray-400 uppercase tracking-widest">Site ID
                                </th>
                                <th class="px-8 py-4 text-[11px] font-black text-gray-400 uppercase tracking-widest">
                                    Location</th>
                                <th class="px-8 py-4 text-[11px] font-black text-gray-400 uppercase tracking-widest">Status
                                </th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100">
                            @forelse($route->sites as $site)
                                <tr class="hover:bg-slate-50/50 transition-colors group">
                                    <td class="px-8 py-4">
                                        <div class="text-sm font-bold text-gray-900">{{ $site->name }}</div>
                                    </td>
                                    <td class="px-8 py-4">
                                        <span
                                            class="text-xs font-bold text-blue-600 bg-blue-50 px-2 py-0.5 rounded">{{ $site->site_id }}</span>
                                    </td>
                                    <td class="px-8 py-4">
                                        <div class="text-xs text-gray-600">{{ $site->city }}, {{ $site->zip_code }}</div>
                                    </td>
                                    <td class="px-8 py-4">
                                        <span
                                            class="inline-flex items-center px-2 py-0.5 rounded text-[10px] font-bold uppercase tracking-widest {{ $site->active ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700' }}">
                                            {{ $site->active ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="px-8 py-12 text-center text-gray-400 italic text-sm font-medium">
                                        No sites have been linked to this route yet.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection