@extends('layouts.user')

@section('title', 'Route Masters')

@section('content')
    <div class="flex flex-col h-full">
        <!-- Toolbar -->
        <div class="bg-white border-b border-gray-200 px-4 py-2 flex items-center justify-between shadow-sm">
            <div class="flex items-center gap-4">
                <a href="{{ route('routes.create') }}"
                    class="flex items-center gap-1 text-xs font-semibold text-gray-700 hover:text-blue-600 transition-colors">
                    <svg class="w-4 h-4 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                    </svg>
                    New Route
                </a>
                <a href="{{ route('routes.export-excel', request()->all()) }}"
                    class="flex items-center gap-1 text-xs font-semibold text-gray-700 hover:text-green-600 transition-colors">
                    <svg class="w-4 h-4 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                        </path>
                    </svg>
                    Export Excel
                </a>
                <a href="{{ route('routes.export-pdf', request()->all()) }}"
                    class="flex items-center gap-1 text-xs font-semibold text-gray-700 hover:text-red-600 transition-colors">
                    <svg class="w-4 h-4 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z">
                        </path>
                    </svg>
                    Export PDF
                </a>
            </div>
        </div>

        <!-- Filters -->
        <div class="bg-gray-50 border-b border-gray-200 px-4 py-3 flex flex-wrap items-center gap-3">
            <form action="{{ route('routes.index') }}" method="GET" class="flex flex-1 items-center gap-3">
                <div class="relative flex-1 max-w-xs">
                    <input type="text" name="search" value="{{ request('search') }}" placeholder="Search Route Name..."
                        class="block w-full pl-3 pr-10 py-1.5 text-xs border-gray-300 focus:ring-blue-500 focus:border-blue-500 rounded-sm bg-white shadow-sm placeholder-gray-400">
                    @if(request('search'))
                        <a href="{{ route('routes.index') }}"
                            class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-600">
                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                                </path>
                            </svg>
                        </a>
                    @endif
                </div>
                <button type="submit"
                    class="bg-blue-600 text-white px-4 py-1.5 rounded-sm text-xs font-bold hover:bg-blue-700 transition-all">Search</button>
            </form>
        </div>

        @if(session('success'))
            <div
                class="m-4 p-3 bg-emerald-50 border border-emerald-100 text-emerald-700 rounded text-xs flex items-center gap-2">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                </svg>
                {{ session('success') }}
            </div>
        @endif

        <!-- Table -->
        <div class="flex-1 overflow-auto bg-white">
            <table class="min-w-full divide-y divide-gray-200 border-separate border-spacing-0">
                <thead class="bg-gray-50 sticky top-0 z-10 text-[11px] uppercase tracking-wider text-gray-500 font-bold">
                    <tr>
                        <th scope="col" class="px-4 py-3 text-left border-b border-gray-200 w-32">Route Code</th>
                        <th scope="col" class="px-4 py-3 text-left border-b border-gray-200">
                            <a href="{{ route('routes.index', array_merge(request()->all(), ['sort' => 'name', 'direction' => request('direction') === 'asc' ? 'desc' : 'asc'])) }}"
                                class="flex items-center gap-1 group">
                                Route Name
                                <svg class="w-3 h-3 {{ request('sort') === 'name' ? 'text-blue-600' : 'text-gray-400 opacity-0 group-hover:opacity-100' }}"
                                    fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </a>
                        </th>
                        <th scope="col" class="px-4 py-3 text-left border-b border-gray-200">Sites</th>
                        <th scope="col" class="px-4 py-3 text-left border-b border-gray-200">Rate</th>
                        <th scope="col" class="px-4 py-3 text-center border-b border-gray-200">Status</th>
                        <th scope="col" class="px-4 py-3 text-right border-b border-gray-200">Action</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($routes as $route)
                        <tr class="hover:bg-blue-50/50 transition-colors">
                            <td class="px-4 py-3 whitespace-nowrap">
                                <span class="bg-blue-600 text-white px-2 py-0.5 rounded text-[10px] font-bold tracking-wider">
                                    {{ $route->route_code }}
                                </span>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-xs font-bold text-gray-900">
                                {{ $route->name }}
                            </td>
                            <td class="px-4 py-3 text-xs text-gray-600">
                                <div class="flex flex-wrap gap-1">
                                    @foreach($route->sites as $site)
                                        <span
                                            class="bg-gray-100 text-gray-700 px-2 py-0.5 rounded text-[10px]">{{ $site->name }}</span>
                                    @endforeach
                                    @if($route->sites->isEmpty())
                                        <span class="text-gray-400 italic">No sites assigned</span>
                                    @endif
                                </div>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-[11px] font-bold text-gray-900">
                                ${{ number_format($route->rate, 2) }}
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-center">
                                <button type="button"
                                    onclick="toggleRouteStatus('{{ route('routes.toggle-status', $route) }}', this)"
                                    class="relative inline-flex h-5 w-9 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-blue-600 focus:ring-offset-2 {{ $route->active ? 'bg-blue-600' : 'bg-gray-200' }}"
                                    role="switch" aria-checked="{{ $route->active ? 'true' : 'false' }}">
                                    <span aria-hidden="true"
                                        class="pointer-events-none inline-block h-4 w-4 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out {{ $route->active ? 'translate-x-4' : 'translate-x-0' }}"></span>
                                </button>
                            </td>
                            <td class="px-3 py-4 whitespace-nowrap text-right">
                                <div class="flex items-center justify-center gap-2">
                                    <a href="{{ route('routes.show', $route) }}"
                                        class="p-2 text-slate-400 hover:text-blue-600 hover:bg-blue-50 rounded-xl transition-all group/tooltip relative">
                                        <svg class="w-4.5 h-4.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                        </svg>
                                        <span
                                            class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 px-2 py-1 bg-slate-900 text-white text-[10px] font-bold rounded opacity-0 group-hover/tooltip:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">View
                                            Details</span>
                                    </a>
                                    <a href="{{ route('routes.edit', $route) }}"
                                        class="p-2 text-slate-400 hover:text-amber-600 hover:bg-amber-50 rounded-xl transition-all group/tooltip relative">
                                        <svg class="w-4.5 h-4.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                                            </path>
                                        </svg>
                                        <span
                                            class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 px-2 py-1 bg-slate-900 text-white text-[10px] font-bold rounded opacity-0 group-hover/tooltip:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">Edit
                                            Route</span>
                                    </a>
                                    <form action="{{ route('routes.destroy', $route) }}" method="POST"
                                        onsubmit="return confirm('Are you sure you want to delete this route?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit"
                                            class="p-2 text-slate-400 hover:text-red-600 hover:bg-red-50 rounded-xl transition-all group/tooltip relative">
                                            <svg class="w-4.5 h-4.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                                </path>
                                            </svg>
                                            <span
                                                class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 px-2 py-1 bg-slate-900 text-white text-[10px] font-bold rounded opacity-0 group-hover/tooltip:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">Delete
                                                Route</span>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-6 py-12 text-center text-gray-500 text-xs">
                                No routes found.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        @if($routes->hasPages())
            <div class="px-4 py-3 border-t border-gray-200 bg-gray-50 text-xs">
                {{ $routes->links() }}
            </div>
        @endif
    </div>
    @push('scripts')
        <script>
            async function toggleRouteStatus(url, button) {
                const circle = button.querySelector('span');
                const isActive = button.getAttribute('aria-checked') === 'true';

                try {
                    // Optimistic UI
                    button.setAttribute('aria-checked', !isActive);
                    if (!isActive) {
                        button.classList.remove('bg-gray-200');
                        button.classList.add('bg-blue-600');
                        circle.classList.remove('translate-x-0');
                        circle.classList.add('translate-x-4');
                    } else {
                        button.classList.remove('bg-blue-600');
                        button.classList.add('bg-gray-200');
                        circle.classList.remove('translate-x-4');
                        circle.classList.add('translate-x-0');
                    }

                    const response = await fetch(url, {
                        method: 'PATCH',
                        headers: {
                            'X-CSRF-TOKEN': '{{ csrf_token() }}',
                            'Accept': 'application/json',
                            'Content-Type': 'application/json'
                        }
                    });

                    const data = await response.json();
                    if (!data.success) throw new Error(data.message || 'Failed to update status');

                } catch (error) {
                    console.error('Error:', error);
                    // Revert UI
                    button.setAttribute('aria-checked', isActive);
                    if (isActive) {
                        button.classList.remove('bg-gray-200');
                        button.classList.add('bg-blue-600');
                        circle.classList.remove('translate-x-0');
                        circle.classList.add('translate-x-4');
                    } else {
                        button.classList.remove('bg-blue-600');
                        button.classList.add('bg-gray-200');
                        circle.classList.remove('translate-x-4');
                        circle.classList.add('translate-x-0');
                    }
                    alert(error.message || 'An error occurred while updating status');
                }
            }
        </script>
    @endpush

@endsection