@extends('layouts.user')

@section('title', 'Site Margin Report')

@section('content')
    <div class="space-y-6">
        <!-- Dashboard Header -->
        <h1 class="text-2xl font-bold text-gray-800">Site Margin Report</h1>

        <!-- Filters -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-200">
            <form method="GET" action="{{ route('reports.operational.site_margin') }}" class="space-y-6">
                <div class="flex flex-col md:flex-row gap-6 items-end">

                    {{-- Export Buttons (Standard) --}}
                    <div class="flex-none flex items-center gap-2">
                        <a href="{{ route('reports.operational.site_margin.export.pdf', request()->query()) }}"
                            target="_blank"
                            class="h-[38px] px-4 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors flex items-center justify-center gap-2 whitespace-nowrap shadow-sm">
                            <svg class="w-4 h-4 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z">
                                </path>
                            </svg>
                            Export PDF
                        </a>
                    </div>
                    
                    {{-- Report Type Toggle --}}
                    <div class="flex items-center gap-2 bg-gray-50 px-3 py-[7px] rounded-lg border border-gray-200">
                        <label class="text-[10px] font-bold text-gray-600 uppercase">Type:</label>
                        <div class="flex items-center gap-3">
                            <label class="inline-flex items-center cursor-pointer">
                                <input type="radio" name="report_type" value="actual" class="form-radio h-3 w-3 text-blue-600"
                                    {{ request('report_type', 'actual') == 'actual' ? 'checked' : '' }} onchange="this.form.submit()">
                                <span class="ml-1.5 text-xs text-gray-700">Actual</span>
                            </label>
                            <label class="inline-flex items-center cursor-pointer">
                                <input type="radio" name="report_type" value="scheduled" class="form-radio h-3 w-3 text-blue-600"
                                    {{ request('report_type') == 'scheduled' ? 'checked' : '' }} onchange="this.form.submit()">
                                <span class="ml-1.5 text-xs text-gray-700">Scheduled</span>
                            </label>
                        </div>
                    </div>

                    <div class="flex-grow"></div> <!-- Spacer -->

                    <div class="w-full md:w-40">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Start Date</label>
                        <input type="date" name="start_date"
                            value="{{ request('start_date', now()->startOfMonth()->format('Y-m-d')) }}"
                            class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                    </div>

                    <div class="w-full md:w-40">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">End Date</label>
                        <input type="date" name="end_date" value="{{ request('end_date', now()->format('Y-m-d')) }}"
                            class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                    </div>

                    <!-- Site Filter (Searchable) -->
                    <div class="w-full md:w-64" x-data="searchableSelect({
                                options: {{ $sites->map(fn($s) => ['value' => $s->id, 'label' => $s->name])->values()->toJson() }},
                                value: '{{ request('site_id') }}',
                                placeholder: 'All Sites'
                            })" @click.outside="open = false">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Site</label>
                        <div class="relative">
                            <div @click="open = !open"
                                class="w-full bg-white border border-gray-300 rounded-lg px-3 py-2 text-sm shadow-sm cursor-pointer flex justify-between items-center h-[38px] hover:border-blue-400 transition-colors">
                                <span x-text="selectedLabel" class="truncate text-gray-700"></span>
                                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </div>
                            <input type="hidden" name="site_id" :value="value">

                            <div x-show="open" x-transition.origin.top.left x-cloak
                                class="absolute z-50 w-full bg-white border border-gray-300 rounded-lg mt-1 shadow-xl max-h-60 overflow-hidden flex flex-col">
                                <div class="p-2 border-b border-gray-100 bg-gray-50/50">
                                    <input type="text" x-model="search" placeholder="Search site..."
                                        class="w-full text-xs border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 py-1.5 px-2">
                                </div>
                                <ul class="overflow-y-auto flex-1 p-1">
                                    <li @click="select({value: '', label: 'All Sites'})"
                                        class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer transition-colors"
                                        :class="{'bg-blue-50 text-blue-700 font-medium': value === ''}">
                                        All Sites
                                    </li>
                                    <template x-for="option in filteredOptions" :key="option.value">
                                        <li @click="select(option)"
                                            class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer truncate transition-colors"
                                            :class="{'bg-blue-50 text-blue-700 font-medium': value == option.value}"
                                            x-text="option.label">
                                        </li>
                                    </template>
                                    <li x-show="filteredOptions.length === 0"
                                        class="px-3 py-4 text-xs text-gray-400 text-center italic">
                                        No sites found
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Employee Filter (Searchable) -->
                    <div class="w-full md:w-64" x-data="searchableSelect({
                                options: {{ $employees->map(fn($e) => ['value' => $e->id, 'label' => $e->first_name . ' ' . $e->last_name])->values()->toJson() }},
                                value: '{{ request('employee_id') }}',
                                placeholder: 'All Employees'
                            })" @click.outside="open = false">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Employee</label>
                        <div class="relative">
                            <div @click="open = !open"
                                class="w-full bg-white border border-gray-300 rounded-lg px-3 py-2 text-sm shadow-sm cursor-pointer flex justify-between items-center h-[38px] hover:border-blue-400 transition-colors">
                                <span x-text="selectedLabel" class="truncate text-gray-700"></span>
                                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </div>
                            <input type="hidden" name="employee_id" :value="value">

                            <div x-show="open" x-transition.origin.top.left x-cloak
                                class="absolute z-50 w-full bg-white border border-gray-300 rounded-lg mt-1 shadow-xl max-h-60 overflow-hidden flex flex-col">
                                <div class="p-2 border-b border-gray-100 bg-gray-50/50">
                                    <input type="text" x-model="search" placeholder="Search employee..."
                                        class="w-full text-xs border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 py-1.5 px-2">
                                </div>
                                <ul class="overflow-y-auto flex-1 p-1">
                                    <li @click="select({value: '', label: 'All Employees'})"
                                        class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer transition-colors"
                                        :class="{'bg-blue-50 text-blue-700 font-medium': value === ''}">
                                        All Employees
                                    </li>
                                    <template x-for="option in filteredOptions" :key="option.value">
                                        <li @click="select(option)"
                                            class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer truncate transition-colors"
                                            :class="{'bg-blue-50 text-blue-700 font-medium': value == option.value}"
                                            x-text="option.label">
                                        </li>
                                    </template>
                                    <li x-show="filteredOptions.length === 0"
                                        class="px-3 py-4 text-xs text-gray-400 text-center italic">
                                        No employees found
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <button type="submit"
                        class="h-[38px] px-6 bg-slate-100 text-slate-600 text-sm font-bold rounded-lg hover:bg-slate-200 transition-colors whitespace-nowrap shadow-sm border border-slate-200">
                        Search
                    </button>
                </div>
            </form>
        </div>

        <!-- Data Content -->
        @forelse($groupedMargins as $siteName => $group)
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden mb-6">
                <!-- Group Header -->
                <div class="px-6 py-4 bg-gray-50 border-b border-gray-200">
                    <h3 class="font-bold text-gray-800">{{ $siteName }}</h3>
                </div>

                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead class="bg-gray-50/50 border-b border-gray-100">
                            <tr>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Duty ID</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Guard Name
                                </th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">In Date</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">In Time</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Out Date</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Out Time</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Total Hours
                                </th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider text-right">
                                    Site Rate</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider text-right">
                                    Income</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Wage
                                    Components</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider text-right">
                                    Expense</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider text-right">
                                    Margin</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100">
                            @foreach($group['items'] as $row)
                                        <tr class="hover:bg-gray-50/50">
                                            <td class="px-4 py-3 text-xs text-gray-600 font-medium">{{ $row->duty_number }}</td>
                                            <td class="px-4 py-3 text-xs text-gray-600 font-bold uppercase">
                                                {{ $row->first_name }} {{ $row->last_name }}
                                                @if(isset($row->stat_multiplier) && $row->stat_multiplier > 1)
                                                    <span
                                                        class="ml-1 inline-flex items-center px-1.5 py-0.5 rounded text-[8px] font-bold uppercase tracking-wider bg-purple-100 text-purple-700 border border-purple-200"
                                                        title="{{ $row->stat_holiday_name ?? 'Stat Holiday' }} ({{ $row->stat_multiplier }}x)">
                                                        STAT
                                                    </span>
                                                @endif
                                            </td>
                                            <td class="px-4 py-3 text-xs text-gray-600 whitespace-nowrap">
                                                {{ \Carbon\Carbon::parse($row->view_start)->format('Y-m-d') }}</td>
                                            <td class="px-4 py-3 text-xs text-gray-600 whitespace-nowrap">
                                                {{ \Carbon\Carbon::parse($row->view_start)->format('h:i A') }}</td>
                                            <td class="px-4 py-3 text-xs text-gray-600 whitespace-nowrap">
                                                {{ \Carbon\Carbon::parse($row->view_end)->format('Y-m-d') }}</td>
                                            <td class="px-4 py-3 text-xs text-gray-600 whitespace-nowrap">
                                                {{ \Carbon\Carbon::parse($row->view_end)->format('h:i A') }}</td>
                                            <td class="px-4 py-3 text-xs text-gray-600 font-bold">
                                                {{ number_format($row->hours, 2) }} hrs
                                            </td>

                                            <td class="px-4 py-3 text-xs text-gray-600 text-right">${{ number_format($row->bill_rate, 2) }}
                                            </td>
                                            <td class="px-4 py-3 text-xs font-bold text-emerald-700 text-right">
                                                ${{ number_format($row->total_income, 2) }}</td>

                                            <td class="px-4 py-3">
                                                @php
                                                    $wageTypes = json_decode($row->wage_types, true) ?: [];
                                                    $gasRate = $row->gas_rate > 0 ? $row->gas_rate : 0;
                                                    $rowTotal = 0;
                                                @endphp

                                                @if(!empty($wageTypes) || $gasRate > 0)
                                                    <div class="space-y-1.5">
                                                        @foreach($wageTypes as $wageType)
                                                                            @php
                                                                                $componentHours = $wageType['allocated_hours'] ?? 0;
                                                                                $componentRate = $wageType['rate'] ?? 0;
                                                                                $componentPay = $componentHours * $componentRate;
                                                                                $rowTotal += $componentPay;
                                                                            @endphp
                                                             <div
                                                                                class="flex items-center justify-between gap-4 text-xs bg-blue-50/50 px-2 py-1 rounded border border-blue-100">
                                                                                <span
                                                                                    class="font-bold text-blue-700 uppercase text-[10px]">{{ $wageType['name'] ?? 'Wage' }}</span>
                                                                                <div class="flex items-center gap-2 text-[10px]">
                                                                                    <span class="text-gray-600">{{ number_format($componentHours, 2) }} hrs</span>
                                                                                    <span class="text-gray-400">×</span>
                                                                                    <span class="text-gray-600">${{ number_format($componentRate, 2) }}</span>
                                                                                    <span class="text-gray-400">=</span>
                                                                                    <span
                                                                                        class="font-bold text-blue-700">${{ number_format($componentPay, 2) }}</span>
                                                                                </div>
                                                                            </div>
                                                        @endforeach

                                                        @if($gasRate > 0)
                                                                                @php
                                                                                    $rowTotal += $gasRate;
                                                                                @endphp
                                                            <div
                                                                                    class="flex items-center justify-between gap-4 text-xs bg-amber-50/50 px-2 py-1 rounded border border-amber-100">
                                                                                    <span class="font-bold text-amber-700 uppercase text-[10px]">GAS/CASH</span>
                                                                                    <div class="flex items-center gap-2 text-[10px]">
                                                                                        <span class="font-bold text-amber-700">${{ number_format($gasRate, 2) }}</span>
                                                                                    </div>
                                                                                </div>
                                                        @endif
                                                    </div>
                                                @else
                                                    <span class="text-xs text-gray-400 italic">No wage data</span>
                                                @endif
                                            </td>

                                            <td class="px-4 py-3 text-xs font-bold text-red-700 text-right">
                                                ${{ number_format($rowTotal, 2) }}</td>

                                            @php
                                                $margin = $row->total_income - $rowTotal;
                                            @endphp
                                <td
                                                class="px-4 py-3 text-xs font-bold {{ $margin >= 0 ? 'text-emerald-700' : 'text-red-700' }} text-right">
                                                ${{ number_format($margin, 2) }}</td>
                                        </tr>
                            @endforeach
                            <!-- Subtotal Row -->
                            @php
                                $totalMargin = $group['total_income'] - $group['total_expense'];
                            @endphp
                            <tr class="bg-gray-50 font-bold border-t border-gray-200">
                                <td colspan="6"></td>
                                <td class="px-4 py-3 text-xs text-gray-900">
                                    {{ number_format($group['total_hours'], 2) }} hrs
                                </td>
                                <td></td>
                                <td class="px-4 py-3 text-xs text-emerald-700 text-right">
                                    ${{ number_format($group['total_income'], 2) }}</td>
                                <td></td>
                                <td class="px-4 py-3 text-xs text-red-700 text-right">
                                    ${{ number_format($group['total_expense'], 2) }}</td>
                                <td
                                    class="px-4 py-3 text-xs {{ $totalMargin >= 0 ? 'text-emerald-700' : 'text-red-700' }} text-right">
                                    ${{ number_format($totalMargin, 2) }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        @empty
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-8 text-center text-gray-500">
                No margin records found for the selected period.
            </div>
        @endforelse
    </div>
@endsection