<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Operational Report #{{ $report->duty_number }}</title>
    <style>
        body {
            font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
            line-height: 1.5;
            color: #333;
        }

        .header {
            border-bottom: 2px solid #1e293b;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }

        .logo {
            font-size: 24px;
            font-weight: bold;
            color: #1e293b;
            text-transform: uppercase;
        }

        .title {
            font-size: 18px;
            font-weight: bold;
            margin-top: 10px;
            color: #64748b;
        }

        .section {
            margin-bottom: 30px;
        }

        .section-title {
            font-size: 12px;
            font-weight: bold;
            text-transform: uppercase;
            color: #64748b;
            border-bottom: 1px solid #e2e8f0;
            padding-bottom: 5px;
            margin-bottom: 15px;
        }

        .grid {
            width: 100%;
            border-collapse: collapse;
        }

        .grid td {
            vertical-align: top;
            padding: 5px 0;
        }

        .label {
            font-weight: bold;
            color: #64748b;
            width: 140px;
        }

        .value {
            color: #0f172a;
            font-weight: 500;
        }

        .status-badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: bold;
            text-transform: uppercase;
        }

        .status-badge.completed {
            background-color: #d1fae5;
            color: #047857;
        }

        .status-badge.active {
            background-color: #dbeafe;
            color: #1e40af;
        }

        .images-grid {
            width: 100%;
            margin-top: 10px;
        }

        .images-grid td {
            width: 33.33%;
            padding: 5px;
            text-align: center;
        }

        .evidence-img {
            width: 100%;
            height: auto;
            border: 1px solid #e2e8f0;
            border-radius: 4px;
        }

        .no-image {
            padding: 30px;
            background: #f8fafc;
            color: #94a3b8;
            font-style: italic;
            text-align: center;
            border-radius: 4px;
        }

        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            font-size: 10px;
            text-align: center;
            color: #94a3b8;
            border-top: 1px solid #e2e8f0;
            padding-top: 10px;
        }
    </style>
</head>

<body>
    <div class="header">
        <div class="logo">{{ $company->name ?? 'Vanguard Security' }}</div>
        <div class="title">
            @if(isset($reportType) && $reportType === 'scans_history')
                Checkpoint Scan History Detail
            @else
                Operational Shift Report
            @endif
        </div>
    </div>

    <div class="section">
        <div class="section-title">Schedule Information</div>
        <table class="grid">
            <tr>
                <td class="label">Duty Number:</td>
                <td class="value">#{{ $report->duty_number }}</td>
                <td class="label">Status:</td>
                <td class="value">
                    <span class="status-badge {{ $report->status }}">{{ ucfirst($report->status) }}</span>
                </td>
            </tr>
            <tr>
                <td class="label">Date:</td>
                <td class="value">{{ \Carbon\Carbon::parse($report->schedule_date)->format('F d, Y') }}</td>
                <td class="label">Site:</td>
                <td class="value">{{ $report->site_name }}</td>
            </tr>
            <tr>
                <td class="label">Scheduled Time:</td>
                <td class="value">
                    {{ \Carbon\Carbon::parse($report->from_datetime)->format('H:i') }} -
                    {{ \Carbon\Carbon::parse($report->to_datetime)->format('H:i') }}
                </td>
                <td class="label">Location:</td>
                <td class="value">{{ $report->site_address ?? 'N/A' }}</td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Operative Details</div>
        <table class="grid">
            <tr>
                <td class="label">Employee Name:</td>
                <td class="value">{{ $report->first_name }} {{ $report->last_name }}</td>
            </tr>
            <tr>
                <td class="label">Employee ID:</td>
                <td class="value">{{ $report->employee_id }}</td>
            </tr>
            <tr>
                <td class="label">Role:</td>
                <td class="value">{{ $report->job_role ?? 'Security Officer' }}</td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Attendance & Timestamps</div>
        <table class="grid">
            <tr>
                <td class="label">Actual Start:</td>
                <td class="value">
                    @if($report->actual_start_at)
                        {{ \Carbon\Carbon::parse($report->actual_start_at)->format('M d, Y H:i:s') }}
                    @else
                        --
                    @endif
                </td>
                <td class="label">Check-in Location:</td>
                <td class="value">{{ $report->checkin_coordinates ?? 'GPS Not Recorded' }}</td>
            </tr>
            <tr>
                <td class="label">Actual End:</td>
                <td class="value">
                    @if($report->actual_end_at)
                        {{ \Carbon\Carbon::parse($report->actual_end_at)->format('M d, Y H:i:s') }}
                    @else
                        --
                    @endif
                </td>
                <td class="label">Checkout Location:</td>
                <td class="value">{{ $report->checkout_coordinates ?? 'GPS Not Recorded' }}</td>
            </tr>
            <tr>
                <td class="label">Total Duration:</td>
                <td class="value">
                    @if($report->actual_start_at && $report->actual_end_at)
                        {{ round(\Carbon\Carbon::parse($report->actual_start_at)->diffInMinutes($report->actual_end_at) / 60, 2) }}
                        Hours
                    @else
                        --
                    @endif
                </td>
            </tr>
        </table>
    </div>

    @if(isset($reportType) && $reportType === 'scans_history')
        <div class="section">
            <div class="section-title">Scan History</div>
            @if(isset($scans) && count($scans) > 0)
                <table class="grid" style="border: 1px solid #e2e8f0;">
                    <thead>
                        <tr style="background-color: #f8fafc; border-bottom: 2px solid #e2e8f0;">
                            <th
                                style="padding: 8px; text-align: left; font-size: 10px; color: #64748b; font-weight: bold; width: 10%;">
                                TIME / DATE</th>
                            <th
                                style="padding: 8px; text-align: left; font-size: 10px; color: #64748b; font-weight: bold; width: 20%;">
                                MISSION / SITE</th>
                            <th
                                style="padding: 8px; text-align: left; font-size: 10px; color: #64748b; font-weight: bold; width: 15%;">
                                CHECKPOINT</th>
                            <th
                                style="padding: 8px; text-align: left; font-size: 10px; color: #64748b; font-weight: bold; width: 10%;">
                                METHOD</th>
                            <th
                                style="padding: 8px; text-align: left; font-size: 10px; color: #64748b; font-weight: bold; width: 45%;">
                                SCAN PROTOCOL DATA</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($scans as $scan)
                            <tr style="border-bottom: 1px solid #e2e8f0;">
                                <td style="padding: 8px; vertical-align: top;">
                                    <div style="font-weight: bold; color: #0f172a;">
                                        {{ \Carbon\Carbon::parse($scan->scanned_at)->format('H:i:s') }}
                                    </div>
                                    <div style="font-size: 10px; color: #64748b;">
                                        {{ \Carbon\Carbon::parse($scan->scanned_at)->format('M d, Y') }}
                                    </div>
                                </td>
                                <td style="padding: 8px; vertical-align: top;">
                                    <div style="font-weight: bold; color: #0f172a;">{{ $report->site_name }}</div>
                                    <div style="font-size: 10px; color: #64748b;">Duty #{{ $report->duty_number }}</div>
                                </td>
                                <td style="padding: 8px; vertical-align: top;">
                                    <div style="font-weight: bold; color: #0f172a;">{{ $scan->checkpoint_name }}</div>
                                    @if($scan->tour_route_name)
                                        <div style="font-size: 10px; color: #64748b;">Route: {{ $scan->tour_route_name }}</div>
                                    @endif
                                </td>
                                <td style="padding: 8px; vertical-align: top;">
                                    <div style="font-size: 10px; font-weight: bold; color: #475569; text-transform: uppercase;">
                                        {{ $scan->is_manual ? 'MANUAL' : 'SCAN' }}
                                    </div>
                                </td>
                                <td style="padding: 8px; vertical-align: top;">
                                    @if($scan->employee_message)
                                        <div
                                            style="margin-bottom: 5px; font-style: italic; color: #334155; background: #f1f5f9; padding: 5px; border-radius: 4px;">
                                            <span style="font-weight: bold; font-size: 9px; color: #64748b;">OBSERVATION:</span><br>
                                            {{ $scan->employee_message }}
                                        </div>
                                    @endif

                                    @php
                                        $scanImages = json_decode($scan->additional_photos ?? '[]', true);
                                    @endphp
                                    @if(!empty($scanImages))
                                        <div style="display: block;">
                                            @foreach($scanImages as $img)
                                                <img src="{{ storage_path('app/public/' . $img) }}"
                                                    style="width: 80px; height: auto; border: 1px solid #ccc; border-radius: 3px; display: inline-block; margin-right: 5px; margin-bottom: 5px;">
                                            @endforeach
                                        </div>
                                    @endif

                                    @if(empty($scan->employee_message) && empty($scanImages))
                                        <div style="font-size: 10px; color: #94a3b8; font-style: italic;">Verified Log Only</div>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div class="no-image">No checkpoint scans recorded for this schedule.</div>
            @endif
        </div>
    @else
        <div class="section">
            <div class="section-title">Check-in Evidence</div>
            @php
                $checkinImages = json_decode($report->checkin_images, true);
                $webpSupported = function_exists('imagecreatefromwebp');
            @endphp
            @if(!empty($checkinImages))
                <table class="images-grid">
                    <tr>
                        @foreach($checkinImages as $img)
                            <td>
                                @php
                                    $path = storage_path('app/public/' . $img);
                                    $ext = strtolower(pathinfo($path, PATHINFO_EXTENSION));
                                    $isWebP = $ext === 'webp';
                                    $fileOk = file_exists($path);
                                @endphp

                                @if($fileOk)
                                    @if($isWebP && !$webpSupported)
                                        <div class="no-image" style="font-size: 10px; color: #ef4444;">
                                            Image format (WebP) not supported by server.<br>
                                            Please contact admin to enable php_gd webp support.
                                        </div>
                                    @else
                                        <img src="{{ $path }}" class="evidence-img">
                                    @endif
                                @else
                                    <div class="no-image">Image Not Found</div>
                                @endif
                            </td>
                            @if(($loop->index + 1) % 3 == 0 && !$loop->last)
                                </tr>
                                <tr>
                            @endif
                        @endforeach
                    </tr>
                </table>
            @else
                <div class="no-image">No check-in evidence photos recorded.</div>
            @endif
        </div>

        <div class="section">
            <div class="section-title">Checkout Evidence</div>
            @php
                $checkoutImages = json_decode($report->checkout_evidence, true);
            @endphp
            @if(!empty($checkoutImages))
                <table class="images-grid">
                    <tr>
                        @foreach($checkoutImages as $img)
                            <td>
                                @php
                                    $path = storage_path('app/public/' . $img);
                                    $ext = strtolower(pathinfo($path, PATHINFO_EXTENSION));
                                    $isWebP = $ext === 'webp';
                                    $fileOk = file_exists($path);
                                @endphp

                                @if($fileOk)
                                    @if($isWebP && !$webpSupported)
                                        <div class="no-image" style="font-size: 10px; color: #ef4444;">
                                            Image format (WebP) not supported by server.<br>
                                            Please contact admin to enable php_gd webp support.
                                        </div>
                                    @else
                                        <img src="{{ $path }}" class="evidence-img">
                                    @endif
                                @else
                                    <div class="no-image">Image Not Found</div>
                                @endif
                            </td>
                            @if(($loop->index + 1) % 3 == 0 && !$loop->last)
                                </tr>
                                <tr>
                            @endif
                        @endforeach
                    </tr>
                </table>
            @else
                <div class="no-image">No checkout evidence photos recorded.</div>
            @endif
        </div>
    @endif

    <div class="footer">
        Generated on {{ now()->format('M d, Y H:i') }} | {{ $company->name ?? 'Vanguard Security' }}
    </div>
</body>

</html>