@extends('layouts.user')

@section('title', 'Incident Summary')

@section('content')
    <div class="space-y-6">
        <!-- Filters -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-200">
            <form method="GET" action="{{ route('reports.operational.incidents') }}" class="space-y-6">
                <div class="flex flex-col gap-6">
                    <div class="flex flex-col md:flex-row gap-6">
                        <!-- Date Range -->
                        <div class="w-full md:w-32">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Start
                                Date</label>
                            <input type="date" name="start_date" value="{{ request('start_date') }}"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                        </div>
                        <div class="w-full md:w-32">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">End
                                Date</label>
                            <input type="date" name="end_date" value="{{ request('end_date') }}"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                        </div>

                        <!-- Site Filter -->
                        <div class="w-full md:w-56">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Site</label>
                            <select name="site_id"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                                <option value="">All Sites</option>
                                @foreach($sites as $site)
                                    <option value="{{ $site->id }}" {{ request('site_id') == $site->id ? 'selected' : '' }}>
                                        {{ $site->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Employee Filter -->
                        <div class="w-full md:w-56">
                            <label
                                class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Employee</label>
                            <select name="employee_id"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                                <option value="">All Employees</option>
                                @foreach($employees as $emp)
                                    <option value="{{ $emp->id }}" {{ request('employee_id') == $emp->id ? 'selected' : '' }}>
                                        {{ $emp->first_name }} {{ $emp->last_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="flex items-end gap-2">
                            <button type="submit"
                                class="h-[38px] px-6 bg-slate-900 text-white text-sm font-medium rounded-lg hover:bg-slate-800 transition-colors whitespace-nowrap shadow-sm">
                                Apply Filters
                            </button>
                            <a href="{{ route('reports.operational.incident_analysis', request()->query()) }}"
                                class="h-[38px] px-4 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors flex items-center justify-center gap-2 whitespace-nowrap shadow-sm">
                                <svg class="w-4 h-4 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M11 3.055A9.001 9.001 0 1020.945 13H11V3.055z" />
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M20.488 9H15V3.512A9.025 9.025 0 0120.488 9z" />
                                </svg>
                                Analysis
                            </a>
                            <a href="{{ route('reports.operational.incidents.export.pdf', request()->query()) }}"
                                target="_blank"
                                class="h-[38px] px-4 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors flex items-center justify-center gap-2 whitespace-nowrap shadow-sm">
                                <svg class="w-4 h-4 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z">
                                    </path>
                                </svg>
                                Export PDF
                            </a>
                            <a href="{{ route('reports.operational.incidents.export.excel', request()->query()) }}"
                                target="_blank"
                                class="h-[38px] px-4 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors flex items-center justify-center gap-2 whitespace-nowrap shadow-sm">
                                <svg class="w-4 h-4 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                    </path>
                                </svg>
                                Export Excel
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <!-- Report Type Tabs -->
        <div class="flex space-x-1 bg-gray-100 p-1 rounded-xl w-fit">
            <a href="{{ route('reports.operational.incidents') }}"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ request()->routeIs('reports.operational.incidents') ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Incident Summary
            </a>
            <a href="{{ route('reports.operational.incident_counts') }}"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ request()->routeIs('reports.operational.incident_counts') ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Incident Counts
            </a>
            <a href="{{ route('reports.operational.banned') }}"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ request()->routeIs('reports.operational.banned') ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Banned Employees
            </a>
            <a href="{{ route('reports.operational.passwords') }}"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ request()->routeIs('reports.operational.passwords') ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Credentials
            </a>
        </div>

        <!-- Incidents Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-gray-50/50 border-b border-gray-100">
                        <tr>
                            <th class="px-3 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Date</th>
                            <th class="px-3 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Duty #</th>
                            <th class="px-3 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Employee</th>
                            <th class="px-3 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Site</th>
                            <th class="px-3 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Subject</th>
                            <th class="px-3 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Description
                            </th>
                            <th class="px-3 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider text-center">
                                Gallery</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($incidents as $row)
                            <tr class="hover:bg-gray-50/80 transition-colors">
                                <td class="px-3 py-3 whitespace-nowrap text-xs text-gray-900">
                                    {{ \Carbon\Carbon::parse($row->created_at)->format('M d, Y H:i') }}
                                </td>
                                <td class="px-3 py-3 whitespace-nowrap text-xs font-medium text-gray-500">
                                    #{{ $row->duty_number }}
                                </td>
                                <td class="px-3 py-3 whitespace-nowrap text-xs font-bold text-gray-900">
                                    {{ $row->first_name }} {{ $row->last_name }}
                                </td>
                                <td class="px-3 py-3 whitespace-nowrap text-xs text-gray-900">
                                    {{ $row->site_name }}
                                </td>
                                <td class="px-3 py-3 whitespace-nowrap text-xs text-gray-900 font-medium">
                                    {{ $row->subject }}
                                </td>
                                <td class="px-3 py-3 text-xs text-gray-500 max-w-xs truncate" title="{{ $row->description }}">
                                    {{ Str::limit($row->description, 50) }}
                                </td>
                                <td class="px-3 py-3 whitespace-nowrap text-center">
                                    @php
                                        $images = json_decode($row->images, true);
                                    @endphp
                                    @if(!empty($images) && count($images) > 0)
                                        <a href="{{ route('reports.operational.incidents.download', $row->id) }}"
                                            class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-slate-50 text-slate-600 hover:bg-slate-100 hover:text-blue-600 transition-all border border-slate-200"
                                            title="Download Images">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                    d="M2.25 15.75l5.159-5.159a2.25 2.25 0 013.182 0l5.159 5.159m-1.5-1.5l1.409-1.409a2.25 2.25 0 013.182 0l2.909 2.909m-18 3.75h16.5a1.5 1.5 0 001.5-1.5V6a1.5 1.5 0 00-1.5-1.5H3.75A1.5 1.5 0 002.25 6v12a1.5 1.5 0 001.5 1.5zm10.5-11.25h.008v.008h-.008V8.25zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z" />
                                            </svg>
                                        </a>
                                    @else
                                        <span class="text-gray-300">-</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="px-3 py-12 text-center text-gray-400">
                                    No incidents reported.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @if($incidents->hasPages())
                <div class="px-3 py-3 border-t border-gray-100">
                    {{ $incidents->withQueryString()->links() }}
                </div>
            @endif
        </div>
    </div>
@endsection