@extends('layouts.user')

@section('title', 'Incident Counts Report')

@section('content')
    <div class="space-y-6">
        <!-- Filters -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-200">
            <form method="GET" action="{{ route('reports.operational.incident_counts') }}" class="space-y-6">
                <div class="flex flex-col md:flex-row gap-6 items-end">
                    
                    <div class="w-full md:w-40">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Month</label>
                        <select name="month" class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                            @for($m = 1; $m <= 12; $m++)
                                <option value="{{ $m }}" {{ $month == $m ? 'selected' : '' }}>
                                    {{ \Carbon\Carbon::create()->month($m)->format('F') }}
                                </option>
                            @endfor
                        </select>
                    </div>

                    <div class="w-full md:w-32">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Year</label>
                        <select name="year" class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                            @foreach(range(now()->year - 2, now()->year + 1) as $y)
                                <option value="{{ $y }}" {{ $year == $y ? 'selected' : '' }}>{{ $y }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="w-full md:w-56">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Site</label>
                        <select name="site_id" class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                            <option value="">All Sites</option>
                            @foreach($sites as $site)
                                <option value="{{ $site->id }}" {{ request('site_id') == $site->id ? 'selected' : '' }}>
                                    {{ $site->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="flex items-center gap-2">
                        <button type="submit" class="h-[38px] px-6 bg-slate-900 text-white text-sm font-medium rounded-lg hover:bg-slate-800 transition-colors whitespace-nowrap shadow-sm">
                            Generate Report
                        </button>
                        <a href="{{ route('reports.operational.incident_counts.export.pdf', request()->query()) }}" target="_blank"
                            class="h-[38px] px-4 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors flex items-center justify-center gap-2 whitespace-nowrap shadow-sm">
                            <svg class="w-4 h-4 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path></svg>
                            Export PDF
                        </a>
                        <a href="{{ route('reports.operational.incident_counts.export.excel', request()->query()) }}" target="_blank"
                            class="h-[38px] px-4 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors flex items-center justify-center gap-2 whitespace-nowrap shadow-sm">
                            <svg class="w-4 h-4 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                            Export Excel
                        </a>
                    </div>
                </div>
            </form>
        </div>

        <!-- Report Type Tabs -->
        <div class="flex space-x-1 bg-gray-100 p-1 rounded-xl w-fit">
            <a href="{{ route('reports.operational.incidents') }}"
               class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ request()->routeIs('reports.operational.incidents') ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Incident Summary
            </a>
            <a href="{{ route('reports.operational.incident_counts') }}"
               class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ request()->routeIs('reports.operational.incident_counts') ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Incident Counts
            </a>
             <a href="{{ route('reports.operational.banned') }}"
               class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ request()->routeIs('reports.operational.banned') ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Banned Employees
            </a>
             <a href="{{ route('reports.operational.passwords') }}"
               class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ request()->routeIs('reports.operational.passwords') ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Credentials
            </a>
        </div>

        <!-- Data Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-gray-50/50 border-b border-gray-100">
                        <tr>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider sticky left-0 bg-gray-50 z-10 border-r border-gray-100">Site</th>
                            @for($d = 1; $d <= $days; $d++)
                                <th class="px-2 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider text-center w-10">{{ $d }}</th>
                            @endfor
                            <th class="px-4 py-4 text-[10px] font-bold text-gray-900 uppercase tracking-wider text-center border-l border-gray-100 bg-gray-50">Total</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($reportData as $row)
                            <tr class="hover:bg-gray-50/80 transition-colors">
                                <td class="px-6 py-3 whitespace-nowrap text-sm font-bold text-gray-900 sticky left-0 bg-white group-hover:bg-gray-50 border-r border-gray-100">
                                    {{ $row['site'] }}
                                </td>
                                @for($d = 1; $d <= $days; $d++)
                                    <td class="px-2 py-3 text-xs text-gray-600 text-center">
                                        @if($row['days'][$d] > 0)
                                            <span class="inline-flex items-center justify-center w-6 h-6 rounded-full bg-red-100 text-red-600 font-bold">
                                                {{ $row['days'][$d] }}
                                            </span>
                                        @else
                                            <span class="text-gray-300">0</span>
                                        @endif
                                    </td>
                                @endfor
                                <td class="px-4 py-3 text-sm font-bold text-gray-900 text-center border-l border-gray-100 bg-gray-50/50">
                                    {{ $row['total'] }}
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="{{ $days + 2 }}" class="px-6 py-12 text-center text-gray-400">
                                    No sites found.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                    <tfoot class="bg-gray-50 border-t border-gray-200">
                        <tr>
                            <td class="px-6 py-3 text-xs font-bold text-gray-900 sticky left-0 bg-gray-50 border-r border-gray-200">Totals</td>
                            @for($d = 1; $d <= $days; $d++)
                                @php
                                    $colTotal = collect($reportData)->sum(fn($row) => $row['days'][$d]);
                                @endphp
                                <td class="px-2 py-3 text-xs font-bold text-center text-gray-900">
                                    {{ $colTotal > 0 ? $colTotal : '-' }}
                                </td>
                            @endfor
                            <td class="px-4 py-3 text-xs font-bold text-center text-gray-900 border-l border-gray-200">
                                {{ collect($reportData)->sum('total') }}
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
@endsection
