<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Consolidated Operational Report</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 10px;
            color: #333;
        }

        .header {
            margin-bottom: 20px;
        }

        .title {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .meta {
            font-size: 12px;
            color: #666;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
        }

        th {
            background-color: #f3f4f6;
            font-weight: bold;
            text-transform: uppercase;
        }

        .text-right {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }

        .employee-header {
            background-color: #e5e7eb;
            font-weight: bold;
            padding: 8px;
            margin-top: 15px;
            margin-bottom: 5px;
            border: 1px solid #ddd;
        }

        .grand-total {
            background-color: #f3f4f6;
            font-weight: bold;
        }

        .page-break {
            page-break-after: always;
        }
    </style>
</head>

<body>
    <div style="margin-bottom: 20px;">
        @if($company)
            <div style="margin-bottom: 15px; border-bottom: 2px solid #1e293b; padding-bottom: 10px;">
                <h2 style="margin: 0; font-size: 20px; color: #1e293b; text-transform: uppercase;">{{ $company->name }}</h2>
                <p style="margin: 2px 0; font-size: 11px; color: #4b5563;">
                    {{ $company->address_1 }}{{ $company->address_2 ? ', ' . $company->address_2 : '' }}
                </p>
            </div>
        @endif
        <h3 style="margin: 0; color: #334155;">Consolidated Operational Report</h3>
        <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Period:
            {{ \Carbon\Carbon::parse($startDate)->format('M d, Y') }} -
            {{ \Carbon\Carbon::parse($endDate)->format('M d, Y') }}
        </p>
        <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Generated By: {{ auth()->user()->name }}</p>
        <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Date Generated: {{ now()->format('M d, Y H:i') }}</p>
    </div>

    @forelse($groupedConsolidated as $empHeader => $items)
        <div class="employee-section">
            <div class="employee-header">{{ $empHeader }}</div>

            <table>
                <thead>
                    <tr>
                        <th style="width: 12%;">Site/Route</th>
                        <th style="width: 8%;">Role</th>
                        <th style="width: 8%;">Duty #</th>
                        <th style="width: 10%;">Start</th>
                        <th style="width: 10%;">End</th>
                        <th style="width: 8%;">Type</th>
                        <th class="text-right" style="width: 6%;">Hrs</th>
                        <th class="text-right" style="width: 7%;">SIN Rate</th>
                        <th class="text-right" style="width: 7%;">Other Rate</th>
                        <th class="text-right" style="width: 6%;">Gas</th>
                        <th class="text-right" style="width: 6%;">Allow</th>
                        <th class="text-center" style="width: 5%;">Tkts</th>
                        <th class="text-right" style="width: 7%;">Total</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $totalHrs = 0;
                        $totalGas = 0;
                        $totalAllowance = 0;
                        $totalTickets = 0;
                        $totalAmount = 0;
                    @endphp
                    @foreach($items as $row)
                        @php
                            $totalHrs += $row->actual_hrs;
                            $totalGas += $row->gas;
                            $totalAllowance += $row->allowance;
                            $totalTickets += $row->tickets_count;
                            $totalAmount += $row->total_amount;
                        @endphp
                        <tr>
                            <td>{{ $row->site_route }}</td>
                            <td style="text-transform: capitalize;">{{ $row->role }}</td>
                            <td>{{ $row->duty_number }}</td>
                            <td>{{ $row->start_time ? $row->start_time->format('m-d H:i') : '-' }}</td>
                            <td>{{ $row->end_time ? $row->end_time->format('m-d H:i') : '-' }}</td>
                            <td style="text-transform: uppercase;">{{ $row->pay_type }}</td>
                            <td class="text-right">{{ number_format($row->actual_hrs, 2) }}</td>
                            <td class="text-right">{{ number_format($row->sin_rate, 2) }}</td>
                            <td class="text-right">{{ number_format($row->other_rate, 2) }}</td>
                            <td class="text-right">{{ $row->gas ? number_format($row->gas, 0) : '0' }}</td>
                            <td class="text-right">{{ $row->allowance ? number_format($row->allowance, 0) : '0' }}</td>
                            <td class="text-center">{{ $row->tickets_count }}</td>
                            <td class="text-right bold">{{ number_format($row->total_amount, 2) }}</td>
                        </tr>
                    @endforeach
                    <tr class="grand-total">
                        <td colspan="6" class="text-right">Grand Total</td>
                        <td class="text-right">{{ number_format($totalHrs, 2) }}</td>
                        <td class="text-right">-</td>
                        <td class="text-right">-</td>
                        <td class="text-right">{{ number_format($totalGas, 0) }}</td>
                        <td class="text-right">{{ number_format($totalAllowance, 0) }}</td>
                        <td class="text-center">{{ $totalTickets }}</td>
                        <td class="text-right">{{ number_format($totalAmount, 2) }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    @empty
        <p>No records found for the selected period.</p>
    @endforelse
</body>

</html>