@extends('layouts.user')

@section('title', 'Quotation Details')

@section('content')
    <div class="p-6 max-w-6xl mx-auto">
        <!-- Header with Back Button -->
        <div class="flex items-center gap-4 mb-6">
            <a href="{{ route('quotations.index') }}" class="p-2 rounded-full hover:bg-gray-100 transition-colors">
                <svg class="w-6 h-6 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18">
                    </path>
                </svg>
            </a>
            <div class="flex-1">
                <h1 class="text-2xl font-bold text-gray-900">Quotation {{ $quotation->quotation_number }}</h1>
                <p class="text-gray-500">Issued on {{ $quotation->issue_date->format('M d, Y') }}</p>
            </div>

            <!-- Action Buttons -->
            <div class="flex items-center gap-2">
                <a href="{{ route('quotations.pdf', $quotation->id) }}"
                    class="px-4 py-2 bg-red-600 text-white font-bold rounded-lg hover:bg-red-700 transition-all shadow-lg shadow-red-500/20 flex items-center gap-2">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                        </path>
                    </svg>
                    Download PDF
                </a>

                @if($quotation->email_sent_count > 0)
                    <form action="{{ route('quotations.resend', $quotation->id) }}" method="POST" class="inline">
                        @csrf
                        <button type="submit"
                            class="px-4 py-2 bg-green-600 text-white font-bold rounded-lg hover:bg-green-700 transition-all shadow-lg shadow-green-500/20 flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15">
                                </path>
                            </svg>
                            Resend Email
                        </button>
                    </form>
                @else
                    <form action="{{ route('quotations.email', $quotation->id) }}" method="POST" class="inline">
                        @csrf
                        <button type="submit"
                            class="px-4 py-2 bg-purple-600 text-white font-bold rounded-lg hover:bg-purple-700 transition-all shadow-lg shadow-purple-500/20 flex items-center gap-2"
                            @if(!$quotation->client_email) disabled title="Client email not set" @endif>
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                                </path>
                            </svg>
                            Send Email
                        </button>
                    </form>
                @endif
            </div>
        </div>

        @if(session('success'))
            <div class="mb-6 p-4 bg-green-50 border border-green-200 text-green-700 rounded-xl font-bold">
                {{ session('success') }}
            </div>
        @endif

        @if($errors->any())
            <div class="mb-6 p-4 bg-red-50 border border-red-200 text-red-700 rounded-xl">
                @foreach($errors->all() as $error)
                    <p class="font-bold">{{ $error }}</p>
                @endforeach
            </div>
        @endif

        <!-- Status and Email Info -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
            <div class="bg-white rounded-xl border border-gray-100 p-4 shadow-sm">
                <div class="text-xs font-bold text-gray-500 uppercase mb-2">Status</div>
                @php
                    $statusColors = [
                        'draft' => 'bg-gray-100 text-gray-600',
                        'sent' => 'bg-amber-100 text-amber-600',
                        'accepted' => 'bg-emerald-100 text-emerald-600',
                        'rejected' => 'bg-rose-100 text-rose-600',
                        'expired' => 'bg-slate-100 text-slate-500',
                    ];
                @endphp
                <span
                    class="px-3 py-1 rounded-full text-xs font-black uppercase tracking-wider {{ $statusColors[$quotation->status] ?? 'bg-gray-100 text-gray-600' }}">
                    {{ $quotation->status }}
                </span>
            </div>

            @if($quotation->email_sent_count > 0)
                <div class="bg-white rounded-xl border border-gray-100 p-4 shadow-sm">
                    <div class="text-xs font-bold text-gray-500 uppercase mb-2">Email Sent</div>
                    <div class="text-lg font-bold text-gray-900">{{ $quotation->email_sent_count }} times</div>
                    @if($quotation->last_email_sent_at)
                        <div class="text-xs text-gray-400 mt-1">Last: {{ $quotation->last_email_sent_at->format('M d, Y H:i') }}
                        </div>
                    @endif
                </div>
            @endif

            <div class="bg-white rounded-xl border border-gray-100 p-4 shadow-sm">
                <div class="text-xs font-bold text-gray-500 uppercase mb-2">Total Amount</div>
                <div class="text-2xl font-bold text-gray-900">${{ number_format($quotation->total_amount, 2) }}</div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
            <div class="p-8">
                <!-- Company and Client Info -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-8">
                    <div>
                        <h3 class="text-xs font-bold text-gray-500 uppercase mb-3">From</h3>
                        <div class="text-lg font-bold text-gray-900">{{ $quotation->company->name ?? 'Company Not Set' }}
                        </div>
                        @if($quotation->company && $quotation->company->address)
                            <p class="text-gray-600 text-sm">{{ $quotation->company->address }}</p>
                        @endif
                        @if($quotation->company && $quotation->company->phone)
                            <p class="text-gray-600 text-sm">Phone: {{ $quotation->company->phone }}</p>
                        @endif
                        @if($quotation->company && $quotation->company->email)
                            <p class="text-gray-600 text-sm">Email: {{ $quotation->company->email }}</p>
                        @endif
                    </div>

                    <div>
                        <h3 class="text-xs font-bold text-gray-500 uppercase mb-3">Billed To</h3>
                        <div class="text-lg font-bold text-gray-900">{{ $quotation->client_name }}</div>
                        @if($quotation->client_email)
                            <p class="text-gray-600 text-sm">{{ $quotation->client_email }}</p>
                        @endif
                        @if($quotation->client_phone)
                            <p class="text-gray-600 text-sm">{{ $quotation->client_phone }}</p>
                        @endif
                        @if($quotation->client_address)
                            <p class="text-gray-600 text-sm">{{ $quotation->client_address }}</p>
                        @endif
                    </div>
                </div>

                <!-- Quotation Details -->
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-8 bg-slate-50 p-4 rounded-lg">
                    <div>
                        <div class="text-xs font-bold text-gray-500 uppercase">Issue Date</div>
                        <div class="text-sm font-bold text-gray-900">{{ $quotation->issue_date->format('M d, Y') }}</div>
                    </div>
                    @if($quotation->valid_until)
                        <div>
                            <div class="text-xs font-bold text-gray-500 uppercase">Valid Until</div>
                            <div class="text-sm font-bold text-gray-900">{{ $quotation->valid_until->format('M d, Y') }}</div>
                        </div>
                    @endif
                    <div>
                        <div class="text-xs font-bold text-gray-500 uppercase">Prepared By</div>
                        <div class="text-sm font-bold text-gray-900">{{ $quotation->user->name ?? 'System' }}</div>
                    </div>
                </div>

                <!-- Line Items Table -->
                <div class="mb-6">
                    <h3 class="text-xs font-bold text-gray-500 uppercase mb-4">Items</h3>
                    <table class="w-full border-collapse">
                        <thead>
                            <tr class="bg-slate-50 border-b-2 border-gray-200">
                                <th class="px-4 py-3 text-left text-xs font-bold text-gray-500 uppercase">Description</th>
                                <th class="px-4 py-3 text-center text-xs font-bold text-gray-500 uppercase">Qty</th>
                                <th class="px-4 py-3 text-center text-xs font-bold text-gray-500 uppercase">Hours</th>
                                <th class="px-4 py-3 text-right text-xs font-bold text-gray-500 uppercase">Rate</th>
                                <th class="px-4 py-3 text-right text-xs font-bold text-gray-500 uppercase">Amount</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100">
                            @foreach($quotation->items as $item)
                                <tr>
                                    <td class="px-4 py-4">
                                        <div class="font-bold text-gray-900">{{ $item->description }}</div>
                                        @if($item->type === 'product')
                                            <span class="text-xs text-gray-500">(Product)</span>
                                        @endif
                                    </td>
                                    <td class="px-4 py-4 text-center font-medium text-gray-900">{{ $item->quantity }}</td>
                                    <td class="px-4 py-4 text-center font-medium text-gray-900">
                                        {{ $item->hours > 0 ? $item->hours : '-' }}</td>
                                    <td class="px-4 py-4 text-right font-medium text-gray-900">
                                        ${{ number_format($item->unit_price, 2) }}</td>
                                    <td class="px-4 py-4 text-right font-bold text-gray-900">
                                        ${{ number_format($item->total_price, 2) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Totals -->
                <div class="flex justify-end">
                    <div class="w-full md:w-1/3">
                        <div class="flex justify-between py-3 border-b border-gray-200">
                            <span class="font-medium text-gray-600">Subtotal:</span>
                            <span class="font-bold text-gray-900">${{ number_format($quotation->subtotal, 2) }}</span>
                        </div>
                        @if($quotation->tax_rate > 0)
                            <div class="flex justify-between py-3 border-b border-gray-200">
                                <span class="font-medium text-gray-600">Tax ({{ $quotation->tax_rate }}%):</span>
                                <span class="font-bold text-gray-900">${{ number_format($quotation->tax_amount, 2) }}</span>
                            </div>
                        @endif
                        <div class="flex justify-between py-4 bg-slate-900 text-white px-4 rounded-lg mt-2">
                            <span class="font-bold text-lg">Total:</span>
                            <span class="font-bold text-2xl">${{ number_format($quotation->total_amount, 2) }}</span>
                        </div>
                    </div>
                </div>

                <!-- Notes -->
                @if($quotation->notes)
                    <div class="mt-8 pt-6 border-t border-gray-200">
                        <h3 class="text-xs font-bold text-gray-500 uppercase mb-3">Notes / Terms & Conditions</h3>
                        <p class="text-gray-700 text-sm whitespace-pre-line">{{ $quotation->notes }}</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection