@extends('layouts.user')

@section('title', 'All Quotations')

@section('content')
    <div class="p-6">
        <div class="flex flex-col gap-4 mb-6">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">Quotations</h1>
                    <p class="text-gray-500">Manage client quotations and price estimates.</p>
                </div>
                <a href="{{ route('quotations.create') }}"
                    class="px-6 py-2 bg-blue-600 text-white font-bold rounded-lg hover:bg-blue-700 transition-all shadow-lg shadow-blue-500/20">
                    + Create New Quote
                </a>
            </div>

            <!-- Tabs -->
            <div class="flex gap-2 border-b border-gray-200">
                <a href="{{ route('quotations.index', array_merge(request()->except('tab'), ['tab' => 'all'])) }}"
                    class="px-4 py-2 font-medium transition-all {{ (!request('tab') || request('tab') === 'all') ? 'border-b-2 border-blue-600 text-blue-600' : 'text-gray-500 hover:text-gray-700' }}">
                    All Quotations
                </a>
                <a href="{{ route('quotations.index', array_merge(request()->except('tab'), ['tab' => 'email_history'])) }}"
                    class="px-4 py-2 font-medium transition-all {{ request('tab') === 'email_history' ? 'border-b-2 border-blue-600 text-blue-600' : 'text-gray-500 hover:text-gray-700' }}">
                    Email History
                </a>
            </div>

            <!-- Filters -->
            <div class="flex flex-wrap gap-3 items-center bg-white p-3 rounded-xl border border-gray-100 shadow-sm">
                <form method="GET" action="{{ url()->current() }}" class="flex items-center gap-3 w-full">
                    @foreach(request()->except(['company_id', 'user_id', 'page']) as $key => $value)
                        <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                    @endforeach

                    <div class="flex items-center gap-2">
                        <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z" />
                        </svg>
                        <span class="text-xs font-bold text-gray-500 uppercase">Filters:</span>
                    </div>

                    <select name="company_id" onchange="this.form.submit()"
                        class="text-sm border-gray-200 rounded-lg focus:ring-blue-500 focus:border-blue-500 py-1.5 pl-3 pr-8 w-48">
                        <option value="">All Companies</option>
                        @foreach($companies as $id => $name)
                            <option value="{{ $id }}" {{ request('company_id') == $id ? 'selected' : '' }}>{{ $name }}</option>
                        @endforeach
                    </select>

                    <select name="user_id" onchange="this.form.submit()"
                        class="text-sm border-gray-200 rounded-lg focus:ring-blue-500 focus:border-blue-500 py-1.5 pl-3 pr-8 w-48">
                        <option value="">All Creators</option>
                        @foreach($creators as $id => $name)
                            <option value="{{ $id }}" {{ request('user_id') == $id ? 'selected' : '' }}>{{ $name }}</option>
                        @endforeach
                    </select>
                </form>
            </div>
        </div>

        @if(session('success'))
            <div class="mb-6 p-4 bg-green-50 border border-green-200 text-green-700 rounded-xl font-bold">
                {{ session('success') }}
            </div>
        @endif

        @if($errors->any())
            <div class="mb-6 p-4 bg-red-50 border border-red-200 text-red-700 rounded-xl">
                @foreach($errors->all() as $error)
                    <p class="font-bold">{{ $error }}</p>
                @endforeach
            </div>
        @endif

        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
            <table class="w-full text-left border-collapse">
                <thead>
                    <tr
                        class="bg-slate-50 border-b border-gray-100 text-xs uppercase text-gray-400 font-bold tracking-wider">
                        <th class="px-6 py-4">Quote #</th>
                        <th class="px-6 py-4">Client</th>
                        <th class="px-6 py-4">Date</th>
                        <th class="px-6 py-4">Created By</th>
                        <th class="px-6 py-4">Amount</th>
                        <th class="px-6 py-4">Status</th>
                        @if(request('tab') === 'email_history')
                            <th class="px-6 py-4">Email Info</th>
                        @endif
                        <th class="px-6 py-4 text-right">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-50">
                    @forelse($quotations as $quote)
                        <tr class="hover:bg-gray-50 transition-colors">
                            <td class="px-6 py-4 font-mono text-sm font-bold text-blue-600">
                                {{ $quote->quotation_number }}
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm font-bold text-gray-900">{{ $quote->client_name }}</div>
                                <div class="text-xs text-gray-400">{{ $quote->client_email }}</div>
                            </td>
                            <td class="px-6 py-4 text-sm font-medium text-gray-600">
                                {{ $quote->issue_date->format('M d, Y') }}
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm font-medium text-gray-900">{{ $quote->user->name ?? 'System' }}</div>
                            </td>
                            <td class="px-6 py-4 font-bold text-gray-900">
                                ${{ number_format($quote->total_amount, 2) }}
                            </td>
                            <td class="px-6 py-4">
                                @php
                                    $statusColors = [
                                        'draft' => 'bg-gray-100 text-gray-600',
                                        'sent' => 'bg-amber-100 text-amber-600',
                                        'accepted' => 'bg-emerald-100 text-emerald-600',
                                        'rejected' => 'bg-rose-100 text-rose-600',
                                        'expired' => 'bg-slate-100 text-slate-500',
                                    ];
                                @endphp
                                <span
                                    class="px-3 py-1 rounded-full text-[10px] font-black uppercase tracking-wider {{ $statusColors[$quote->status] ?? 'bg-gray-100 text-gray-600' }}">
                                    {{ $quote->status }}
                                </span>
                            </td>
                            @if(request('tab') === 'email_history')
                                <td class="px-6 py-4">
                                    <div class="space-y-2">
                                        @forelse($quote->emailLogs as $log)
                                            <div class="text-[10px] leading-tight border-l-2 border-blue-200 pl-2">
                                                <div class="font-bold text-gray-700">{{ $log->sent_at->format('M d, Y H:i') }}</div>
                                                <div class="text-gray-400">By: {{ $log->sender->name ?? 'Unknown' }}</div>
                                            </div>
                                        @empty
                                            <div class="text-xs text-gray-400italic">No detailed logs</div>
                                        @endforelse
                                    </div>
                                </td>
                            @endif
                            <td class="px-6 py-4">
                                <div class="flex items-center justify-end gap-2">
                                    {{-- View Button --}}
                                    <a href="{{ route('quotations.show', $quote->id) }}" 
                                        class="p-2 text-blue-600 hover:bg-blue-50 rounded-lg transition-colors" 
                                        title="View Details">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                                d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                        </svg>
                                    </a>

                                    {{-- PDF Button --}}
                                    <a href="{{ route('quotations.pdf', $quote->id) }}" 
                                        class="p-2 text-red-600 hover:bg-red-50 rounded-lg transition-colors" 
                                        title="Download PDF">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                                d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                            </path>
                                        </svg>
                                    </a>

                                    {{-- Email Button --}}
                                    @if($quote->email_sent_count > 0)
                                        <form action="{{ route('quotations.resend', $quote->id) }}" method="POST" class="inline">
                                            @csrf
                                            <button type="submit" 
                                                class="p-2 text-green-600 hover:bg-green-50 rounded-lg transition-colors" 
                                                title="Resend Email (Sent {{ $quote->email_sent_count }}x)">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                                        d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                                                </svg>
                                            </button>
                                        </form>
                                    @else
                                        <form action="{{ route('quotations.email', $quote->id) }}" method="POST" class="inline">
                                            @csrf
                                            <button type="submit" 
                                                class="p-2 text-purple-600 hover:bg-purple-50 rounded-lg transition-colors" 
                                                title="Send Email"
                                                @if(!$quote->client_email) disabled class="opacity-50 cursor-not-allowed" @endif>
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                                        d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                                                    </path>
                                                </svg>
                                            </button>
                                        </form>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="{{ request('tab') === 'email_history' ? '8' : '7' }}" class="px-6 py-12 text-center">
                                <div class="flex flex-col items-center justify-center text-gray-400">
                                    <svg class="w-12 h-12 mb-3 text-gray-300" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                        </path>
                                    </svg>
                                    <p class="text-sm font-bold">
                                        @if(request('tab') === 'email_history')
                                            No quotations have been emailed yet.
                                        @else
                                            No quotations found.
                                        @endif
                                    </p>
                                    <p class="text-xs mt-1">Create your first quote to get started.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $quotations->links() }}
        </div>
    </div>
@endsection