<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>{{ $title }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
        }

        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 7px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }

        th,
        td {
            border: 1px solid #444;
            padding: 3px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
            font-size: 7px;
        }

        .header {
            text-align: center;
            margin-bottom: 15px;
        }

        .header h1 {
            font-size: 14px;
            margin: 5px 0;
        }

        .header h2 {
            font-size: 16px;
            margin: 0 0 5px 0;
        }

        .header p {
            font-size: 9px;
            color: #666;
        }
    </style>
</head>

<body>
    <div class="header">
        @if(isset($company))
            <h2 style="font-size: 18px; margin: 0 0 5px 0; font-weight: bold;">{{ $company->name }}</h2>
            @if($company->address_1 || $company->address_2)
                <p style="margin: 0 0 15px 0; font-size: 10px; color: #333;">
                    @if($company->address_1){{ $company->address_1 }}@endif
                    @if($company->address_2)<br>{{ $company->address_2 }}@endif
                </p>
            @endif
        @endif
        <h1>{{ $title }}</h1>
        <p>Generated on {{ now()->format('Y-m-d H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                @foreach($headers as $header)
                    <th>{{ $header }}</th>
                @endforeach
            </tr>
        </thead>
        <tbody>
            @foreach($data as $row)
                <tr>
                    @foreach($row as $cell)
                        <td>{{ $cell }}</td>
                    @endforeach
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>