<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Patroller Schedules Report</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 10pt;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
            vertical-align: top;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        .header {
            margin-bottom: 20px;
        }

        .company-name {
            font-size: 16pt;
            font-weight: bold;
        }

        .report-date {
            color: #666;
            font-size: 9pt;
        }

        .success {
            color: green;
        }

        .danger {
            color: red;
        }

        .w-10 {
            width: 10%;
        }

        .w-20 {
            width: 20%;
        }
    </style>
</head>

<body>
    <div class="header">
        @if(isset($company))
            <div class="company-name">{{ $company->name }}</div>
            @if($company->address_1 || $company->address_2)
                <div style="font-size: 10pt; color: #333;">
                    @if($company->address_1){{ $company->address_1 }}@endif
                    @if($company->address_2)<br>{{ $company->address_2 }}@endif
                </div>
            @endif
        @else
            <div class="company-name">{{ session('company_name') ?? 'Security Company' }}</div>
        @endif
        <div class="report-date">Generated on: {{ now()->format('M d, Y h:i A') }}</div>
        <h3>Patroller Schedules Report</h3>
    </div>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Route</th>
                <th>Employees</th>
                <th>Job Status</th>
                <th>Sched Time</th>
                <th>Actual Time</th>
                <th>Sites Visited</th>
                <th>Tickets</th>
            </tr>
        </thead>
        <tbody>
            @foreach($schedules as $schedule)
                <tr>
                    <td>{{ $schedule->scheduled_date->format('M d, Y') }}</td>
                    <td>
                        <b>{{ $schedule->route->name ?? 'N/A' }}</b>
                        <br><small>{{ $schedule->route->run_no ?? '' }}</small>
                    </td>
                    <td>
                        @foreach($schedule->employees as $emp)
                            <div>{{ $emp->user->name ?? ($emp->first_name . ' ' . $emp->last_name) }}</div>
                        @endforeach
                        @if($schedule->employees->count() == 0)
                            <i>Unassigned</i>
                        @endif
                    </td>
                    <td>{{ ucfirst(str_replace('_', ' ', $schedule->job_status)) }}</td>
                    <td>
                        <strong>In:</strong> {{ $schedule->from_time->format('M d, Y h:i A') }}<br>
                        <strong>Out:</strong> {{ $schedule->to_time->format('M d, Y h:i A') }}
                    </td>
                    <td>
                        @if($schedule->job_started_at)
                            @php $startTime = \Carbon\Carbon::parse($schedule->job_started_at); @endphp
                            <strong>In:</strong> {{ $startTime->format('M d, Y h:i A') }}
                        @endif
                        @if($schedule->job_ended_at)
                            @php $endTime = \Carbon\Carbon::parse($schedule->job_ended_at); @endphp
                            <br><strong>Out:</strong> {{ $endTime->format('M d, Y h:i A') }}
                        @endif
                        @if(!$schedule->job_started_at && !$schedule->job_ended_at)
                            -
                        @endif
                    </td>
                    <td>
                        {{ $schedule->jobSites->whereNotNull('checked_in_at')->count() }} /
                        {{ $schedule->jobSites->count() }}
                    </td>
                    <td>
                        {{ $schedule->issueTickets->count() }}
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>