@extends(request()->routeIs('admin.*') ? 'layouts.admin' : 'layouts.user')

@section('content')
    <div class="p-6">
        <div class="flex flex-col gap-4 mb-6">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">Lead Management</h1>
                    <p class="text-gray-500">Track and manage potential security contracts.</p>
                </div>
                @if(!request()->routeIs('admin.*'))
                    <a href="{{ route('leads.create') }}"
                        class="px-6 py-2 bg-blue-600 text-white font-bold rounded-lg hover:bg-blue-700 transition-all shadow-lg shadow-blue-500/20">
                        + New Lead
                    </a>
                @endif
            </div>

        </div>

        <!-- Stats Cards -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
            <a href="{{ route('leads.index', ['status' => 'new']) }}"
                class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100 hover:border-blue-500 transition-colors group">
                <div class="flex justify-between items-start">
                    <div>
                        <p class="text-xs font-bold text-gray-400 uppercase tracking-widest">New Leads</p>
                        <h3 class="text-3xl font-black text-gray-800 mt-2 group-hover:text-blue-600 transition-colors">
                            {{ $counts['new'] }}
                        </h3>
                    </div>
                    <div class="p-3 bg-blue-50 text-blue-600 rounded-xl">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                        </svg>
                    </div>
                </div>
            </a>

            <a href="{{ route('leads.index', ['status' => 'contacted']) }}"
                class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100 hover:border-amber-500 transition-colors group">
                <div class="flex justify-between items-start">
                    <div>
                        <p class="text-xs font-bold text-gray-400 uppercase tracking-widest">Active Pipeline</p>
                        <h3 class="text-3xl font-black text-gray-800 mt-2 group-hover:text-amber-600 transition-colors">
                            {{ $counts['active'] }}
                        </h3>
                    </div>
                    <div class="p-3 bg-amber-50 text-amber-600 rounded-xl">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M17 8h2a2 2 0 012 2v6a2 2 0 01-2 2h-2v4l-4-4H9a1.994 1.994 0 01-1.414-.586m0 0L11 14h4a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2v4l.586-.586z">
                            </path>
                        </svg>
                    </div>
                </div>
            </a>

            <a href="{{ route('leads.index', ['status' => 'won']) }}"
                class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100 hover:border-emerald-500 transition-colors group">
                <div class="flex justify-between items-start">
                    <div>
                        <p class="text-xs font-bold text-gray-400 uppercase tracking-widest">Won Deals</p>
                        <h3 class="text-3xl font-black text-gray-800 mt-2 group-hover:text-emerald-600 transition-colors">
                            {{ $counts['won'] }}
                        </h3>
                    </div>
                    <div class="p-3 bg-emerald-50 text-emerald-600 rounded-xl">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>
            </a>
        </div>

        <!-- Leads Table -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
            <table class="w-full text-left border-collapse">
                <thead>
                    <tr
                        class="bg-slate-50 border-b border-gray-100 text-xs uppercase text-gray-400 font-bold tracking-wider">
                        <th class="px-6 py-4">Lead Name</th>
                        <th class="px-6 py-4">Company / Site</th>
                        <th class="px-6 py-4">Status</th>
                        <th class="px-6 py-4">Created By</th>
                        <th class="px-6 py-4">Next Action</th>
                        <th class="px-6 py-4 text-right"></th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-50">
                    @forelse($leads as $lead)
                        <tr class="hover:bg-gray-50 transition-colors group cursor-pointer"
                            onclick="window.location='{{ route('leads.show', $lead) }}'">
                            <td class="px-6 py-4">
                                <div class="font-bold text-gray-900">{{ $lead->name }}</div>
                                <div class="text-xs text-gray-500">{{ $lead->job_title ?? 'No Title' }}</div>
                            </td>
                            <td class="px-6 py-4">
                                @if($lead->company_name)
                                    <div class="font-bold text-gray-800">{{ $lead->company_name }}</div>
                                @endif
                                <div class="text-xs text-gray-500 flex items-center gap-1">
                                    <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                                        </path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    </svg>
                                    {{ $lead->site_location ?? 'No Location' }}
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                @php
                                    $colors = [
                                        'new' => 'bg-blue-100 text-blue-700',
                                        'contacted' => 'bg-amber-100 text-amber-700',
                                        'matured' => 'bg-purple-100 text-purple-700',
                                        'proposal' => 'bg-indigo-100 text-indigo-700',
                                        'won' => 'bg-emerald-100 text-emerald-700',
                                        'lost' => 'bg-gray-100 text-gray-500',
                                        'disqualified' => 'bg-red-100 text-red-700',
                                    ];
                                @endphp
                                <span
                                    class="px-3 py-1 rounded-full text-[10px] font-black uppercase tracking-wider {{ $colors[$lead->status] ?? 'bg-gray-100 text-gray-600' }}">
                                    {{ ucfirst($lead->status) }}
                                </span>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm font-medium text-gray-900">{{ $lead->creator->name ?? 'System' }}</div>
                                <div class="text-xs text-gray-400">{{ $lead->created_at->format('M d, Y') }}</div>
                            </td>
                            <td class="px-6 py-4">
                                @if($lead->next_follow_up_date)
                                    <div
                                        class="text-sm font-bold {{ $lead->next_follow_up_date->isPast() ? 'text-red-500' : 'text-gray-700' }}">
                                        {{ $lead->next_follow_up_date->format('M d') }}
                                    </div>
                                    <div class="text-xs text-gray-400">{{ $lead->next_action ?? 'Follow Up' }}</div>
                                @else
                                    <span class="text-xs text-gray-400 italic">No scheduled action</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-right">
                                <svg class="w-5 h-5 text-gray-300 group-hover:text-blue-500 transition-colors" fill="none"
                                    stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7">
                                    </path>
                                </svg>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center text-gray-500">
                                <svg class="w-12 h-12 mx-auto text-gray-300 mb-3" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z">
                                    </path>
                                </svg>
                                <p class="font-bold">No leads found in this view.</p>
                                <p class="text-xs mt-1">Try adjusting filters or create a new lead.</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $leads->links() }}
        </div>
    </div>
@endsection