<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="scroll-smooth">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Shift Matrix') }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Styles -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
    </style>
</head>

<body class="bg-gray-50 text-gray-900 antialiased min-h-screen flex flex-col font-sans">
    <!-- Navigation -->
    <nav class="fixed w-full z-50 transition-all duration-300 bg-white/90 backdrop-blur-md border-b border-gray-200"
        id="navbar">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-20">
                <!-- Logo -->
                <div class="flex-shrink-0 flex items-center py-2">
                    <a href="{{ route('landing') }}" class="flex items-center">
                        <img src="{{ asset('images/logo.png') }}" alt="Shift Matrix"
                            class="h-24 md:h-32 w-auto object-contain scale-125">
                    </a>
                </div>

                <!-- Desktop Menu -->
                <div class="hidden md:flex items-center space-x-8">
                    <a href="{{ route('landing') }}"
                        class="text-gray-600 hover:text-blue-600 font-medium transition-colors">Home</a>
                    <a href="{{ route('about') }}"
                        class="text-gray-600 hover:text-blue-600 font-medium transition-colors">About Us</a>
                    <a href="{{ route('contact') }}"
                        class="text-gray-600 hover:text-blue-600 font-medium transition-colors">Contact Us</a>
                </div>

                <!-- Auth Buttons -->
                <div class="hidden md:flex items-center space-x-4">
                    <div class="relative group">
                        <button
                            class="flex items-center space-x-1 text-gray-600 hover:text-blue-600 font-medium focus:outline-none">
                            <span>Login</span>
                            <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                        <!-- Dropdown -->
                        <div
                            class="absolute right-0 mt-2 w-48 bg-white rounded-xl shadow-lg border border-gray-100 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 transform origin-top-right">
                            <div class="py-1">
                                <a href="{{ route('employee.login') }}"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-50 hover:text-blue-600">Guard
                                    Login</a>
                                <a href="{{ route('login') }}"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-50 hover:text-blue-600">Employee
                                    Login</a>
                            </div>
                        </div>
                    </div>

                    <a href="{{ route('become-guard') }}"
                        class="px-5 py-2.5 rounded-full bg-blue-600 text-white font-medium shadow-lg shadow-blue-500/30 hover:bg-blue-700 hover:shadow-blue-600/40 transition-all transform hover:-translate-y-0.5">
                        Become a Guard
                    </a>
                </div>

                <!-- Mobile Menu Button -->
                <div class="md:hidden flex items-center">
                    <button id="mobile-menu-btn" class="text-gray-600 hover:text-blue-600 focus:outline-none p-2">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4 6h16M4 12h16M4 18h16"></path>
                        </svg>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile Menu -->
        <div id="mobile-menu" class="hidden md:hidden bg-white border-t border-gray-100">
            <div class="px-4 pt-2 pb-6 space-y-1">
                <a href="{{ route('landing') }}"
                    class="block px-3 py-2 text-base font-medium text-gray-700 hover:text-blue-600 hover:bg-gray-50 rounded-md">Home</a>
                <a href="{{ route('about') }}"
                    class="block px-3 py-2 text-base font-medium text-gray-700 hover:text-blue-600 hover:bg-gray-50 rounded-md">About
                    Us</a>
                <a href="{{ route('contact') }}"
                    class="block px-3 py-2 text-base font-medium text-gray-700 hover:text-blue-600 hover:bg-gray-50 rounded-md">Contact
                    Us</a>
                <div class="border-t border-gray-100 my-2"></div>
                <a href="{{ route('employee.login') }}"
                    class="block px-3 py-2 text-base font-medium text-gray-700 hover:text-blue-600 hover:bg-gray-50 rounded-md">Guard
                    Login</a>
                <a href="{{ route('login') }}"
                    class="block px-3 py-2 text-base font-medium text-gray-700 hover:text-blue-600 hover:bg-gray-50 rounded-md">Employee
                    Login</a>
                <div class="mt-4 px-3">
                    <a href="{{ route('become-guard') }}"
                        class="block w-full text-center px-5 py-3 rounded-lg bg-blue-600 text-white font-medium shadow-md">
                        Become a Guard
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="flex-grow pt-20">
        @yield('content')
    </main>

    <!-- Footer -->
    <footer class="bg-gray-900 text-white pt-12 md:pt-16 pb-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8 md:gap-12 mb-8 md:mb-12">
                <div class="col-span-1 md:col-span-2">
                    <img src="{{ asset('images/logo.png') }}" alt="Shift Matrix"
                        class="h-14 w-auto mb-6 brightness-0 invert object-contain">
                    <p class="text-gray-400 max-w-sm leading-relaxed">
                        Professional security solutions for modern needs. Linking qualified guards with top-tier
                        assignments.
                    </p>
                </div>
                <div>
                    <h4 class="text-lg font-semibold mb-4 text-white">Quick Links</h4>
                    <ul class="space-y-2">
                        <li><a href="{{ route('landing') }}"
                                class="text-gray-400 hover:text-blue-400 transition-colors">Home</a></li>
                        <li><a href="{{ route('about') }}"
                                class="text-gray-400 hover:text-blue-400 transition-colors">About Us</a></li>
                        <li><a href="{{ route('contact') }}"
                                class="text-gray-400 hover:text-blue-400 transition-colors">Contact Us</a></li>
                    </ul>
                </div>
                <div>
                    <h4 class="text-lg font-semibold mb-4 text-white">Portals</h4>
                    <ul class="space-y-2">
                        <li><a href="{{ route('employee.login') }}"
                                class="text-gray-400 hover:text-blue-400 transition-colors">Guard Login</a></li>
                        <li><a href="{{ route('login') }}"
                                class="text-gray-400 hover:text-blue-400 transition-colors">Employee Login</a></li>
                        <li><a href="{{ route('become-guard') }}"
                                class="text-gray-400 hover:text-blue-400 transition-colors">Become a Guard</a></li>
                    </ul>
                </div>
            </div>
            <div class="border-t border-gray-800 pt-8 text-center text-sm text-gray-500">
                <p>&copy; {{ date('Y') }} Shift Matrix. All rights reserved.</p>
                <p class="mt-2 text-xs">Developed by <a href="https://softbuiltsolutions.com/" target="_blank"
                        class="text-blue-400 hover:text-blue-300 transition-colors">soft Built Solutions</a></p>
            </div>
        </div>
    </footer>

    <script>
        // Mobile Menu Toggle
        document.getElementById('mobile-menu-btn').addEventListener('click', function () {
            document.getElementById('mobile-menu').classList.toggle('hidden');
        });
    </script>
</body>

</html>