<!DOCTYPE html>
<html lang="en" class="dark">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Meeting Room') - Shift Matrix</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Outfit:wght@400;500;600;700&display=swap"
        rel="stylesheet">
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <style>
        html,
        body {
            height: 100%;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: #0b0f1a;
            color: #f8fafc;
            overflow: hidden;
            width: 100%;
        }

        .glass {
            background: rgba(30, 41, 59, 0.7);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .meeting-grid {
            display: grid;
            gap: 0.25rem;
            padding: 0.25rem;
            height: 100%;
            transition: all 0.3s ease;
            overflow-y: hidden;
            /* Prevent grid overflow */
        }

        .participant-card {
            background: #1e293b;
            border-radius: 0.75rem;
            overflow: hidden;
            position: relative;
            aspect-ratio: 16/9;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 2px solid transparent;
            max-height: 100%;
            /* Ensure it doesn't overflow vertically */
            margin: auto;
        }

        .participant-card.active-speaker {
            border-color: #3b82f6;
            box-shadow: 0 0 20px rgba(59, 130, 246, 0.4);
        }

        .video-feed {
            width: 100%;
            height: 100%;
            object-fit: cover;
            max-height: 100%;
        }

        .participant-name {
            position: absolute;
            bottom: 0.5rem;
            left: 0.5rem;
            background: rgba(15, 23, 42, 0.6);
            padding: 0.15rem 0.5rem;
            border-radius: 0.35rem;
            font-size: 0.75rem;
            font-weight: 600;
        }

        .control-btn {
            width: 2.25rem;
            height: 2.25rem;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.2s;
            background: #334155;
        }

        .control-btn:hover {
            transform: scale(1.1);
        }

        .control-btn.active {
            background: #3b82f6;
        }

        .control-btn.danger {
            background: #ef4444;
        }

        [x-cloak] {
            display: none !important;
        }
    </style>
</head>

<body class="antialiased">
    @yield('content')
    @stack('scripts')
</body>

</html>