<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Admin Dashboard') - Shift Matrix</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @php
        $globalSettings = \App\Models\Setting::whereIn('key', ['font_size', 'font_family', 'font_weight'])->pluck('value', 'key');
        $fontFamily = $globalSettings['font_family'] ?? 'Inter';
        $fontSize = $globalSettings['font_size'] ?? '32px';
        $fontWeight = $globalSettings['font_weight'] ?? '700';
    @endphp
    <link
        href="https://fonts.googleapis.com/css2?family={{ str_replace(' ', '+', $fontFamily) }}:wght@{{ $fontWeight }}&display=swap"
        rel="stylesheet">
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }

        h1,
        h2,
        h3,
        h4,
        h5,
        h6 {
            font-family: '{{ $fontFamily }}', sans-serif !important;
            font-weight:
                {{ $fontWeight }}
                !important;
        }

        h1 {
            font-size:
                {{ $fontSize }}
                !important;
        }

        h2 {
            font-size: calc({{ $fontSize }} * 0.8) !important;
        }

        h3 {
            font-size: calc({{ $fontSize }} * 0.7) !important;
        }

        h4 {
            font-size: calc({{ $fontSize }} * 0.6) !important;
        }

        h5 {
            font-size: calc({{ $fontSize }} * 0.5) !important;
        }

        h6 {
            font-size: calc({{ $fontSize }} * 0.45) !important;
        }

        .sidebar-collapsed {
            width: 4.5rem !important;
        }

        .sidebar-collapsed span,
        .sidebar-collapsed p {
            display: none;
        }

        .sidebar-collapsed .px-6 {
            padding-left: 1.25rem;
            padding-right: 1.25rem;
        }

        .sidebar-collapsed .px-4 {
            padding-left: 1rem;
            padding-right: 1rem;
        }

        .sidebar-collapsed h1 span {
            margin-right: 0;
        }

        .custom-scrollbar::-webkit-scrollbar {
            width: 0px;
            background: transparent;
        }

        .sidebar-link {
            border-bottom: 1px solid rgba(255, 255, 255, 0.05);
        }
    </style>
</head>

<body class="bg-gray-50 text-gray-900 antialiased">
    <div class="flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <aside id="sidebar"
            class="w-60 bg-[#1e293b] text-white flex-shrink-0 flex flex-col transition-all duration-300">
            <div class="px-6 py-8 flex-shrink-0 border-b border-slate-800">
                <a href="{{ route('admin.dashboard') }}" class="flex items-center gap-2">
                    <img src="{{ asset('images/logo.png') }}" alt="{{ config('app.name') }}"
                        class="h-20 w-auto brightness-0 invert object-contain scale-125">
                </a>
            </div>
            <div class="flex-1 overflow-y-auto px-4 pb-4 custom-scrollbar">
                <div class="space-y-6 mt-4">
                    <!-- General Section -->
                    <div>
                        <p
                            class="px-4 text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 transition-opacity duration-300">
                            General</p>
                        <nav class="space-y-1">
                            <a href="{{ route('admin.dashboard') }}"
                                class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.dashboard') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6">
                                    </path>
                                </svg>
                                <span class="transition-opacity duration-300">Home</span>
                            </a>
                        </nav>
                    </div>

                    <!-- Apps Section -->
                    <div>
                        <p
                            class="px-4 text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 transition-opacity duration-300">
                            Apps</p>
                        <nav class="space-y-1 text-sm">
                            @can('view companies')
                                <a href="{{ route('admin.companies.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.companies.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4">
                                        </path>
                                    </svg>
                                    <span class="transition-opacity duration-300">Companies</span>
                                </a>
                            @endcan

                            @can('view users')
                                <a href="{{ route('admin.users.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.users.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z">
                                        </path>
                                    </svg>
                                    <span class="transition-opacity duration-300">Users</span>
                                </a>
                            @endcan

                            @can('view employees')
                                <a href="{{ route('admin.employees.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.employees.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                                    </svg>
                                    <span class="transition-opacity duration-300">All Employees</span>
                                </a>
                            @endcan

                            @can('view sites')
                                <a href="{{ route('admin.sites.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.sites.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                    </svg>
                                    <span class="transition-opacity duration-300">All Sites</span>
                                </a>
                            @endcan

                            @can('view routes')
                                <a href="{{ route('admin.routes.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.routes.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7" />
                                    </svg>
                                    <span class="transition-opacity duration-300">All Routes</span>
                                </a>
                            @endcan



                        </nav>
                    </div>

                    <!-- Masters Section -->
                    <div>
                        <p
                            class="px-4 text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 transition-opacity duration-300">
                            Masters</p>
                        <nav class="space-y-1 text-sm">
                            @can('view time zones')
                                <a href="{{ route('admin.time-zones.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.time-zones.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    <span class="transition-opacity duration-300">Time Zones</span>
                                </a>
                            @endcan

                            @can('view zones')
                                <a href="{{ route('admin.zones.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.zones.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                                        </path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    </svg>
                                    <span class="transition-opacity duration-300">Zones</span>
                                </a>
                            @endcan

                            @can('view countries')
                                <a href="{{ route('admin.countries.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.countries.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2h1a2 2 0 002-2v-1a2 2 0 012-2h2.945M18 9V7a2 2 0 00-2-2h-1a2 2 0 00-2 2v1m-6 9v-3m0 0v-1a2 2 0 012-2h1a2 2 0 012 2v1m-6 3h6m-3 0a2 2 0 100-4 2 2 0 000 4z">
                                        </path>
                                    </svg>
                                    <span class="transition-opacity duration-300">Countries</span>
                                </a>
                            @endcan

                            @can('view states')
                                <a href="{{ route('admin.states.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.states.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                                        </path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    </svg>
                                    <span class="transition-opacity duration-300">States</span>
                                </a>
                            @endcan
                            @can('view departments')
                                <a href="{{ route('admin.departments.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.departments.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4">
                                        </path>
                                    </svg>
                                    <span class="transition-opacity duration-300">Departments</span>
                                </a>
                            @endcan
                            @can('view positions')
                                <a href="{{ route('admin.positions.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.positions.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                                        </path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    </svg>
                                    <span class="transition-opacity duration-300">Duty Positions</span>
                                </a>
                            @endcan

                            @can('view job roles')
                                <a href="{{ route('admin.job-roles.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.job-roles.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745V20a2 2 0 002 2h14a2 2 0 002-2v-6.745zM3.187 9.263l8.813 4.414 8.813-4.414A1.998 1.998 0 0019 8H5a1.998 1.998 0 00-1.813 1.263z">
                                        </path>
                                    </svg>
                                    <span class="transition-opacity duration-300">Job Roles</span>
                                </a>
                            @endcan
                            @can('view wage types')
                                <a href="{{ route('admin.wage-types.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.wage-types.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z">
                                        </path>
                                    </svg>
                                    <span class="transition-opacity duration-300">Wage Types</span>
                                </a>
                            @endcan

                            <a href="{{ route('admin.uniforms.index') }}"
                                class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.uniforms.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z" />
                                </svg>
                                <span class="transition-opacity duration-300">Uniforms</span>
                            </a>

                            @can('view stat holidays')
                                <a href="{{ route('admin.stat-holidays.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.stat-holidays.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z">
                                        </path>
                                    </svg>
                                    <span class="transition-opacity duration-300">Stat Holidays</span>
                                </a>
                            @endcan
                            @can('view skills')
                                <a href="{{ route('admin.skills.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.skills.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138z">
                                        </path>
                                    </svg>
                                    <span class="transition-opacity duration-300">Skills & Attributes</span>
                                </a>
                            @endcan

                            <a href="{{ route('admin.incident-categories.index') }}"
                                class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.incident-categories.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z">
                                    </path>
                                </svg>
                                <span class="transition-opacity duration-300">Incident Categories</span>
                            </a>

                            <a href="{{ route('admin.request-types.index') }}"
                                class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.request-types.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01">
                                    </path>
                                </svg>
                                <span class="transition-opacity duration-300">Request Types</span>
                            </a>
                        </nav>
                    </div>

                    <!-- Roles & Permissions -->
                    <div>
                        <p
                            class="px-4 text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 transition-opacity duration-300">
                            Access Control</p>
                        <nav class="space-y-1 text-sm">
                            @can('manage roles')
                                <a href="{{ route('admin.roles.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.roles.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z">
                                        </path>
                                    </svg>
                                    <span class="transition-opacity duration-300">Roles</span>
                                </a>
                            @endcan

                            @can('manage permissions')
                                <a href="{{ route('admin.permissions.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.permissions.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z">
                                        </path>
                                    </svg>
                                    <span class="transition-opacity duration-300">Permissions</span>
                                </a>
                            @endcan
                        </nav>
                    </div>

                    <!-- Reports Section -->
                    <div>
                        <p
                            class="px-4 text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 transition-opacity duration-300">
                            Reports</p>
                        <nav class="space-y-1 text-sm">
                            <a href="{{ route('admin.reports.operational.index') }}"
                                class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.reports.operational.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                    </path>
                                </svg>
                                <span class="transition-opacity duration-300">Operational Reports</span>
                            </a>
                            <a href="{{ route('admin.reports.patroller.index') }}"
                                class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.reports.patroller.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                    </path>
                                </svg>
                                <span class="transition-opacity duration-300">Patroller Reports</span>
                            </a>
                        </nav>
                    </div>

                    <!-- Communication Section -->
                    <div>
                        <p
                            class="px-4 text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 transition-opacity duration-300">
                            Communication</p>
                        <nav class="space-y-1 text-sm">

                            @can('view email signatures')
                                <a href="{{ route('admin.email-signatures.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.email-signatures.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z" />
                                    </svg>
                                    <span class="transition-opacity duration-300">Email Signatures</span>
                                </a>
                            @endcan

                            @can('view email templates')
                                <a href="{{ route('admin.email-templates.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.email-templates.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                    </svg>
                                    <span class="transition-opacity duration-300">Email Templates</span>
                                </a>
                            @endcan
                        </nav>
                    </div>

                    <!-- Settings Section -->
                    <div>
                        <p
                            class="px-4 text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 transition-opacity duration-300">
                            System</p>
                        <nav class="space-y-1 text-sm">
                            @can('view system logs')
                                <a href="{{ route('admin.logs.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.logs.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z">
                                        </path>
                                    </svg>
                                    <span class="transition-opacity duration-300">System Logs</span>
                                </a>
                            @endcan

                            @can('manage settings')
                                <a href="{{ route('admin.settings.appearance') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.settings.appearance') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                        </path>
                                    </svg>
                                    <span class="transition-opacity duration-300">Appearance</span>
                                </a>
                            @endcan

                            @can('manage css settings')
                                <a href="{{ route('admin.settings.css') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.settings.css') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M7 21a4 4 0 01-4-4V5a2 2 0 012-2h4a2 2 0 012 2v12a4 4 0 01-4 4zm0 0h12a2 2 0 002-2v-4a2 2 0 00-2-2h-2.343M11 7.343l1.657-1.657a2 2 0 012.828 0l2.829 2.829a2 2 0 010 2.828l-8.486 8.485M7 17h.01">
                                        </path>
                                    </svg>
                                    <span class="transition-opacity duration-300">Typography</span>
                                </a>
                            @endcan

                            @can('manage integrations')
                                <a href="{{ route('admin.settings.integrations') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.settings.integrations') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M11 4a2 2 0 114 0v1a1 1 0 001 1h3a1 1 0 011 1v3a1 1 0 01-1 1h-1a2 2 0 100 4h1a1 1 0 011 1v3a1 1 0 01-1 1h-3a1 1 0 01-1-1v-1a2 2 0 10-4 0v1a1 1 0 01-1 1H7a1 1 0 01-1-1v-3a1 1 0 011-1h1a2 2 0 100-4H7a1 1 0 01-1-1V7a1 1 0 011-1h3a1 1 0 001-1V4z" />
                                    </svg>
                                    <span class="transition-opacity duration-300">Integrations</span>
                                </a>
                            @endcan

                            @can('manage operational rules')
                                <a href="{{ route('admin.settings.operational') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.settings.operational') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    <span class="transition-opacity duration-300">Operational Rules</span>
                                </a>
                            @endcan

                            @can('manage id settings')
                                <a href="{{ route('admin.id-settings.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.id-settings.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M10 20l4-16m4 4l4 4-4 4M6 16l-4-4 4-4" />
                                    </svg>
                                    <span class="transition-opacity duration-300">ID Settings</span>
                                </a>
                            @endcan

                            @can('manage security settings')
                                <a href="{{ route('admin.settings.security') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.settings.security') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                                        </path>
                                    </svg>
                                    <span class="transition-opacity duration-300">Security</span>
                                </a>
                            @endcan

                            @can('view activity logs')
                                <a href="{{ route('admin.activity-logs.index') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.activity-logs.*') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    <span class="transition-opacity duration-300">Activity Logs</span>
                                </a>
                            @endcan

                            <a href="{{ route('admin.settings.password') }}"
                                class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.settings.password') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z">
                                    </path>
                                </svg>
                                <span class="transition-opacity duration-300">Change Password</span>
                            </a>

                            @can('manage settings')
                                <a href="{{ route('admin.settings.system') }}"
                                    class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg {{ request()->routeIs('admin.settings.system') ? 'bg-blue-600/10 text-blue-400 font-medium' : 'text-slate-400 hover:bg-slate-800 hover:text-white transition-all' }}">
                                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z">
                                        </path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    </svg>
                                    <span class="transition-opacity duration-300">System Maintenance</span>
                                </a>
                            @endcan
                        </nav>
                    </div>
                </div>
            </div>
            <div class="p-4 border-t border-slate-800">
                <form action="{{ route('admin.logout') }}" method="POST">
                    @csrf
                    <button type="submit"
                        class="flex items-center gap-3 px-4 py-3 w-full rounded-lg text-slate-400 hover:bg-red-500/10 hover:text-red-400 transition-all font-medium truncate">
                        <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1">
                            </path>
                        </svg>
                        <span class="transition-opacity duration-300">Logout</span>
                    </button>
                </form>
            </div>
        </aside>

        <!-- Main Content -->
        <main class="flex-1 flex flex-col overflow-y-auto bg-gray-50">
            <header
                class="h-16 bg-white border-b border-gray-100 flex items-center justify-between px-8 flex-shrink-0 transition-all duration-300">
                <div class="flex items-center gap-6">
                    <button onclick="toggleSidebar()"
                        class="p-2 text-gray-400 hover:text-blue-600 hover:bg-blue-50 rounded-xl transition-all">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4 6h16M4 12h16M4 18h16"></path>
                        </svg>
                    </button>
                    <div class="text-sm font-medium text-gray-500">
                        Admin / <span class="text-gray-900">@yield('page_title', 'Home')</span>
                    </div>
                </div>
                <div class="flex items-center gap-4">
                    <div class="text-right hidden sm:block">
                        <div class="text-xs font-bold text-gray-900 leading-tight">
                            {{ Auth::user()->name ?? 'Administrator' }}
                        </div>
                        <div class="text-[10px] text-gray-400 font-bold uppercase tracking-wider">
                            {{ Auth::user()->getRoleNames()->first() ?? 'Admin' }}
                        </div>
                    </div>
                    <div
                        class="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center text-blue-600 font-black ring-4 ring-blue-50">
                        {{ strtoupper(substr(Auth::user()->name ?? 'A', 0, 1)) }}
                    </div>
                </div>
            </header>
            <div class="p-8">
                @yield('content')
            </div>
        </main>
    </div>

    <!-- Reusable Deletion Modal -->
    <div id="deleteModal" class="fixed inset-0 z-50 hidden">
        <!-- Backdrop -->
        <div class="absolute inset-0 bg-slate-900/40 backdrop-blur-sm"></div>

        <!-- Modal Content -->
        <div class="absolute inset-0 flex items-center justify-center p-6">
            <div class="bg-white rounded-2xl shadow-2xl w-full max-w-md transform transition-all scale-95 opacity-0 duration-200"
                id="deleteModalContent">
                <div class="p-8">
                    <div
                        class="w-14 h-14 bg-red-50 rounded-2xl flex items-center justify-center text-red-600 mb-6 mx-auto">
                        <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                            </path>
                        </svg>
                    </div>

                    <h3 class="text-xl font-bold text-gray-900 text-center mb-2">Confirm Deletion</h3>
                    <p class="text-gray-500 text-center text-sm mb-8" id="deleteModalMessage">Are you sure you want to
                        delete this record? This action cannot be undone.</p>

                    <div class="flex items-center gap-3">
                        <button type="button" onclick="closeDeleteModal()"
                            class="flex-1 px-6 py-3 rounded-xl border border-gray-200 text-gray-700 font-bold hover:bg-gray-50 transition-all">
                            Cancel
                        </button>
                        <form id="deleteModalForm" method="POST" class="flex-1">
                            @csrf
                            @method('DELETE')
                            <button type="submit"
                                class="w-full px-6 py-3 rounded-xl bg-red-600 text-white font-bold hover:bg-red-700 transition-all shadow-lg shadow-red-200">
                                Delete Record
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            const isCollapsed = sidebar.classList.contains('sidebar-collapsed');

            if (isCollapsed) {
                sidebar.classList.remove('sidebar-collapsed');
                localStorage.setItem('sidebar-collapsed', 'false');
            } else {
                sidebar.classList.add('sidebar-collapsed');
                localStorage.setItem('sidebar-collapsed', 'true');
            }
        }

        // Restore sidebar state
        if (localStorage.getItem('sidebar-collapsed') === 'true') {
            document.getElementById('sidebar').classList.add('sidebar-collapsed');
        }

        function openDeleteModal(actionUrl, itemName) {
            const modal = document.getElementById('deleteModal');
            const content = document.getElementById('deleteModalContent');
            const form = document.getElementById('deleteModalForm');
            const message = document.getElementById('deleteModalMessage');

            form.action = actionUrl;
            message.innerHTML = `Are you sure you want to delete <strong>"${itemName}"</strong>? This action cannot be undone.`;

            modal.classList.remove('hidden');
            setTimeout(() => {
                content.classList.remove('scale-95', 'opacity-0');
                content.classList.add('scale-100', 'opacity-100');
            }, 10);
        }

        function closeDeleteModal() {
            const modal = document.getElementById('deleteModal');
            const content = document.getElementById('deleteModalContent');

            content.classList.remove('scale-100', 'opacity-100');
            content.classList.add('scale-95', 'opacity-0');

            setTimeout(() => {
                modal.classList.add('hidden');
            }, 200);
        }

        // Close modal on escape key
        window.addEventListener('keydown', (e) => {
            if (e.key === 'Escape') closeDeleteModal();
        });

        async function toggleStatus(url, button) {
            const circle = button.querySelector('span');
            const isActive = button.getAttribute('aria-checked') === 'true';

            try {
                // Optimistic UI update
                button.setAttribute('aria-checked', !isActive);
                if (!isActive) {
                    button.classList.remove('bg-gray-200');
                    button.classList.add('bg-blue-600');
                    circle.classList.remove('translate-x-0');
                    circle.classList.add('translate-x-5');
                } else {
                    button.classList.remove('bg-blue-600');
                    button.classList.add('bg-gray-200');
                    circle.classList.remove('translate-x-5');
                    circle.classList.add('translate-x-0');
                }

                const response = await fetch(url, {
                    method: 'PATCH',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Content-Type': 'application/json',
                        'Accept': 'application/json'
                    }
                });

                if (!response.ok) throw new Error('Network response was not ok');

            } catch (error) {
                console.error('Error toggling status:', error);
                // Revert UI on error
                button.setAttribute('aria-checked', isActive);
                if (isActive) {
                    button.classList.remove('bg-gray-200');
                    button.classList.add('bg-blue-600');
                    circle.classList.remove('translate-x-0');
                    circle.classList.add('translate-x-5');
                } else {
                    button.classList.remove('bg-blue-600');
                    button.classList.add('bg-gray-200');
                    circle.classList.remove('translate-x-5');
                    circle.classList.add('translate-x-0');
                }
                alert('Failed to update status. Please try again.');
            }
        }
    </script>
    @stack('scripts')
</body>

</html>