@extends('layouts.user')

@section('title', 'Job Mission Notes')

@section('content')
    <div class="space-y-6">
        <!-- Header -->
        <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
            <div>
                <h1 class="text-2xl font-black text-slate-900 tracking-tight uppercase">Job Mission Notes</h1>
                <p class="text-slate-500 text-xs font-medium">View and export notes submitted by employees during their
                    missions.</p>
            </div>

            <div class="flex items-center gap-3">
                <a href="{{ route('job-notes.export.pdf', request()->all()) }}"
                    class="flex items-center gap-2 px-4 py-2 bg-white border border-slate-200 text-slate-700 hover:bg-slate-50 rounded-lg text-xs font-bold uppercase tracking-wider transition-all shadow-sm">
                    <svg class="w-4 h-4 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z">
                        </path>
                    </svg>
                    Export PDF
                </a>
                <a href="{{ route('job-notes.export.excel', request()->all()) }}"
                    class="flex items-center gap-2 px-4 py-2 bg-white border border-slate-200 text-slate-700 hover:bg-slate-50 rounded-lg text-xs font-bold uppercase tracking-wider transition-all shadow-sm">
                    <svg class="w-4 h-4 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                        </path>
                    </svg>
                    Export Excel
                </a>
            </div>
        </div>

        <!-- Filters -->
        <div class="bg-white rounded-xl shadow-sm border border-slate-200 p-6">
            <form action="{{ route('job-notes.index') }}" method="GET"
                class="grid grid-cols-1 md:grid-cols-4 gap-4 items-end">
                <div>
                    <label class="block text-[10px] font-bold text-slate-500 uppercase tracking-widest mb-1.5 ml-1">Employee
                        Name</label>
                    <input type="text" name="employee_name" value="{{ request('employee_name') }}"
                        placeholder="Search name..."
                        class="w-full bg-slate-50 border-slate-200 rounded-lg text-xs focus:ring-blue-500 focus:border-blue-500 p-2.5">
                </div>

                <div>
                    <label class="block text-[10px] font-bold text-slate-500 uppercase tracking-widest mb-1.5 ml-1">Duty
                        Number</label>
                    <input type="text" name="duty_number" value="{{ request('duty_number') }}"
                        placeholder="Search duty #..."
                        class="w-full bg-slate-50 border-slate-200 rounded-lg text-xs focus:ring-blue-500 focus:border-blue-500 p-2.5">
                </div>

                <div>
                    <label class="block text-[10px] font-bold text-slate-500 uppercase tracking-widest mb-1.5 ml-1">Site /
                        Route Name</label>
                    <input type="text" name="site_name" value="{{ request('site_name') }}" placeholder="Search location..."
                        class="w-full bg-slate-50 border-slate-200 rounded-lg text-xs focus:ring-blue-500 focus:border-blue-500 p-2.5">
                </div>

                <div class="flex gap-2">
                    <button type="submit"
                        class="flex-1 bg-slate-900 text-white hover:bg-black px-4 py-2.5 rounded-lg text-xs font-bold uppercase tracking-wider transition-all shadow-sm">
                        Filter
                    </button>
                    @if(request()->anyFilled(['employee_name', 'duty_number', 'site_name']))
                        <a href="{{ route('job-notes.index') }}"
                            class="flex items-center justify-center bg-slate-100 text-slate-600 hover:bg-slate-200 px-4 py-2.5 rounded-lg text-xs font-bold uppercase tracking-wider transition-all">
                            Reset
                        </a>
                    @endif
                </div>
            </form>
        </div>

        <!-- Table -->
        <div class="bg-white rounded-xl shadow-sm border border-slate-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-slate-50 border-b border-slate-200">
                            <th class="px-6 py-4 text-[11px] font-bold text-slate-500 uppercase tracking-widest">Submitted
                                Date</th>
                            <th class="px-6 py-4 text-[11px] font-bold text-slate-500 uppercase tracking-widest">Employee
                            </th>
                            <th class="px-6 py-4 text-[11px] font-bold text-slate-500 uppercase tracking-widest">Mission
                                Note</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-100">
                        @php $lastDuty = null; @endphp
                        @forelse($notes as $note)
                            @php
                                $currentDuty = $note->job_type . '_' . $note->job_id;
                                $job = $note->job_details;

                                $siteRoute = 'N/A';
                                $dutyNumber = 'N/A';
                                $link = '#';

                                if ($note->job_type === 'guard') {
                                    $siteRoute = $job && $job->site ? $job->site->name : 'N/A';
                                    $dutyNumber = $job ? $job->duty_number : 'N/A';
                                    $link = $job ? route('schedules.show', $job->id) : '#';
                                } else {
                                    $siteRoute = $job && $job->route ? $job->route->name : 'N/A';
                                    $dutyNumber = $job ? $job->duty_number : 'N/A';
                                    $link = $job ? route('patroller-schedules.show', $job->id) : '#';
                                }
                            @endphp

                            @if($lastDuty !== $currentDuty)
                                <tr class="bg-slate-50/80 border-y border-slate-200">
                                    <td colspan="3" class="px-6 py-3">
                                        <div class="flex items-center justify-between">
                                            <div class="flex items-center gap-4">
                                                <div
                                                    class="inline-flex items-center px-2 py-0.5 rounded bg-blue-600 text-[10px] font-black text-white uppercase tracking-wider shadow-sm">
                                                    {{ $note->job_type }}
                                                </div>
                                                <div class="flex flex-col">
                                                    <span class="text-[10px] font-bold text-slate-400 uppercase tracking-tight">Duty
                                                        Location</span>
                                                    <span
                                                        class="text-xs font-black text-slate-900 tracking-tight">{{ $siteRoute }}</span>
                                                </div>
                                                <div class="w-px h-8 bg-slate-200 mx-2"></div>
                                                <div class="flex flex-col">
                                                    <span class="text-[10px] font-bold text-slate-400 uppercase tracking-tight">Duty
                                                        Number</span>
                                                    <a href="{{ $link }}"
                                                        class="text-xs font-black text-blue-600 hover:underline">#{{ $dutyNumber }}</a>
                                                </div>
                                            </div>
                                            <div class="text-[10px] font-bold text-slate-400 uppercase tracking-wider">
                                                Grouped by Duty ID
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @php $lastDuty = $currentDuty; @endphp
                            @endif

                            <tr class="hover:bg-slate-50/30 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap align-top">
                                    <div class="text-xs font-semibold text-slate-900">{{ $note->created_at->format('M d, Y') }}
                                    </div>
                                    <div class="text-[10px] font-bold text-slate-400 uppercase tracking-tighter">
                                        {{ $note->created_at->format('H:i A') }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap align-top">
                                    <div class="flex items-center gap-3">
                                        <div
                                            class="w-8 h-8 rounded-lg bg-slate-100 flex items-center justify-center text-slate-600 font-bold text-[10px] border border-slate-200">
                                            {{ str_replace('Employee ', '', strtoupper(substr($note->employee->first_name ?? 'E', 0, 1))) }}
                                        </div>
                                        <div>
                                            <div class="text-xs font-bold text-slate-900">{{ $note->employee->first_name }}
                                                {{ $note->employee->last_name }}</div>
                                            <div class="text-[10px] text-slate-400 font-medium tracking-tight">
                                                {{ $note->employee->employee_id }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div
                                        class="relative pl-6 before:content-[''] before:absolute before:left-0 before:top-2 before:bottom-2 before:w-1 before:bg-blue-100 before:rounded-full">
                                        <p class="text-xs text-slate-600 italic leading-relaxed">
                                            "{{ $note->note }}"
                                        </p>
                                        @if($note->image)
                                            <div class="mt-3">
                                                <a href="{{ asset('storage/' . $note->image) }}" target="_blank"
                                                    class="inline-block group">
                                                    <div
                                                        class="relative w-24 h-24 rounded-lg overflow-hidden border border-slate-200 shadow-sm transition-all group-hover:shadow-md">
                                                        <img src="{{ asset('storage/' . $note->image) }}"
                                                            class="w-full h-full object-cover transition-transform duration-300 group-hover:scale-110"
                                                            alt="Note evidence">
                                                        <div
                                                            class="absolute inset-0 bg-black/10 group-hover:bg-transparent transition-colors">
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="px-6 py-12 text-center text-slate-500 font-medium italic text-xs">
                                    No job mission notes found matching your criteria.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            @if($notes->hasPages())
                <div class="px-6 py-4 border-t border-slate-100 bg-slate-50/30">
                    {{ $notes->links() }}
                </div>
            @endif
        </div>
    </div>
@endsection