@extends('layouts.user')

@section('title', 'Employee Details')

@section('content')
    <div class="max-w-7xl mx-auto"
        x-data="{ activeTab: new URLSearchParams(window.location.search).get('tab') || 'overview' }">

        <!-- Header Section (Dark Blue) -->
        <div class="bg-[#1e293b] text-white px-8 pt-10 pb-0 rounded-t-3xl mb-0 shadow-xl relative overflow-hidden">
            <!-- Subtle background decorative element -->
            <div class="absolute -right-20 -top-20 w-64 h-64 bg-blue-500/10 rounded-full blur-3xl"></div>

            <div class="flex flex-col md:flex-row md:items-center gap-6 mb-8 relative z-10">
                <div class="relative group">
                    <div
                        class="w-20 h-20 rounded-2xl bg-gradient-to-br from-blue-400 to-blue-600 flex items-center justify-center text-3xl font-bold border-4 border-slate-800 shadow-2xl overflow-hidden shadow-blue-500/20">
                        @if($employee->profile_picture)
                            <img src="{{ asset('storage/' . $employee->profile_picture) }}" class="w-full h-full object-cover">
                        @else
                            <span
                                class="text-white">{{ substr($employee->first_name, 0, 1) }}{{ substr($employee->last_name, 0, 1) }}</span>
                        @endif
                    </div>
                </div>
                <div>
                    <div class="flex items-center gap-3">
                        <h1 class="text-3xl font-extrabold tracking-tight">{{ $employee->first_name }}
                            {{ $employee->last_name }}
                        </h1>
                        <span
                            class="px-3 py-1 bg-blue-500/20 text-blue-300 text-[10px] font-bold uppercase rounded-full border border-blue-500/30">Employee
                            Profile</span>
                    </div>
                    <div class="flex flex-wrap items-center gap-4 mt-2 text-sm text-slate-400 font-medium">
                        <span class="flex items-center gap-1.5">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                                </path>
                            </svg>
                            {{ $employee->phone_number }}
                        </span>
                        <span class="flex items-center gap-1.5">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                            ID: {{ $employee->employee_id }}
                        </span>
                        <span class="flex items-center gap-1.5">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                                </path>
                            </svg>
                            {{ $employee->jobRole->name ?? 'No Role' }}
                        </span>
                    </div>
                </div>

                <div class="md:ml-auto flex items-center gap-2">
                    <a href="{{ route('employees.edit', $employee->id) }}"
                        class="px-5 py-2.5 bg-blue-600 text-white text-xs font-bold rounded-xl shadow-lg shadow-blue-500/30 hover:bg-blue-700 transition-all uppercase tracking-wider flex items-center gap-2">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                            </path>
                        </svg>
                        Edit Profile
                    </a>
                </div>
            </div>

            <!-- Primary Tabs -->
            <div class="flex items-center gap-8 text-sm font-bold relative z-10">
                <a href="#" @click.prevent="activeTab = 'overview'"
                    :class="activeTab === 'overview' ? 'border-white text-white' : 'border-transparent text-slate-400 hover:text-white'"
                    class="pb-4 border-b-4 transition-all">Overview</a>

                <a href="#" @click.prevent="activeTab = 'documents'"
                    :class="activeTab === 'documents' ? 'border-white text-white' : 'border-transparent text-slate-400 hover:text-white'"
                    class="pb-4 border-b-4 transition-all">Documents</a>

                <a href="{{ route('employees.schedules', $employee->id) }}"
                    class="pb-4 border-b-4 border-transparent text-slate-400 hover:text-white transition-all flex items-center gap-2">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                    </svg>
                    Schedules
                </a>

                <a href="{{ route('employees.id_card', $employee->id) }}" target="_blank"
                    class="pb-4 border-b-4 border-transparent text-slate-400 hover:text-white transition-all flex items-center gap-2">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
                    </svg>
                    View ID Card
                </a>

                <a href="#" @click.prevent="activeTab = 'uniforms'"
                    :class="activeTab === 'uniforms' ? 'border-white text-white' : 'border-transparent text-slate-400 hover:text-white'"
                    class="pb-4 border-b-4 transition-all">Uniforms</a>

                <a href="#" @click.prevent="activeTab = 'banned'"
                    :class="activeTab === 'banned' ? 'border-white text-white' : 'border-transparent text-slate-400 hover:text-white'"
                    class="pb-4 border-b-4 transition-all">Banned Sites</a>

                <a href="#" @click.prevent="activeTab = 'availability'"
                    :class="activeTab === 'availability' ? 'border-white text-white' : 'border-transparent text-slate-400 hover:text-white'"
                    class="pb-4 border-b-4 transition-all">Availability</a>

                <a href="#" @click.prevent="activeTab = 'devices'"
                    :class="activeTab === 'devices' ? 'border-white text-white' : 'border-transparent text-slate-400 hover:text-white'"
                    class="pb-4 border-b-4 transition-all">Devices</a>
            </div>
        </div>

        <!-- Actions Bar (White) -->
        <div
            class="bg-white border-b border-gray-100 px-8 py-3 flex items-center gap-4 text-xs font-bold text-slate-500 shadow-sm mb-0">
            <div class="flex items-center gap-6">
                <span class="flex items-center gap-2">
                    <span class="w-2 h-2 rounded-full bg-green-500 shadow-[0_0_8px_rgba(34,197,94,0.5)]"></span>
                    Active Status
                </span>
                <span class="h-4 w-[1px] bg-gray-100"></span>
                <span class="uppercase tracking-widest text-[10px]">Employee ID: {{ $employee->employee_id }}</span>
            </div>

            <button class="flex items-center gap-2 hover:text-blue-600 transition-colors ml-auto uppercase tracking-wider">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z">
                    </path>
                </svg>
                Manage Profile
            </button>
        </div>

        <!-- Main Content -->
        <div class="flex-1 p-6">
            <div x-show="activeTab === 'overview'" class="space-y-6" x-cloak>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">

                    <!-- General Info (Full Width) -->
                    <div class="md:col-span-2 bg-white rounded-3xl border border-gray-100 shadow-xl p-8">
                        <div class="flex flex-col md:flex-row gap-8 items-start mb-8 border-b border-gray-50 pb-8">
                            <!-- Avatar -->
                            <div
                                class="w-28 h-28 rounded-3xl bg-gradient-to-br from-blue-50 to-blue-100 border-2 border-white shadow-lg flex items-center justify-center text-blue-600 text-4xl font-extrabold shadow-blue-100 flex-shrink-0 overflow-hidden">
                                @if($employee->profile_picture)
                                    <img src="{{ asset('storage/' . $employee->profile_picture) }}"
                                        class="w-full h-full object-cover">
                                @else
                                    {{ substr($employee->first_name, 0, 1) }}{{ substr($employee->last_name, 0, 1) }}
                                @endif
                            </div>
                            <!-- Basic Details & Contact -->
                            <div class="flex-1">
                                <h2 class="text-2xl font-black text-slate-900 tracking-tight">
                                    {{ $employee->first_name }} {{ $employee->last_name }}
                                </h2>
                                <p class="text-sm font-bold text-blue-600 uppercase tracking-widest mt-1">
                                    {{ $employee->jobRole->name ?? 'No Role Assigned' }}
                                </p>

                                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 mt-6">
                                    <div
                                        class="flex items-center gap-3 p-3 bg-slate-50 rounded-2xl border border-slate-100 shadow-sm">
                                        <div
                                            class="w-8 h-8 rounded-xl bg-white flex items-center justify-center text-slate-400 shadow-sm">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                                                </path>
                                            </svg>
                                        </div>
                                        <span class="text-sm font-bold text-slate-600">{{ $employee->email }}</span>
                                    </div>
                                    <div
                                        class="flex items-center gap-3 p-3 bg-slate-50 rounded-2xl border border-slate-100 shadow-sm">
                                        <div
                                            class="w-8 h-8 rounded-xl bg-white flex items-center justify-center text-slate-400 shadow-sm">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                                                </path>
                                            </svg>
                                        </div>
                                        <span
                                            class="text-sm font-bold text-slate-600">{{ $employee->phone_number }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <h3 class="text-[10px] font-black text-slate-400 uppercase tracking-[.2em] mb-6">General
                            Information</h3>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-8">
                            <div><span
                                    class="block text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">BirthDate</span>
                                <span class="text-sm font-bold text-slate-900">{{ $employee->dob }}</span>
                            </div>
                            <div><span
                                    class="block text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Gender</span>
                                <span class="text-sm font-bold text-slate-900">{{ ucfirst($employee->gender) }}</span>
                            </div>
                            <div><span
                                    class="block text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Status</span>
                                <span
                                    class="text-sm font-bold text-slate-900">{{ ucfirst($employee->marital_status) }}</span>
                            </div>
                            <div><span
                                    class="block text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Department</span>
                                <span
                                    class="text-sm font-bold text-slate-900">{{ $employee->department->name ?? 'N/A' }}</span>
                            </div>
                        </div>
                    </div>

                    <!-- Address Info -->
                    <div class="bg-white rounded border border-gray-200 shadow-sm p-6">
                        <h3
                            class="text-sm font-bold text-gray-900 uppercase tracking-wider mb-4 border-b border-gray-100 pb-2">
                            Address Information</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="text-sm">
                                <span class="block text-gray-500 text-xs font-bold uppercase mb-1">Permanent
                                    Address</span>
                                <span class="text-gray-900">
                                    {{ $employee->permanent_address_line_1 }}<br>
                                    @if($employee->permanent_address_line_2){{ $employee->permanent_address_line_2 }}<br>@endif
                                    {{ $employee->permanent_city }}, {{ $employee->permanentState->name ?? '' }}
                                    {{ $employee->permanent_zip_code }}<br>
                                    {{ $employee->permanentCountry->name ?? '' }}
                                </span>
                            </div>
                            <div class="text-sm">
                                <span class="block text-gray-500 text-xs font-bold uppercase mb-1">Corresponding
                                    Address</span>
                                <span class="text-gray-900">
                                    {{ $employee->corresponding_address_line_1 ?: 'N/A' }}<br>
                                    @if($employee->corresponding_address_line_2){{ $employee->corresponding_address_line_2 }}<br>@endif
                                    @if($employee->corresponding_city)
                                        {{ $employee->corresponding_city }}, {{ $employee->correspondingState->name ?? '' }}
                                        {{ $employee->corresponding_zip_code }}<br>
                                        {{ $employee->correspondingCountry->name ?? '' }}
                                    @endif
                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Licence & Employment Info -->
                    <div class="bg-white rounded border border-gray-200 shadow-sm p-6">
                        <h3
                            class="text-sm font-bold text-gray-900 uppercase tracking-wider mb-4 border-b border-gray-100 pb-2">
                            Licence & Employment</h3>
                        <div class="grid grid-cols-1 gap-4 text-sm">
                            <div><span class="block text-gray-500 text-xs">License Number</span> <span
                                    class="text-gray-900">{{ $employee->license_number }}</span></div>
                            <div><span class="block text-gray-500 text-xs">License Expiry</span> <span
                                    class="text-gray-900">{{ $employee->license_expiry }}</span></div>
                            <div><span class="block text-gray-500 text-xs">Issuing Province</span> <span
                                    class="text-gray-900">{{ $employee->licence_issuing_province ?? 'N/A' }}</span>
                            </div>
                            <div><span class="block text-gray-500 text-xs">Hiring Date</span> <span
                                    class="text-gray-900">{{ $employee->employment_date }}</span></div>
                            <div><span class="block text-gray-500 text-xs">Reporting Manager</span> <span
                                    class="text-gray-900">{{ $employee->reporting_manager ?? 'N/A' }}</span></div>
                            <div><span class="block text-gray-500 text-xs">SIN Number</span> <span
                                    class="text-gray-900">{{ $employee->sin_number ?? 'N/A' }}</span></div>
                        </div>
                    </div>

                    <!-- Experience Details -->
                    <div class="bg-white rounded border border-gray-200 shadow-sm p-6">
                        <h3
                            class="text-sm font-bold text-gray-900 uppercase tracking-wider mb-4 border-b border-gray-100 pb-2">
                            Experience Details</h3>
                        <div class="space-y-4">
                            @forelse($employee->experiences as $experience)
                                <div class="border-b border-gray-50 pb-3 last:border-0 last:pb-0">
                                    <div class="flex justify-between items-start mb-1">
                                        <div>
                                            <span class="block text-sm font-bold text-gray-900">{{ $experience->company_name }}</span>
                                            <span class="text-xs text-gray-500">
                                                {{ $experience->start_date ? \Carbon\Carbon::parse($experience->start_date)->format('M Y') : 'N/A' }}
                                                -
                                                {{ $experience->end_date ? \Carbon\Carbon::parse($experience->end_date)->format('M Y') : 'Present' }}
                                            </span>
                                        </div>
                                        @if($experience->proof_document)
                                            <a href="{{ asset('storage/' . $experience->proof_document) }}" target="_blank"
                                                class="text-[10px] bg-blue-50 text-blue-600 px-2 py-1 rounded hover:bg-blue-100 transition-colors">
                                                View Proof
                                            </a>
                                        @endif
                                    </div>
                                    @if($experience->reason_for_leaving)
                                        <div class="mt-1">
                                            <span class="text-[10px] font-bold text-gray-400 uppercase tracking-wider">Reason
                                                for Leaving:</span>
                                            <p class="text-xs text-slate-600 mt-0.5">{{ $experience->reason_for_leaving }}
                                            </p>
                                        </div>
                                    @endif
                                </div>
                            @empty
                                <div class="text-center py-4 text-gray-400 text-xs italic">
                                    No experience details added.
                                </div>
                            @endforelse
                        </div>
                    </div>

                    <!-- Skills & Attributes -->
                    <div class="bg-white rounded border border-gray-200 shadow-sm p-6 md:col-span-2">
                        <h3
                            class="text-sm font-bold text-gray-900 uppercase tracking-wider mb-4 border-b border-gray-100 pb-2">
                            Skills & Attributes</h3>
                        <div class="flex flex-wrap gap-2">
                            @forelse($employee->skills as $skill)
                                <span
                                    class="px-2 py-1 bg-blue-50 text-blue-700 text-xs font-medium rounded border border-blue-100">
                                    {{ $skill->name }}
                                </span>
                            @empty
                                <span class="text-gray-500 text-sm">No skills or attributes assigned.</span>
                            @endforelse
                        </div>
                    </div>

                </div>
            </div>

            <!-- ... other tabs ... -->

            <!-- Uniforms Tab -->
            <div x-show="activeTab === 'uniforms'" class="space-y-6" x-cloak>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <!-- Assign Uniform Form -->
                    <div class="md:col-span-1">
                        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                            <h3 class="font-bold text-gray-900 mb-4">Assign Uniform</h3>
                            <form action="{{ route('employees.assign-uniform', $employee->id) }}" method="POST"
                                class="space-y-4">
                                @csrf
                                <div>
                                    <label class="block text-xs font-bold text-gray-500 uppercase mb-1">Select Item</label>
                                    <select name="uniform_variant_id" required
                                        class="w-full text-sm border-gray-200 rounded-lg focus:border-blue-500 focus:ring-blue-500">
                                        <option value="">Choose item...</option>
                                        @foreach($availableUniforms as $variant)
                                            <option value="{{ $variant->id }}">
                                                {{ $variant->uniform->name }} - {{ $variant->size }}/{{ $variant->color }}
                                                (Stock: {{ $variant->stock_quantity }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-gray-500 uppercase mb-1">Quantity</label>
                                    <input type="number" name="quantity" value="1" min="1" required
                                        class="w-full text-sm border-gray-200 rounded-lg focus:border-blue-500 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-gray-500 uppercase mb-1">Issued Date</label>
                                    <input type="date" name="issued_at" value="{{ date('Y-m-d') }}" required
                                        class="w-full text-sm border-gray-200 rounded-lg focus:border-blue-500 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-gray-500 uppercase mb-1">Notes</label>
                                    <textarea name="notes" rows="2"
                                        class="w-full text-sm border-gray-200 rounded-lg focus:border-blue-500 focus:ring-blue-500"></textarea>
                                </div>
                                <button type="submit"
                                    class="w-full py-2 bg-blue-600 text-white font-bold rounded-lg hover:bg-blue-700 transition-colors">
                                    Assign Item
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Issued Uniforms List -->
                    <div class="md:col-span-2">
                        <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                            <div class="px-6 py-4 border-b border-gray-100 flex justify-between items-center">
                                <h3 class="font-bold text-gray-900">Issued Uniforms History</h3>
                            </div>
                            <div class="overflow-x-auto">
                                <table class="w-full text-sm text-left">
                                    <thead class="bg-gray-50 text-gray-500 font-bold uppercase text-xs">
                                        <tr>
                                            <th class="px-6 py-3">Item</th>
                                            <th class="px-6 py-3">Variant</th>
                                            <th class="px-6 py-3">Qty</th>
                                            <th class="px-6 py-3">Issued Date</th>
                                            <th class="px-6 py-3">Notes</th>
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y divide-gray-100">
                                        @forelse($employee->issuedUniforms as $issued)
                                            <tr class="hover:bg-gray-50">
                                                <td class="px-6 py-3 font-medium text-gray-900">
                                                    {{ $issued->variant->uniform->name }}</td>
                                                <td class="px-6 py-3 text-gray-600">{{ $issued->variant->size }} /
                                                    {{ $issued->variant->color }}</td>
                                                <td class="px-6 py-3 font-bold text-gray-900">{{ $issued->quantity }}</td>
                                                <td class="px-6 py-3 text-gray-600">{{ $issued->issued_at->format('M d, Y') }}
                                                </td>
                                                <td class="px-6 py-3 text-gray-500 text-xs italic">{{ $issued->notes ?? '-' }}
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="5" class="px-6 py-8 text-center text-gray-400 italic">No uniforms
                                                    issued to this employee yet.</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Documents Tab Content -->
        <div x-show="activeTab === 'documents'"
            class="bg-white rounded border border-gray-200 shadow-sm overflow-hidden p-6" x-cloak>
            <h2 class="text-lg font-bold text-gray-900 mb-4">Employee Documents</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <!-- File Item Template -->
                @if($employee->file_license)
                    <div class="border rounded p-4 flex flex-col justify-between">
                        <div class="mb-2">
                            <span class="text-xs font-bold uppercase text-gray-400 tracking-wider">License File</span>
                            <div class="text-sm font-medium truncate text-gray-700 mt-1">
                                {{ basename($employee->file_license) }}
                            </div>
                        </div>
                        <div class="flex gap-2 mt-2">
                            <a href="{{ asset('storage/' . $employee->file_license) }}" target="_blank"
                                class="text-xs bg-blue-50 text-blue-600 px-3 py-1 rounded hover:bg-blue-100">View</a>
                            <a href="{{ asset('storage/' . $employee->file_license) }}" download
                                class="text-xs bg-gray-50 text-gray-600 px-3 py-1 rounded hover:bg-gray-100">Download</a>
                        </div>
                    </div>
                @endif

                @if($employee->file_contract)
                    <div class="border rounded p-4 flex flex-col justify-between">
                        <div class="mb-2">
                            <span class="text-xs font-bold uppercase text-gray-400 tracking-wider">Employment
                                Contract</span>
                            <div class="text-sm font-medium truncate text-gray-700 mt-1">
                                {{ basename($employee->file_contract) }}
                            </div>
                        </div>
                        <div class="flex gap-2 mt-2">
                            <a href="{{ asset('storage/' . $employee->file_contract) }}" target="_blank"
                                class="text-xs bg-blue-50 text-blue-600 px-3 py-1 rounded hover:bg-blue-100">View</a>
                            <a href="{{ asset('storage/' . $employee->file_contract) }}" download
                                class="text-xs bg-gray-50 text-gray-600 px-3 py-1 rounded hover:bg-gray-100">Download</a>
                        </div>
                    </div>
                @endif

                @if($employee->file_direct_deposit)
                    <div class="border rounded p-4 flex flex-col justify-between">
                        <div class="mb-2">
                            <span class="text-xs font-bold uppercase text-gray-400 tracking-wider">Direct Deposit</span>
                            <div class="text-sm font-medium truncate text-gray-700 mt-1">
                                {{ basename($employee->file_direct_deposit) }}
                            </div>
                        </div>
                        <div class="flex gap-2 mt-2">
                            <a href="{{ asset('storage/' . $employee->file_direct_deposit) }}" target="_blank"
                                class="text-xs bg-blue-50 text-blue-600 px-3 py-1 rounded hover:bg-blue-100">View</a>
                            <a href="{{ asset('storage/' . $employee->file_direct_deposit) }}" download
                                class="text-xs bg-gray-50 text-gray-600 px-3 py-1 rounded hover:bg-gray-100">Download</a>
                        </div>
                    </div>
                @endif

                @if($employee->profile_picture)
                    <div class="border rounded p-4 flex flex-col justify-between">
                        <div class="mb-2">
                            <span class="text-xs font-bold uppercase text-gray-400 tracking-wider">Profile
                                Picture</span>
                            <div class="text-sm font-medium truncate text-gray-700 mt-1">
                                {{ basename($employee->profile_picture) }}
                            </div>
                        </div>
                        <div class="flex gap-2 mt-2">
                            <a href="{{ asset('storage/' . $employee->profile_picture) }}" target="_blank"
                                class="text-xs bg-blue-50 text-blue-600 px-3 py-1 rounded hover:bg-blue-100">View</a>
                            <a href="{{ asset('storage/' . $employee->profile_picture) }}" download
                                class="text-xs bg-gray-50 text-gray-600 px-3 py-1 rounded hover:bg-gray-100">Download</a>
                        </div>
                    </div>
                @endif

                @foreach($employee->identifications as $idFile)
                    <div class="border rounded p-4 flex flex-col justify-between">
                        <div class="mb-2">
                            <span class="text-xs font-bold uppercase text-gray-400 tracking-wider">ID Document</span>
                            <div class="text-sm font-medium truncate text-gray-700 mt-1">
                                {{ basename($idFile->file_path) }}
                            </div>
                        </div>
                        <div class="flex gap-2 mt-2">
                            <a href="{{ asset('storage/' . $idFile->file_path) }}" target="_blank"
                                class="text-xs bg-blue-50 text-blue-600 px-3 py-1 rounded hover:bg-blue-100">View</a>
                            <a href="{{ asset('storage/' . $idFile->file_path) }}" download
                                class="text-xs bg-gray-50 text-gray-600 px-3 py-1 rounded hover:bg-gray-100">Download</a>
                        </div>
                    </div>
                @endforeach
            </div>

            @if(!$employee->license_file_path && !$employee->employment_contract_path && !$employee->direct_deposit_file_path && !$employee->profile_picture_path && $employee->identifications->isEmpty())
                <div class="text-center py-8 text-gray-400 italic">No documents found.</div>
            @endif

        </div>

        <!-- Banned Sites Tab Content -->
        <div x-show="activeTab === 'banned'" class="space-y-6" x-cloak>
            <!-- Add Ban Section -->
            <div class="bg-white rounded-3xl border border-gray-100 shadow-xl p-8" x-data="{ search: '' }">
                <h2 class="text-lg font-black text-slate-900 tracking-tight mb-4 flex items-center gap-2">
                    <svg class="w-5 h-5 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z">
                        </path>
                    </svg>
                    Add New Site Bans
                </h2>
                <form action="{{ route('employees.ban-sites', $employee->id) }}" method="POST">
                    @csrf
                    <div class="mb-4">
                        <label class="block text-xs font-bold text-gray-400 uppercase mb-2">Ban Reason</label>
                        <input type="text" name="reason" placeholder="e.g. Repeated misconduct, Client Request"
                            class="w-full px-4 py-2 bg-gray-50 border border-gray-200 rounded-xl focus:outline-none focus:ring-2 focus:ring-red-500/20 focus:border-red-500 font-bold text-sm">
                    </div>

                    <div class="mb-4">
                        <label class="block text-xs font-bold text-gray-400 uppercase mb-2">Select Sites to Ban</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <svg class="h-4 w-4 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                                </svg>
                            </div>
                            <input type="text" x-model="search" placeholder="Search available sites..."
                                class="w-full pl-10 pr-4 py-2 mb-2 bg-white border border-gray-200 rounded-xl text-sm focus:border-blue-500 focus:ring-1 focus:ring-blue-500 outline-none">
                        </div>

                        <div class="max-h-60 overflow-y-auto border border-gray-100 rounded-xl p-2 bg-gray-50 space-y-1">
                            @php $availableSitesCount = 0; @endphp
                            @foreach($sites as $site)
                                @if(!$employee->bannedSites->contains($site->id))
                                    @php $availableSitesCount++; @endphp
                                    <label
                                        class="flex items-center gap-3 p-2 hover:bg-white rounded-lg cursor-pointer transition-colors group"
                                        x-show="'{{ strtolower($site->name) }}'.includes(search.toLowerCase()) || '{{ strtolower($site->site_id) }}'.includes(search.toLowerCase())">
                                        <input type="checkbox" name="site_ids[]" value="{{ $site->id }}"
                                            class="w-4 h-4 text-red-600 rounded border-gray-300 focus:ring-red-500 cursor-pointer">
                                        <div class="flex-1">
                                            <div class="text-sm font-bold text-gray-700 group-hover:text-gray-900">{{ $site->name }}
                                            </div>
                                            <div class="text-[10px] font-bold text-gray-400 uppercase">{{ $site->site_id }}</div>
                                        </div>
                                    </label>
                                @endif
                            @endforeach

                            @if($availableSitesCount === 0)
                                <div class="text-center py-4 text-gray-400 text-xs italic">
                                    No sites available to ban (Employee may be banned from all sites).
                                </div>
                            @endif

                            <div x-show="search !== ''" class="text-center py-2 text-gray-400 text-xs italic hidden"
                                :class="{ 'block': !$el.parentElement.querySelectorAll('label[style*=\'display: none\']').length === {{ $availableSitesCount }} }">
                                <!-- This is complex to do purely with alpine without a computed property list, keeping simple for now -->
                            </div>
                        </div>
                    </div>

                    <button type="submit"
                        class="px-6 py-2 bg-red-600 text-white font-bold rounded-xl shadow-lg shadow-red-500/30 hover:bg-red-700 transition-all uppercase tracking-wider text-xs">
                        Ban Selected Sites
                    </button>
                </form>
            </div>

            <!-- Active Bans Section -->
            <div class="bg-white rounded-3xl border border-gray-100 shadow-xl p-8">
                <h2 class="text-2xl font-black text-slate-900 tracking-tight mb-6">Active Bans</h2>

                @if($employee->bannedSites->isEmpty())
                    <div class="p-12 text-center bg-gray-50 border-2 border-dashed border-gray-200 rounded-3xl">
                        <div class="text-gray-400 font-medium">This employee is not banned from any sites.</div>
                    </div>
                @else
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        @foreach($employee->bannedSites as $site)
                            <div
                                class="p-6 bg-red-50 rounded-2xl border border-red-100 flex justify-between items-center group relative overflow-hidden">
                                <div class="absolute -right-4 -top-4 w-16 h-16 bg-red-500/10 rounded-full blur-xl"></div>
                                <div class="relative z-10 max-w-[70%]">
                                    <h3 class="font-bold text-red-900 text-lg truncate" title="{{ $site->name }}">{{ $site->name }}
                                    </h3>
                                    <p class="text-[10px] font-bold text-red-400 uppercase tracking-widest">{{ $site->site_id }}</p>
                                    <div class="mt-2 text-xs text-red-700 font-medium bg-red-100/50 p-2 rounded-lg inline-block">
                                        Reason: {{ $site->pivot->reason ?? 'No reason provided' }}
                                    </div>
                                    <p class="text-[10px] text-red-400 mt-1 pl-1">Banned:
                                        {{ \Carbon\Carbon::parse($site->pivot->banned_at)->format('M d, Y') }}</p>
                                </div>

                                <form action="{{ route('sites.unban', ['site' => $site, 'employee' => $employee]) }}" method="POST"
                                    onsubmit="return confirm('Are you sure you want to remove the ban for this employee?');"
                                    class="relative z-10">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit"
                                        class="px-4 py-2 bg-white text-red-600 text-xs font-bold rounded-xl shadow-sm hover:shadow-md hover:bg-red-600 hover:text-white transition-all border border-red-100">
                                        Remove Ban
                                    </button>
                                </form>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Availability Tab Content -->
    <div x-show="activeTab === 'availability'" class="space-y-6" x-cloak>
        <div class="bg-white rounded border border-gray-200 shadow-sm p-6">
            <h2 class="text-lg font-bold text-gray-900 mb-4">Availability Settings</h2>
            <form action="{{ route('employees.update_availability', $employee->id) }}" method="POST">
                @csrf
                <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-7 gap-3 mb-6">
                    @php
                        $days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
                        $unavailable = $employee->unavailable_days ?? [];
                    @endphp
                    @foreach($days as $day)
                        <label
                            class="flex flex-col items-center justify-center gap-2 p-3 border rounded-xl cursor-pointer hover:bg-slate-50 transition-all {{ !in_array($day, $unavailable) ? 'border-blue-200 bg-blue-50/50' : 'border-gray-200' }}">
                            <span
                                class="text-xs font-bold uppercase {{ !in_array($day, $unavailable) ? 'text-blue-700' : 'text-slate-500' }}">{{ substr($day, 0, 3) }}</span>
                            <input type="checkbox" name="available_days[]" value="{{ $day }}"
                                class="w-4 h-4 text-blue-600 rounded focus:ring-blue-500 border-gray-300 transition-all" {{ !in_array($day, $unavailable) ? 'checked' : '' }}>
                        </label>
                    @endforeach
                </div>
                <div class="flex justify-end border-t border-gray-100 pt-4">
                    <button type="submit"
                        class="px-6 py-2 bg-blue-600 text-white text-xs font-bold rounded-xl shadow-lg shadow-blue-500/30 hover:bg-blue-700 transition-all uppercase tracking-wider">
                        Save Availability
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Devices Tab Content -->
    <div x-show="activeTab === 'devices'" class="space-y-6" x-cloak>
        <div class="bg-white rounded border border-gray-200 shadow-sm p-6">
            <h2 class="text-lg font-bold text-gray-900 mb-4">Registered Devices (FCM Tokens)</h2>
            @if($employee->fcmTokens->isEmpty())
                <div class="text-center py-8 text-gray-400 italic">No devices registered.</div>
            @else
                <div class="overflow-x-auto">
                    <table class="w-full text-sm text-left">
                        <thead class="bg-gray-50 text-gray-500 font-bold uppercase text-xs">
                            <tr>
                                <th class="px-6 py-3">Device ID</th>
                                <th class="px-6 py-3">Type</th>
                                <th class="px-6 py-3">Token (Truncated)</th>
                                <th class="px-6 py-3">Last Updated</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100">
                            @foreach($employee->fcmTokens as $token)
                                <tr class="hover:bg-gray-50">
                                    <td class="px-6 py-3 font-medium text-gray-900">{{ $token->device_id ?? 'N/A' }}</td>
                                    <td class="px-6 py-3">{{ ucfirst($token->device_type ?? 'Unknown') }}</td>
                                    <td class="px-6 py-3 font-mono text-xs text-slate-500" title="{{ $token->token }}">
                                        {{ \Illuminate\Support\Str::limit($token->token, 50) }}
                                    </td>
                                    <td class="px-6 py-3 text-slate-500">{{ $token->updated_at->format('M d, Y H:i:s') }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </div>

    <style>
        [x-cloak] {
            display: none !important;
        }
    </style>
@endsection