@extends('layouts.user')

@section('title', 'Employee Schedules')

@section('content')
    <div class="p-8 max-w-[1600px] mx-auto">
        <!-- Premium Header Section -->
        <div class="mb-8 bg-[#1e293b] p-10 rounded-[2.5rem] shadow-xl border border-slate-800 relative overflow-hidden">
            <!-- Background decoration -->
            <div class="absolute -right-20 -top-20 w-80 h-80 bg-blue-500/10 rounded-full blur-3xl"></div>
            <div class="absolute -left-10 -bottom-10 w-40 h-40 bg-slate-800 rounded-full blur-2xl"></div>

            <div class="relative z-10 flex flex-col lg:flex-row lg:items-center justify-between gap-8">
                <div class="flex items-center gap-6">
                    <!-- Profile Avatar -->
                    <div class="relative">
                        @if($employee->profile_picture)
                            <img src="{{ asset('storage/' . $employee->profile_picture) }}"
                                class="w-20 h-20 rounded-3xl object-cover ring-4 ring-blue-50 shadow-xl shadow-blue-500/10">
                        @else
                            <div
                                class="w-20 h-20 rounded-3xl bg-slate-800 flex items-center justify-center font-black text-3xl text-white shadow-xl shadow-black/20">
                                {{ substr($employee->first_name, 0, 1) }}
                            </div>
                        @endif
                    <div
                        class="absolute -bottom-2 -right-2 w-8 h-8 bg-green-500 rounded-2xl border-4 border-[#1e293b] flex items-center justify-center shadow-lg">
                        <div class="w-2 h-2 bg-white rounded-full animate-pulse"></div>
                    </div>
                </div>

                <div>
                    <nav
                        class="flex items-center gap-2 text-[10px] font-black uppercase tracking-[0.2em] text-slate-400 mb-2">
                        <a href="{{ route('employees.index') }}" class="hover:text-blue-400 transition-colors">Force</a>
                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M9 5l7 7-7 7" />
                        </svg>
                        <span class="text-white">Deployment Grid</span>
                    </nav>
                    <h1 class="text-4xl font-black text-white tracking-tight leading-none mb-2">
                        {{ $employee->first_name }} <span class="text-blue-500">{{ $employee->last_name }}</span>
                    </h1>
                    <div class="flex items-center gap-4">
                        <span
                            class="px-3 py-1 bg-slate-800 text-slate-300 text-[10px] font-black rounded-lg uppercase tracking-wider">ID:
                            {{ $employee->employee_id }}</span>
                        <div class="flex items-center gap-1.5">
                            <div class="w-1.5 h-1.5 rounded-full bg-blue-500"></div>
                            <span
                                class="text-[10px] font-black text-slate-400 uppercase tracking-widest">{{ $employee->jobRole->name ?? 'Specialist' }}</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Header Actions -->
            <div class="flex flex-wrap items-center gap-4">
                <div class="flex gap-3">
                    <a href="{{ route('employees.show', $employee->id) }}"
                        class="px-8 py-5 bg-blue-600 text-white font-black text-[10px] uppercase tracking-[0.2em] rounded-2xl hover:bg-blue-500 transition-all shadow-xl shadow-blue-900/20 active:scale-95 flex items-center gap-3">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                                d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                        </svg>
                        Profile
                    </a>
                </div>
            </div>
        </div>

        <!-- Navigation Tabs -->
        <div class="mt-10 border-t border-slate-700/50 pt-8">
            <nav class="flex items-center gap-8 text-sm font-bold overflow-x-auto pb-2">
                <a href="{{ route('employees.show', $employee->id) }}"
                    class="border-b-2 border-transparent text-slate-400 hover:text-white transition-colors whitespace-nowrap pb-2">Overview</a>

                <a href="{{ route('employees.show', ['employee' => $employee->id, 'tab' => 'documents']) }}"
                    class="border-b-2 border-transparent text-slate-400 hover:text-white transition-colors whitespace-nowrap pb-2">Documents</a>

                <a href="#"
                    class="border-b-2 border-white text-white transition-colors whitespace-nowrap pb-2">Schedules</a>

                <a href="{{ route('employees.id_card', $employee->id) }}" target="_blank"
                    class="border-b-2 border-transparent text-slate-400 hover:text-white transition-colors whitespace-nowrap flex items-center gap-2 pb-2">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
                    </svg>
                    View ID Card
                </a>

                <a href="{{ route('employees.show', ['employee' => $employee->id, 'tab' => 'uniforms']) }}"
                    class="border-b-2 border-transparent text-slate-400 hover:text-white transition-colors whitespace-nowrap pb-2">Uniforms</a>

                <a href="{{ route('employees.show', ['employee' => $employee->id, 'tab' => 'banned']) }}"
                    class="border-b-2 border-transparent text-slate-400 hover:text-white transition-colors whitespace-nowrap pb-2">Banned
                    Sites</a>

                <a href="{{ route('employees.show', ['employee' => $employee->id, 'tab' => 'availability']) }}"
                    class="border-b-2 border-transparent text-slate-400 hover:text-white transition-colors whitespace-nowrap pb-2">Availability</a>

                <a href="{{ route('employees.show', ['employee' => $employee->id, 'tab' => 'devices']) }}"
                    class="border-b-2 border-transparent text-slate-400 hover:text-white transition-colors whitespace-nowrap pb-2">Devices</a>

                <a href="{{ route('employees.edit', $employee->id) }}"
                    class="border-b-2 border-transparent text-slate-400 hover:text-blue-600 transition-colors whitespace-nowrap pb-2">Edit
                    Profile</a>
            </nav>
        </div>
    </div>

    <!-- Status Legend - Horizontal -->
    <div class="mb-8 flex flex-wrap gap-4 items-center">
        <span class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em] mr-4">Calendar Key:</span>
        <div
            class="flex items-center gap-2 bg-white px-4 py-2.5 rounded-2xl border border-slate-100 shadow-sm transition-all hover:bg-green-50/50">
            <div class="w-2.5 h-2.5 rounded-full bg-green-500 shadow-lg shadow-green-500/30"></div>
            <span class="text-[10px] font-black text-slate-900 uppercase tracking-widest">Guard - Upcoming</span>
        </div>
        <div
            class="flex items-center gap-2 bg-white px-4 py-2.5 rounded-2xl border border-slate-100 shadow-sm transition-all hover:bg-purple-50/50">
            <div class="w-2.5 h-2.5 rounded-full bg-purple-500 shadow-lg shadow-purple-500/30"></div>
            <span class="text-[10px] font-black text-slate-900 uppercase tracking-widest">Patrol - Upcoming</span>
        </div>
        <div
            class="flex items-center gap-2 bg-white px-4 py-2.5 rounded-2xl border border-slate-100 shadow-sm transition-all hover:bg-amber-50/50 text-amber-600">
            <div class="w-3.5 h-3.5 rounded-full border-2 border-amber-500 animate-pulse"></div>
            <span class="text-[10px] font-black uppercase tracking-widest text-slate-900">Today/Active</span>
        </div>
        <div
            class="flex items-center gap-2 bg-white px-4 py-2.5 rounded-2xl border border-slate-100 shadow-sm transition-all hover:bg-red-50/50">
            <div class="w-2.5 h-2.5 rounded-full bg-red-500 shadow-lg shadow-red-500/30"></div>
            <span class="text-[10px] font-black text-slate-900 uppercase tracking-widest">Missed</span>
        </div>
        <div
            class="flex items-center gap-2 bg-white px-4 py-2.5 rounded-2xl border border-slate-100 shadow-sm transition-all hover:bg-blue-50/50">
            <div class="w-2.5 h-2.5 rounded-full bg-blue-500 shadow-lg shadow-blue-500/30"></div>
            <span class="text-[10px] font-black text-slate-900 uppercase tracking-widest">Guard - Done</span>
        </div>
        <div
            class="flex items-center gap-2 bg-white px-4 py-2.5 rounded-2xl border border-slate-100 shadow-sm transition-all hover:bg-cyan-50/50">
            <div class="w-2.5 h-2.5 rounded-full bg-cyan-500 shadow-lg shadow-cyan-500/30"></div>
            <span class="text-[10px] font-black text-slate-900 uppercase tracking-widest">Patrol - Done</span>
        </div>
    </div>

    <!-- Calendar Container - Full Width -->
    <div class="bg-white p-10 rounded-[3rem] shadow-2xl shadow-slate-200/50 border border-gray-100 min-h-[800px]">
        <div id="calendar" class="w-full"></div>
    </div>
    </div>

    <style>
        /* Premium FullCalendar Styling */
        :root {
            --fc-border-color: #f1f5f9;
            --fc-daygrid-dot-event-font-size: 11px;
            --fc-page-bg-color: transparent;
            --fc-today-bg-color: #f8faff;
        }

        .fc {
            font-family: 'Inter', sans-serif !important;
            border: none !important;
        }

        /* Toolbar */
        .fc .fc-toolbar {
            justify-content: space-between;
            margin-bottom: 3rem !important;
        }

        .fc .fc-toolbar-title {
            font-size: 2rem !important;
            font-weight: 900 !important;
            color: #0f172a !important;
            letter-spacing: -0.04em;
        }

        /* Buttons */
        .fc .fc-button {
            background: #f8fafc !important;
            border: 1px solid #e2e8f0 !important;
            color: #64748b !important;
            font-weight: 900 !important;
            text-transform: uppercase !important;
            font-size: 10px !important;
            padding: 12px 24px !important;
            border-radius: 16px !important;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
            letter-spacing: 0.1em;
        }

        .fc .fc-button:hover {
            background: #f1f5f9 !important;
            color: #0f172a !important;
            transform: translateY(-1px);
        }

        .fc .fc-button-active {
            background: #0f172a !important;
            color: white !important;
            border-color: #0f172a !important;
        }

        /* Grid */
        .fc .fc-col-header-cell {
            background: #f8fafc;
            border: none !important;
        }

        .fc .fc-col-header-cell-cushion {
            padding: 24px 0 !important;
            color: #94a3b8 !important;
            font-size: 11px !important;
            font-weight: 900 !important;
            text-transform: uppercase !important;
            letter-spacing: 0.2em;
        }

        .fc .fc-daygrid-day-number {
            font-size: 14px !important;
            font-weight: 900 !important;
            color: #475569 !important;
            padding: 20px !important;
            font-family: 'JetBrains Mono', monospace;
        }

        .fc .fc-daygrid-day {
            transition: background 0.2s;
        }

        .fc .fc-daygrid-day:hover {
            background: #fcfdfe;
        }

        /* Events */
        .fc .fc-event {
            border: none !important;
            padding: 6px 10px !important;
            margin: 2px 4px !important;
            border-radius: 12px !important;
            font-weight: 800 !important;
            font-size: 10px !important;
            box-shadow: 0 4px 6px -1px rgb(0 0 0 / 0.1) !important;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
        }

        .fc .fc-event:hover {
            transform: translateY(-2px) scale(1.02);
            box-shadow: 0 10px 15px -3px rgb(0 0 0 / 0.1) !important;
            filter: brightness(1.1);
        }

        .fc-event-main {
            padding: 2px 0;
        }

        /* Time Grid */
        .fc-timegrid-slot {
            height: 4rem !important;
        }
    </style>

    @push('scripts')
        <script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.10/index.global.min.js'></script>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                const calendarEl = document.getElementById('calendar');

                const calendar = new FullCalendar.Calendar(calendarEl, {
                    initialView: 'dayGridMonth',
                    timeZone: 'UTC',
                    events: @json($events),
                    headerToolbar: {
                        left: 'prev,next today',
                        center: 'title',
                        right: 'dayGridMonth,timeGridWeek,listMonth'
                    },
                    firstDay: 1,
                    eventClick: function (info) {
                        if (info.event.url) {
                            window.location.href = info.event.url;
                        }
                    },
                    height: 'auto',
                    dayMaxEvents: 4,
                    displayEventTime: true,
                    eventTimeFormat: {
                        hour: '2-digit',
                        minute: '2-digit',
                        meridiem: 'short'
                    },
                    dayCellDidMount: function (arg) {
                        // Subtle effect for weekends
                        if (arg.date.getDay() === 0 || arg.date.getDay() === 6) {
                            arg.el.style.backgroundColor = '#fcfdfe';
                        }
                    }
                });

                calendar.render();
            });
        </script>
    @endpush
@endsection