@extends('layouts.user')

@section('title', 'Create a New Employee')

@section('content')
    <div class="max-w-7xl mx-auto" x-data="{
                                                            activeTab: 'general',
                                                            selectedWageTypes: [],
                                                            fileNames: {
                                                                license: '',
                                                                contract: '',
                                                                ids: []
                                                            },
                                                            formData: {
                                                                first_name: '',
                                                                gender: '',
                                                                email: '',
                                                                job_role_id: '',
                                                                phone_number: '',
                                                                licence_province_name: '',
                                                                license_number: '',
                                                                license_expiry: '',
                                                                file_license: false,
                                                                file_id: false,
                                                                file_contract: false,
                                                                profilePictureUrl: '',
                                                                wage_rates: {},
                                                                zone_id: '',
                                                                department_id: '',
                                                                has_car: false,
                                                            },
                                                            // Address Logic
                                                            sameAsPermanent: false,
                                                            permStates: [],
                                                            corsStates: [],
                                                            perm: { street1: '', street2: '', country_id: '', state_id: '', city: '', zip: '' },
                                                            cors: { street1: '', street2: '', country_id: '', state_id: '', city: '', zip: '' },

                                                            handlePhotoChange(event) {
                                                                const file = event.target.files[0];
                                                                if (file) {
                                                                    const reader = new FileReader();
                                                                    reader.onload = (e) => {
                                                                        this.formData.profilePictureUrl = e.target.result;
                                                                    };
                                                                    reader.readAsDataURL(file);
                                                                }
                                                            },
                                                            isComplete(field) {
                                                                return !!this.formData[field];
                                                            },
                                                            isRateComplete(id) {
                                                                return !!this.formData.wage_rates[id];
                                                            },
                                                            updateFile(field, event) {
                                                                const hasFiles = event.target.files.length > 0;
                                                                this.formData[field] = hasFiles;

                                                                if (field === 'file_license') {
                                                                    this.fileNames.license = hasFiles ? event.target.files[0].name : '';
                                                                } else if (field === 'file_contract') {
                                                                    this.fileNames.contract = hasFiles ? event.target.files[0].name : '';
                                                                } else if (field === 'file_id') {
                                                                    this.fileNames.ids = hasFiles ? Array.from(event.target.files).map(f => f.name) : [];
                                                                }
                                                            },
                                                            errors: {},
                                                            async validateStep(step) {
                                                                this.errors = {};
                                                                try {
                                                                    const response = await fetch('{{ route('employees.validate') }}', {
                                                                        method: 'POST',
                                                                        headers: {
                                                                            'Content-Type': 'application/json',
                                                                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                                                                        },
                                                                        body: JSON.stringify({
                                                                            ...this.formData,
                                                                            step: step
                                                                        })
                                                                    });

                                                                    const data = await response.json();

                                                                    if (!response.ok) {
                                                                        if (data.errors) {
                                                                            this.errors = data.errors;
                                                                            return false;
                                                                        }
                                                                    }
                                                                    return true;
                                                                } catch (e) {
                                                                    console.error('Validation error', e);
                                                                    return false;
                                                                }
                                                            },
                                                            async nextStep(current, next) {
                                                                 const valid = await this.validateStep(current);
                                                                 if (valid) {
                                                                     this.activeTab = next;
                                                                 }
                                                            },
                                                            async fetchPermStates() {
                                                               if (!this.perm.country_id) { this.permStates = []; return; }
                                                               const response = await fetch(`/api/countries/${this.perm.country_id}/states`);
                                                               this.permStates = await response.json();
                                                            },
                                                            async fetchCorsStates() {
                                                               if (!this.cors.country_id) { this.corsStates = []; return; }
                                                               const response = await fetch(`/api/countries/${this.cors.country_id}/states`);
                                                               this.corsStates = await response.json();
                                                            },
                                                            sync() {
                                                               if (this.sameAsPermanent) {
                                                                    this.cors = JSON.parse(JSON.stringify(this.perm));
                                                                    this.corsStates = [...this.permStates];
                                                               }
                                                            },
                                                            init() {
                                                               this.$watch('sameAsPermanent', value => {
                                                                   if(value) this.sync();
                                                               });
                                                               this.$watch('perm.country_id', () => { this.fetchPermStates(); if(this.sameAsPermanent) this.sync(); });
                                                               this.$watch('cors.country_id', () => { if(!this.sameAsPermanent) this.fetchCorsStates(); });
                                                               this.$watch('perm', value => {
                                                                   if(this.sameAsPermanent) this.sync();
                                                               }, {deep: true});
                                                            }
                                                        }">
        <!-- Breadcrumb & Header -->
        <div class="mb-8 flex items-center justify-between">
            <div>
                <div class="flex items-center gap-2 text-xs text-slate-400 mb-2">
                    <a href="{{ route('employees.index') }}" class="hover:text-blue-600 transition-colors">Employees</a>
                    <svg class="w-3 h-3 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                    <span class="text-slate-900 font-bold">New Employee</span>
                </div>
                <h1 class="text-2xl font-black text-slate-900 tracking-tight">Create Employee</h1>
            </div>

            <a href="{{ route('employees.index') }}"
                class="flex items-center gap-2 px-5 py-2.5 bg-white border border-slate-200 text-slate-600 text-xs font-bold rounded-2xl hover:bg-slate-50 transition-all shadow-sm">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18">
                    </path>
                </svg>
                Back to List
            </a>
        </div>

        <!-- Top Navigation Tabs -->
        <div class="mb-6 bg-[#1e293b] rounded-3xl shadow-lg border border-slate-700 p-2 sticky top-4 z-30">
            <nav class="flex flex-wrap md:flex-nowrap gap-2">
                <button @click="activeTab = 'general'"
                    :class="activeTab === 'general' ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'text-slate-400 hover:bg-slate-800 hover:text-white'"
                    class="flex-1 px-4 py-3 text-sm font-bold rounded-2xl transition-all flex items-center justify-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                    </svg>
                    <span class="whitespace-nowrap">General Information</span>
                </button>
                <button @click="activeTab = 'address'"
                    :class="activeTab === 'address' ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'text-slate-400 hover:bg-slate-800 hover:text-white'"
                    class="flex-1 px-4 py-3 text-sm font-bold rounded-2xl transition-all flex items-center justify-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                        </path>
                    </svg>
                    <span class="whitespace-nowrap">Address Details</span>
                </button>
                <button @click="activeTab = 'licence'"
                    :class="activeTab === 'licence' ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'text-slate-400 hover:bg-slate-800 hover:text-white'"
                    class="flex-1 px-4 py-3 text-sm font-bold rounded-2xl transition-all flex items-center justify-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z">
                        </path>
                    </svg>
                    <span class="whitespace-nowrap">Licence Details</span>
                </button>
                <button @click="activeTab = 'other'"
                    :class="activeTab === 'other' ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'text-slate-400 hover:bg-slate-800 hover:text-white'"
                    class="flex-1 px-4 py-3 text-sm font-bold rounded-2xl transition-all flex items-center justify-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <span class="whitespace-nowrap">Work Details</span>
                </button>
                <button @click="activeTab = 'skills'"
                    :class="activeTab === 'skills' ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'text-slate-400 hover:bg-slate-800 hover:text-white'"
                    class="flex-1 px-4 py-3 text-sm font-bold rounded-2xl transition-all flex items-center justify-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <span class="whitespace-nowrap">Skills & Attributes</span>
                </button>
            </nav>
        </div>

        <div class="flex flex-col lg:flex-row gap-6">
            <!-- Left Column: Navigation & Info -->
            <div class="w-full lg:w-72 flex-shrink-0 space-y-6">

                <!-- Required Fields -->
                <div class="bg-white border border-gray-200 rounded-3xl shadow-sm overflow-hidden sticky top-32">
                    <div class="px-6 py-4 bg-gray-50 border-b border-gray-200">
                        <span class="text-xs font-black uppercase text-gray-400 tracking-widest leading-none">Required
                            Fields</span>
                    </div>
                    <div class="p-6 space-y-4">
                        <template
                            x-for="(label, field) in {
                                                                                                                                                                                                first_name: 'First Name',
                                                                                                                                                                                                gender: 'Gender',
                                                                                                                                                                                                email: 'Email-ID',
                                                                                                                                                                                                job_role_id: 'Job Role',
                                                                                                                                                                                                phone_number: 'Phone Number',
                                                                                                                                                                                                license_number: 'License Number',
                                                                                                                                                                                                license_expiry: 'License Expiry',
                                                                                                                                                                                                 file_license: 'License File',
                                                                                                                                                                                                 file_contract: 'Contract File'}">
                                <div class="flex items-center justify-between text-xs transition-colors duration-200"
                                    :class="isComplete(field) ? 'text-green-600 font-bold' : 'text-slate-400'">
                                    <span x-text="label"></span>
                                    <div x-show="isComplete(field)"
                                        class="w-4 h-4 rounded-full bg-green-500 flex items-center justify-center"
                                        x-transition.scale.origin.center>
                                        <svg class="w-2.5 h-2.5 text-white" fill="none" viewBox="0 0 24 24"
                                            stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3"
                                                d="M5 13l4 4L19 7" />
                                        </svg>
                                    </div>
                                    <span x-show="!isComplete(field)"
                                        class="w-3 h-3 block rounded-full border-2 border-slate-200"></span>
                                </div>
                            </template>
                            <!-- Special case for file_id -->
                            <div class="flex items-center justify-between text-xs transition-colors duration-200"
                                :class="isComplete('file_id') ? 'text-green-600 font-bold' : 'text-slate-400'">
                                <span>ID File</span>
                                <div x-show="isComplete('file_id')"
                                    class="w-4 h-4 rounded-full bg-green-500 flex items-center justify-center"
                                    x-transition.scale.origin.center>
                                    <svg class="w-2.5 h-2.5 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3"
                                            d="M5 13l4 4L19 7" />
                                    </svg>
                                </div>
                                <span x-show="!isComplete('file_id')"
                                    class="w-3 h-3 block rounded-full border-2 border-slate-200"></span>
                            </div>

                            <!-- Wage Rates -->
                            <template x-for="item in selectedWageTypes" :key="item.id">
                                <div class="flex items-center justify-between text-xs transition-colors duration-200"
                                    :class="isRateComplete(item.id) ? 'text-green-600 font-bold' : 'text-slate-400'">
                                    <span x-text="item.name + ' Rate'"></span>
                                    <div x-show="isRateComplete(item.id)"
                                        class="w-4 h-4 rounded-full bg-green-500 flex items-center justify-center"
                                        x-transition.scale.origin.center>
                                        <svg class="w-2.5 h-2.5 text-white" fill="none" viewBox="0 0 24 24"
                                            stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3"
                                                d="M5 13l4 4L19 7" />
                                        </svg>
                                    </div>
                                    <span x-show="!isRateComplete(item.id)"
                                        class="w-3 h-3 block rounded-full border-2 border-slate-200"></span>
                                </div>
                            </template>
                        </div>
                    </div>
                </div>

                <!-- Main Form Area -->
                <div class="flex-1">
                    <div class="bg-white border border-gray-100 rounded-3xl shadow-sm p-10 min-h-[600px]">
                        @if ($errors->any())
                            <div
                                class="mb-8 p-4 bg-red-50 border border-red-100 text-red-700 rounded-2xl shadow-sm animate-fade-in-down">
                                <div class="flex items-center gap-3 mb-2">
                                    <div
                                        class="w-6 h-6 bg-red-500 rounded-full flex items-center justify-center text-white shrink-0">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                                                d="M6 18L18 6M6 6l12 12"></path>
                                        </svg>
                                    </div>
                                    <p class="text-xs font-bold uppercase tracking-wider">Please fix the following errors:</p>
                                </div>
                                <ul class="list-disc list-inside text-xs space-y-1 ml-9">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <form id="employee-form" action="{{ route('employees.store') }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf

                            <!-- General Information Tab -->
                            <div x-show="activeTab === 'general'" class="space-y-6">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-4">
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Employee ID</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M10 6H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V8a2 2 0 00-2-2h-5m-4 0V5a2 2 0 114 0v1m-4 0c0 .884-.2 1.41-.5 2" />
                                                </svg>
                                            </div>
                                            <input type="text" name="employee_id" value="{{ $uniqueId }}" readonly
                                                class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm bg-gray-100 text-gray-500 cursor-not-allowed">
                                        </div>
                                    </div>

                                    <div class="flex flex-col">
                                        <label
                                            class="text-[11px] font-bold text-gray-500 uppercase tracking-wider mb-2 block">First
                                            Name <span class="text-red-500">*</span></label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="first_name" required x-model="formData.first_name"
                                                class="w-full text-xs bg-slate-50 border-slate-200 rounded-xl focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-3 px-4 pl-10 transition-all shadow-sm">
                                            <div class="text-xs text-red-500 mt-1 font-bold"
                                                x-text="errors.first_name && errors.first_name[0]" x-show="errors.first_name">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="flex flex-col">
                                        <label
                                            class="text-[11px] font-bold text-gray-500 uppercase tracking-wider mb-2 block">Middle
                                            Name</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="middle_name"
                                                class="w-full text-xs bg-slate-50 border-slate-200 rounded-xl focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-3 px-4 pl-10 transition-all shadow-sm">
                                        </div>
                                    </div>

                                    <div class="flex flex-col">
                                        <label
                                            class="text-[11px] font-bold text-gray-500 uppercase tracking-wider mb-2 block">Last
                                            Name</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="last_name"
                                                class="w-full text-xs bg-slate-50 border-slate-200 rounded-xl focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-3 px-4 pl-10 transition-all shadow-sm">
                                        </div>
                                    </div>

                                    <div class="flex flex-col">
                                        <label
                                            class="text-[11px] font-bold text-gray-500 uppercase tracking-wider mb-2 block">Gender
                                            <span class="text-red-500">*</span></label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
                                                </svg>
                                            </div>
                                            <select name="gender" required x-model="formData.gender"
                                                class="w-full text-xs bg-slate-50 border-slate-200 rounded-xl focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-3 px-4 pl-10 transition-all shadow-sm cursor-pointer">
                                                <option value="">Select Gender</option>
                                                <option value="Male">Male</option>
                                                <option value="Female">Female</option>
                                                <option value="Other">Other</option>
                                            </select>
                                            <div class="text-xs text-red-500 mt-1 font-bold"
                                                x-text="errors.gender && errors.gender[0]" x-show="errors.gender"></div>
                                        </div>
                                    </div>

                                    <div class="flex flex-col">
                                        <label
                                            class="text-[11px] font-bold text-gray-500 uppercase tracking-wider mb-2 block">Car
                                            Available</label>
                                        <div class="flex items-center gap-4 py-3">
                                            <label class="relative inline-flex items-center cursor-pointer group">
                                                <input type="checkbox" name="has_car" x-model="formData.has_car" value="1"
                                                    class="sr-only peer">
                                                <div
                                                    class="w-11 h-6 bg-slate-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600">
                                                </div>
                                                <span
                                                    class="ml-3 text-xs font-bold text-slate-600 group-hover:text-slate-900 transition-colors"
                                                    x-text="formData.has_car ? 'Yes, car available' : 'No car available'"></span>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="flex flex-col">
                                        <label
                                            class="text-[11px] font-bold text-gray-500 uppercase tracking-wider mb-2 block">Profile
                                            Picture</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                </svg>
                                            </div>
                                            <input type="file" name="profile_picture" @change="handlePhotoChange($event)"
                                                class="w-full text-xs bg-slate-50 border-slate-200 rounded-xl focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-3 px-4 pl-10 transition-all shadow-sm">
                                            <template x-if="formData.profilePictureUrl">
                                                <div class="mt-2 flex items-center gap-2">
                                                    <img :src="formData.profilePictureUrl"
                                                        class="w-10 h-10 rounded-full object-cover border border-gray-200">
                                                </div>
                                            </template>
                                        </div>
                                    </div>

                                    <div class="flex flex-col col-span-1 md:col-span-2">
                                        <label
                                            class="text-[11px] font-bold text-gray-500 uppercase tracking-wider mb-2 block">Email-ID
                                            <span class="text-red-500">*</span></label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z" />
                                                </svg>
                                            </div>
                                            <input type="email" name="email" required x-model="formData.email"
                                                class="w-full text-xs bg-slate-50 border-slate-200 rounded-xl focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-3 px-4 pl-10 transition-all shadow-sm">
                                            <div class="text-xs text-red-500 mt-1 font-bold"
                                                x-text="errors.email && errors.email[0]" x-show="errors.email"></div>
                                        </div>
                                    </div>

                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">DOB</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                </svg>
                                            </div>
                                            <input type="date" name="dob"
                                                class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                        </div>
                                    </div>

                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Marital Status</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
                                                </svg>
                                            </div>
                                            <select name="marital_status"
                                                class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm bg-white">
                                                <option value="">Select Status</option>
                                                <option value="Single">Single</option>
                                                <option value="Married">Married</option>
                                                <option value="Divorced">Divorced</option>
                                                <option value="Widowed">Widowed</option>
                                            </select>
                                        </div>
                                    </div>

                                    <!-- Select Zone (Searchable) -->
                                    <div class="flex flex-col relative"
                                        x-data="{ open: false, search: '', selected: '', value: '' }"
                                        @click.outside="open = false">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Select Zone</label>
                                        <input type="hidden" name="zone_id" x-model="value; formData.zone_id = value">
                                        <button type="button" @click="open = !open"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm text-left flex justify-between items-center h-[38px] relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                                </svg>
                                            </div>
                                            <span x-text="selected || 'Select Zone'"
                                                :class="{'text-gray-400': !selected, 'text-gray-700': selected}"></span>
                                            <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 9l-7 7-7-7">
                                                </path>
                                            </svg>
                                        </button>
                                        <div x-show="open"
                                            class="absolute top-full left-0 w-full mt-1 bg-white border border-gray-200 rounded-md shadow-lg z-50 max-h-60 overflow-hidden flex flex-col"
                                            x-cloak>
                                            <div class="p-2 border-b border-gray-100">
                                                <input type="text" x-model="search" placeholder="Search..."
                                                    class="w-full text-xs border border-gray-200 rounded px-2 py-1.5 focus:outline-none focus:border-blue-500">
                                            </div>
                                            <ul class="overflow-y-auto flex-1">
                                                @foreach($zones as $zone)
                                                    <li x-show="'{{ strtolower($zone->name) }}'.includes(search.toLowerCase())"
                                                        @click="selected = '{{ $zone->name }}'; value = '{{ $zone->id }}'; formData.zone_id = '{{ $zone->id }}'; open = false; search = ''"
                                                        class="px-4 py-2 hover:bg-blue-50 hover:text-blue-600 text-sm cursor-pointer text-gray-700">
                                                        {{ $zone->name }}
                                                    </li>
                                                @endforeach
                                                <li x-show="$el.parentNode.children.length > 0 && Array.from($el.parentNode.children).filter(el => el.style.display !== 'none' && !el.hasAttribute('x-show')).length === 0"
                                                    class="px-4 py-2 text-xs text-gray-400 text-center">No results found</li>
                                            </ul>
                                        </div>
                                    </div>

                                    <!-- Job Role (Searchable) -->
                                    <div class="flex flex-col relative"
                                        x-data="{ open: false, search: '', selected: '', value: '' }"
                                        @click.outside="open = false">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Job Role <span
                                                class="text-red-500">*</span></label>
                                        <input type="hidden" name="job_role_id" x-model="value; formData.job_role_id = value"
                                            required>
                                        <button type="button" @click="open = !open"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm text-left flex justify-between items-center h-[38px] relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                                </svg>
                                            </div>
                                            <span x-text="selected || 'Select Job Role'"
                                                :class="{'text-gray-400': !selected, 'text-gray-700': selected}"></span>
                                            <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 9l-7 7-7-7">
                                                </path>
                                            </svg>
                                        </button>
                                        <div x-show="open"
                                            class="absolute top-full left-0 w-full mt-1 bg-white border border-gray-200 rounded-md shadow-lg z-50 max-h-60 overflow-hidden flex flex-col"
                                            x-cloak>
                                            <div class="p-2 border-b border-gray-100">
                                                <input type="text" x-model="search" placeholder="Search..."
                                                    class="w-full text-xs border border-gray-200 rounded px-2 py-1.5 focus:outline-none focus:border-blue-500">
                                            </div>
                                            <ul class="overflow-y-auto flex-1">
                                                @foreach($jobRoles as $role)
                                                    <li x-show="'{{ strtolower($role->name) }}'.includes(search.toLowerCase())"
                                                        @click="selected = '{{ $role->name }}'; value = '{{ $role->id }}'; formData.job_role_id = '{{ $role->id }}'; open = false; search = ''"
                                                        class="px-4 py-2 hover:bg-blue-50 hover:text-blue-600 text-sm cursor-pointer text-gray-700">
                                                        {{ $role->name }}
                                                    </li>
                                                @endforeach
                                                <li x-show="$el.parentNode.children.length > 0 && Array.from($el.parentNode.children).filter(el => el.style.display !== 'none' && !el.hasAttribute('x-show')).length === 0"
                                                    class="px-4 py-2 text-xs text-gray-400 text-center">No results found</li>
                                            </ul>
                                        </div>
                                        <div class="text-xs text-red-500 mt-1 font-bold"
                                            x-text="errors.job_role_id && errors.job_role_id[0]" x-show="errors.job_role_id">
                                        </div>
                                    </div>

                                    <!-- Select Department (Searchable) -->
                                    <div class="flex flex-col relative"
                                        x-data="{ open: false, search: '', selected: '', value: '' }"
                                        @click.outside="open = false">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Select Department</label>
                                        <input type="hidden" name="department_id"
                                            x-model="value; formData.department_id = value">
                                        <button type="button" @click="open = !open"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm text-left flex justify-between items-center h-[38px] relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                                </svg>
                                            </div>
                                            <span x-text="selected || 'Select Department'"
                                                :class="{'text-gray-400': !selected, 'text-gray-700': selected}"></span>
                                            <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 9l-7 7-7-7">
                                                </path>
                                            </svg>
                                        </button>
                                        <div x-show="open"
                                            class="absolute top-full left-0 w-full mt-1 bg-white border border-gray-200 rounded-md shadow-lg z-50 max-h-60 overflow-hidden flex flex-col"
                                            x-cloak>
                                            <div class="p-2 border-b border-gray-100">
                                                <input type="text" x-model="search" placeholder="Search..."
                                                    class="w-full text-xs border border-gray-200 rounded px-2 py-1.5 focus:outline-none focus:border-blue-500">
                                            </div>
                                            <ul class="overflow-y-auto flex-1">
                                                @foreach($departments as $dept)
                                                    <li x-show="'{{ strtolower($dept->name) }}'.includes(search.toLowerCase())"
                                                        @click="selected = '{{ $dept->name }}'; value = '{{ $dept->id }}'; formData.department_id = '{{ $dept->id }}'; open = false; search = ''"
                                                        class="px-4 py-2 hover:bg-blue-50 hover:text-blue-600 text-sm cursor-pointer text-gray-700">
                                                        {{ $dept->name }}
                                                    </li>
                                                @endforeach
                                                <li x-show="$el.parentNode.children.length > 0 && Array.from($el.parentNode.children).filter(el => el.style.display !== 'none' && !el.hasAttribute('x-show')).length === 0"
                                                    class="px-4 py-2 text-xs text-gray-400 text-center">No results found</li>
                                            </ul>
                                        </div>
                                    </div>

                                    <!-- Wage Type (Multi-select) -->
                                    <div class="flex flex-col relative" x-data="{ open: false, search: ''}"
                                        @click.outside="open = false">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Wage Type <span
                                                class="text-red-500">*</span></label>
                                        <!-- Hidden input to store values, handled by backend usually as array -->
                                        <template x-for="item in selectedWageTypes">
                                            <input type="hidden" name="wage_types[]" :value="item.id">
                                        </template>

                                        <button type="button" @click="open = !open"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm text-left flex justify-between items-center min-h-[38px] relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                </svg>
                                            </div>
                                            <span x-show="selectedWageTypes.length === 0" class="text-gray-400">Select Wage
                                                Types</span>
                                            <div x-show="selectedWageTypes.length > 0" class="flex flex-wrap gap-1">
                                                <template x-for="item in selectedWageTypes" :key="item.id">
                                                    <span
                                                        class="bg-blue-100 text-blue-700 px-2 py-0.5 rounded text-[10px] flex items-center gap-1">
                                                        <span x-text="item.name"></span>
                                                        <span
                                                            @click.stop="selectedWageTypes = selectedWageTypes.filter(i => i.id !== item.id); delete formData.wage_rates[item.id]"
                                                            class="cursor-pointer hover:text-blue-900">&times;</span>
                                                    </span>
                                                </template>
                                            </div>
                                            <svg class="w-4 h-4 text-gray-400 ml-2" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 9l-7 7-7-7">
                                                </path>
                                            </svg>
                                        </button>

                                        <div x-show="open"
                                            class="absolute top-full left-0 w-full mt-1 bg-white border border-gray-200 rounded-md shadow-lg z-50 max-h-60 overflow-hidden flex flex-col"
                                            x-cloak>
                                            <div class="p-2 border-b border-gray-100">
                                                <input type="text" x-model="search" placeholder="Search..."
                                                    class="w-full text-xs border border-gray-200 rounded px-2 py-1.5 focus:outline-none focus:border-blue-500">
                                            </div>
                                            <ul class="overflow-y-auto flex-1">
                                                @foreach($wageTypes as $type)
                                                    <li x-show="'{{ strtolower($type->name) }}'.includes(search.toLowerCase()) && !selectedWageTypes.some(s => s.id === {{ $type->id }})"
                                                        @click="selectedWageTypes.push({id: {{ $type->id }}, name: '{{ $type->name }}'})"
                                                        class="px-4 py-2 hover:bg-blue-50 hover:text-blue-600 text-sm cursor-pointer text-gray-700">
                                                        {{ $type->name }}
                                                    </li>
                                                @endforeach
                                                <li x-show="$el.parentNode.children.length > 0 && Array.from($el.parentNode.children).filter(el => el.style.display !== 'none' && !el.hasAttribute('x-show')).length === 0"
                                                    class="px-4 py-2 text-xs text-gray-400 text-center">No results found</li>
                                            </ul>
                                        </div>
                                    </div>

                                    <!-- Dynamic Wage Rates -->
                                    <template x-for="item in selectedWageTypes" :key="item.id">
                                        <div class="flex flex-col">
                                            <label class="text-sm font-bold text-slate-700 mb-2"
                                                x-text="item.name + ' Rate'"></label>
                                            <div class="relative">
                                                <div
                                                    class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                    </svg>
                                                </div>
                                                <input type="number" step="0.01" :name="'wage_rates[' + item.id + ']'" required
                                                    x-model="formData.wage_rates[item.id]"
                                                    class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                            </div>
                                        </div>
                                    </template>
                                </div>
                                <div class="mt-6 flex justify-end">
                                    <button type="button" @click="nextStep('general', 'address')"
                                        class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2.5 rounded-xl text-xs font-bold uppercase tracking-wider transition-all shadow-lg shadow-blue-500/20">
                                        Next Step
                                    </button>
                                </div>
                            </div>

                            <!-- Address Tab -->
                            <div x-show="activeTab === 'address'" class="space-y-6" x-cloak>

                                <!-- Phone Numbers -->
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-4">
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Phone Number <span
                                                class="text-red-500">*</span></label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="phone_number" required placeholder="e.g. +1 555-0199"
                                                x-model="formData.phone_number"
                                                class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                            <div class="text-xs text-red-500 mt-1 font-bold"
                                                x-text="errors.phone_number && errors.phone_number[0]"
                                                x-show="errors.phone_number"></div>
                                        </div>
                                    </div>
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Emergency Number</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="emergency_number" placeholder="e.g. +1 555-0199"
                                                class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                        </div>
                                    </div>
                                </div>

                                <!-- Permanent Address -->
                                <div class="border-t border-gray-100 pt-4">
                                    <h3 class="text-xs font-bold uppercase text-gray-500 tracking-wider mb-4">Permanent Address
                                    </h3>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-4">
                                        <div class="flex flex-col ">
                                            <label class="text-sm font-bold text-slate-700 mb-2">Address Line 1</label>
                                            <div class="relative">
                                                <div
                                                    class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                                    </svg>
                                                </div>
                                                <input type="text" name="perm_address_1" x-model="perm.street1"
                                                    @input="if(sameAsPermanent) sync()"
                                                    class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <label class="text-sm font-bold text-slate-700 mb-2">Address Line 2</label>
                                            <div class="relative">
                                                <div
                                                    class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                                    </svg>
                                                </div>
                                                <input type="text" name="perm_address_2" x-model="perm.street2"
                                                    @input="if(sameAsPermanent) sync()"
                                                    class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <label class="text-sm font-bold text-slate-700 mb-2">Country</label>
                                            <div class="relative">
                                                <div
                                                    class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                    </svg>
                                                </div>
                                                <select name="perm_country_id" x-model="perm.country_id"
                                                    @change="if(sameAsPermanent) sync()"
                                                    class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm bg-white">
                                                    <option value="">Select Country</option>
                                                    @foreach($countries as $country)
                                                        <option value="{{ $country->id }}">{{ $country->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <label class="text-sm font-bold text-slate-700 mb-2">State/Province</label>
                                            <div class="relative">
                                                <div
                                                    class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7" />
                                                    </svg>
                                                </div>
                                                <select name="perm_state_id" x-model="perm.state_id"
                                                    :disabled="!perm.country_id" @change="if(sameAsPermanent) sync()"
                                                    class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm bg-white disabled:opacity-50">
                                                    <option value="">Select State</option>
                                                    <template x-for="state in permStates" :key="state.id">
                                                        <option :value="state.id" x-text="state.name"></option>
                                                    </template>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <label class="text-sm font-bold text-slate-700 mb-2">City</label>
                                            <div class="relative">
                                                <div
                                                    class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                                    </svg>
                                                </div>
                                                <input type="text" name="perm_city" x-model="perm.city"
                                                    @input="if(sameAsPermanent) sync()"
                                                    class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <label class="text-sm font-bold text-slate-700 mb-2">Zip Code</label>
                                            <div class="relative">
                                                <div
                                                    class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M7 20l4-16m2 16l4-16M6 9h14M4 15h14" />
                                                    </svg>
                                                </div>
                                                <input type="text" name="perm_zip" x-model="perm.zip"
                                                    @input="if(sameAsPermanent) sync()"
                                                    class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Corresponding Address -->
                                <div class="border-t border-gray-100 pt-4">
                                    <div class="flex items-center justify-between mb-4">
                                        <h3 class="text-xs font-bold uppercase text-gray-500 tracking-wider">Corresponding
                                            Address</h3>
                                        <label class="flex items-center gap-2 cursor-pointer select-none">
                                            <input type="checkbox" x-model="sameAsPermanent"
                                                class="rounded text-blue-600 focus:ring-blue-500 w-4 h-4 text-xs">
                                            <span class="text-xs text-gray-600 font-medium">Same as Permanent Address</span>
                                        </label>
                                    </div>

                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-4 transition-opacity duration-200"
                                        :class="{'opacity-60 pointer-events-none': sameAsPermanent}">
                                        <div class="flex flex-col">
                                            <label class="text-sm font-bold text-slate-700 mb-2">Address Line 1</label>
                                            <div class="relative">
                                                <div
                                                    class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                                    </svg>
                                                </div>
                                                <input type="text" name="cors_address_1" x-model="cors.street1"
                                                    :readonly="sameAsPermanent"
                                                    class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <label class="text-sm font-bold text-slate-700 mb-2">Address Line 2</label>
                                            <div class="relative">
                                                <div
                                                    class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                                    </svg>
                                                </div>
                                                <input type="text" name="cors_address_2" x-model="cors.street2"
                                                    :readonly="sameAsPermanent"
                                                    class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <label class="text-sm font-bold text-slate-700 mb-2">Country</label>
                                            <div class="relative">
                                                <div
                                                    class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                    </svg>
                                                </div>
                                                <select name="cors_country_id" x-model="cors.country_id"
                                                    :disabled="sameAsPermanent"
                                                    class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm bg-white">
                                                    <option value="">Select Country</option>
                                                    @foreach($countries as $country)
                                                        <option value="{{ $country->id }}">{{ $country->name }}</option>
                                                    @endforeach
                                                </select>
                                                <input type="hidden" name="cors_country_id" x-model="cors.country_id"
                                                    x-show="sameAsPermanent">
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <label class="text-sm font-bold text-slate-700 mb-2">State/Province</label>
                                            <div class="relative">
                                                <div
                                                    class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7" />
                                                    </svg>
                                                </div>
                                                <select name="cors_state_id" x-model="cors.state_id" :disabled="sameAsPermanent"
                                                    class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm bg-white">
                                                    <option value="">Select State</option>
                                                    @foreach($provinces as $province)
                                                        <option value="{{ $province->id }}">{{ $province->name }}</option>
                                                    @endforeach
                                                </select>
                                                <input type="hidden" name="cors_state_id" x-model="cors.state_id"
                                                    x-show="sameAsPermanent">
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <label class="text-sm font-bold text-slate-700 mb-2">City</label>
                                            <div class="relative">
                                                <div
                                                    class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                                    </svg>
                                                </div>
                                                <input type="text" name="cors_city" x-model="cors.city"
                                                    :readonly="sameAsPermanent"
                                                    class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <label class="text-sm font-bold text-slate-700 mb-2">Zip Code</label>
                                            <div class="relative">
                                                <div
                                                    class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M7 20l4-16m2 16l4-16M6 9h14M4 15h14" />
                                                    </svg>
                                                </div>
                                                <input type="text" name="cors_zip" x-model="cors.zip"
                                                    :readonly="sameAsPermanent"
                                                    class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="mt-6 flex justify-end">
                                    <button type="button" @click="nextStep('address', 'licence')"
                                        class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2.5 rounded-xl text-xs font-bold uppercase tracking-wider transition-all shadow-lg shadow-blue-500/20">
                                        Next Step
                                    </button>
                                </div>
                            </div>

                            <!-- Licence Details Tab -->
                            <div x-show="activeTab === 'licence'" class="space-y-6" x-cloak>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-6">

                                    <!-- File Uploads -->
                                    <div class="flex flex-col space-y-4">
                                        <!-- Upload License -->
                                        <div>
                                            <label class="text-sm font-bold text-slate-700 mb-2 block">Upload License <span
                                                    class="text-red-500">*</span></label>
                                            <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-lg bg-gray-50 hover:bg-gray-100 transition-colors cursor-pointer relative"
                                                @click="$refs.licenseInput.click()">
                                                <div class="space-y-1 text-center">
                                                    <svg x-show="!fileNames.license" class="mx-auto h-8 w-8 text-gray-400"
                                                        stroke="currentColor" fill="none" viewBox="0 0 48 48">
                                                        <path
                                                            d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02"
                                                            stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                    <div x-show="fileNames.license"
                                                        class="mx-auto flex h-10 w-10 items-center justify-center rounded-full bg-green-100 mb-3">
                                                        <svg class="h-6 w-6 text-green-600" fill="none" viewBox="0 0 24 24"
                                                            stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="2" d="M5 13l4 4L19 7" />
                                                        </svg>
                                                    </div>
                                                    <div class="flex text-sm text-gray-600 justify-center">
                                                        <div
                                                            class="relative cursor-pointer rounded-md font-medium text-blue-600 hover:text-blue-500 focus-within:outline-none">
                                                            <span
                                                                x-text="fileNames.license ? 'Change file' : 'Upload a file'"></span>
                                                            <input id="license-upload" name="file_license" type="file"
                                                                x-ref="licenseInput" @click.stop
                                                                @change="updateFile('file_license', $event)" class="sr-only"
                                                                required>
                                                        </div>
                                                        <p class="pl-1" x-show="!fileNames.license">or drag and drop</p>
                                                    </div>
                                                    <p class="text-xs text-gray-500" x-show="!fileNames.license">PNG, JPG, PDF
                                                        up to 10MB</p>
                                                    <p class="text-xs font-bold text-green-600 mt-2" x-show="fileNames.license"
                                                        x-text="fileNames.license"></p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="text-xs text-red-500 mt-1 font-bold"
                                            x-text="errors.file_license && errors.file_license[0]" x-show="errors.file_license">
                                        </div>
                                    </div>

                                    <!-- Upload ID -->
                                    <div>
                                        <label class="text-sm font-bold text-slate-700 mb-2 block">Upload ID <span
                                                class="text-red-500">*</span></label>
                                        <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-lg bg-gray-50 hover:bg-gray-100 transition-colors cursor-pointer relative"
                                            @click="$refs.idInput.click()">
                                            <div class="space-y-1 text-center">
                                                <svg x-show="fileNames.ids.length === 0" class="mx-auto h-8 w-8 text-gray-400"
                                                    stroke="currentColor" fill="none" viewBox="0 0 48 48">
                                                    <path
                                                        d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02"
                                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                                <div x-show="fileNames.ids.length > 0"
                                                    class="mx-auto flex h-10 w-10 items-center justify-center rounded-full bg-blue-100 mb-3">
                                                    <svg class="h-6 w-6 text-blue-600" fill="none" viewBox="0 0 24 24"
                                                        stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                                    </svg>
                                                </div>
                                                <div class="flex text-sm text-gray-600 justify-center">
                                                    <div
                                                        class="relative cursor-pointer rounded-md font-medium text-blue-600 hover:text-blue-500 focus-within:outline-none">
                                                        <span
                                                            x-text="fileNames.ids.length > 0 ? 'Add more / Change files' : 'Upload files'"></span>
                                                        <input id="id-upload" name="file_id[]" type="file" class="sr-only"
                                                            x-ref="idInput" @change="updateFile('file_id', $event)" @click.stop
                                                            multiple required>
                                                    </div>
                                                    <p class="pl-1" x-show="fileNames.ids.length === 0">or drag and drop</p>
                                                </div>
                                                <p class="text-xs text-gray-500" x-show="fileNames.ids.length === 0">PNG,
                                                    JPG, PDF up to 10MB</p>
                                                <div class="mt-2 space-y-1" x-show="fileNames.ids.length > 0">
                                                    <template x-for="name in fileNames.ids">
                                                        <p
                                                            class="text-[10px] font-bold text-blue-600 flex items-center justify-center gap-1">
                                                            <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                                                                <path fill-rule="evenodd"
                                                                    d="M4 4a2 2 0 012-2h4.586A2 2 0 0112 2.586L15.414 6A2 2 0 0116 7.414V16a2 2 0 01-2 2H6a2 2 0 01-2-2V4z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                            <span x-text="name"></span>
                                                        </p>
                                                    </template>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="text-xs text-red-500 mt-1 font-bold"
                                        x-text="errors.file_id && errors.file_id[0]" x-show="errors.file_id"></div>
                                </div>

                                <div>
                                    <label class="text-sm font-bold text-slate-700 mb-2 block">Contract <span
                                            class="text-red-500">*</span></label>
                                    <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-lg bg-gray-50 hover:bg-gray-100 transition-colors cursor-pointer relative"
                                        @click="$refs.contractInput.click()">
                                        <div class="space-y-1 text-center">
                                            <svg x-show="!fileNames.contract" class="mx-auto h-8 w-8 text-gray-400"
                                                stroke="currentColor" fill="none" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                            </svg>
                                            <div x-show="fileNames.contract"
                                                class="mx-auto flex h-10 w-10 items-center justify-center rounded-full bg-indigo-100 mb-3">
                                                <svg class="h-6 w-6 text-indigo-600" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M5 13l4 4L19 7" />
                                                </svg>
                                            </div>
                                            <div class="flex text-sm text-gray-600 justify-center">
                                                <div
                                                    class="relative cursor-pointer rounded-md font-medium text-blue-600 hover:text-blue-500 focus-within:outline-none">
                                                    <span x-text="fileNames.contract ? 'Change file' : 'Upload a file'"></span>
                                                    <input id="contract-upload" name="file_contract" type="file"
                                                        x-ref="contractInput" @click.stop
                                                        @change="updateFile('file_contract', $event)" class="sr-only" required>
                                                </div>
                                                <p class="pl-1" x-show="!fileNames.contract">or drag and drop</p>
                                            </div>
                                            <p class="text-xs text-gray-500" x-show="!fileNames.contract">PDF, DOCX up
                                                to 10MB</p>
                                            <p class="text-xs font-bold text-indigo-600 mt-2" x-show="fileNames.contract"
                                                x-text="fileNames.contract"></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="text-xs text-red-500 mt-1 font-bold"
                                    x-text="errors.file_contract && errors.file_contract[0]" x-show="errors.file_contract">
                                </div>

                                <!-- Licence Issuing Province -->
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-6 pt-4 border-t border-gray-100">
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Licence Issuing Province </label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="licence_province_name"
                                                x-model="formData.licence_province_name"
                                                class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                        </div>
                                    </div>

                                    <!-- License Information -->
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">License Number <span
                                                class="text-red-500">*</span></label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M10 6H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V8a2 2 0 00-2-2h-5m-4 0V5a2 2 0 114 0v1m-4 0c0 .884-.2 1.41-.5 2" />
                                                </svg>
                                            </div>
                                            <input type="text" name="license_number" required x-model="formData.license_number"
                                                class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                            <div class="text-xs text-red-500 mt-1 font-bold"
                                                x-text="errors.license_number && errors.license_number[0]"
                                                x-show="errors.license_number"></div>
                                        </div>
                                    </div>

                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">License Expiry Date <span
                                                class="text-red-500">*</span></label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                </svg>
                                            </div>
                                            <input type="date" name="license_expiry" required x-model="formData.license_expiry"
                                                class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                            <div class="text-xs text-red-500 mt-1 font-bold"
                                                x-text="errors.license_expiry && errors.license_expiry[0]"
                                                x-show="errors.license_expiry"></div>
                                        </div>
                                    </div>
                                </div>

                                <div class="mt-6 flex justify-end">
                                    <button type="button" @click="nextStep('licence', 'other')"
                                        class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2.5 rounded-xl text-xs font-bold uppercase tracking-wider transition-all shadow-lg shadow-blue-500/20">
                                        Next Step
                                    </button>
                                </div>
                            </div>


                            <!-- Other Fields Tab -->
                            <div x-show="activeTab === 'other'" class="space-y-6" x-cloak>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-6">
                                    <!-- Reporting Manager -->
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Enter Reporting Manager</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="reporting_manager"
                                                class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                        </div>
                                    </div>

                                    <!-- SIN No -->
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">SIN No</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M10 6H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V8a2 2 0 00-2-2h-5m-4 0V5a2 2 0 114 0v1m-4 0c0 .884-.2 1.41-.5 2" />
                                                </svg>
                                            </div>
                                            <input type="text" name="sin_number"
                                                class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                        </div>
                                    </div>

                                    <!-- Direct Deposit Form -->
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Direct Deposit Form</label>
                                        <div class="flex items-center gap-2">
                                            <div
                                                class="flex-1 border border-gray-300 rounded bg-gray-50 px-3 py-1.5 text-sm text-gray-500 w-full">
                                                <input type="file" name="file_direct_deposit"
                                                    class="w-full text-xs text-slate-500 file:mr-4 file:py-1 file:px-2 file:rounded-full file:border-0 file:text-xs file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                                            </div>
                                        </div>
                                    </div>



                                    <!-- Additional Remarks -->
                                    <div class="flex flex-col col-span-1 md:col-span-2">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Enter Additional Remarks</label>
                                        <div class="relative">
                                            <div class="absolute top-2 left-0 pl-3 flex items-start pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                                                </svg>
                                            </div>
                                            <textarea name="additional_remarks" rows="2"
                                                class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm"></textarea>
                                        </div>
                                    </div>

                                    <!-- Experience Details Section -->
                                    <div class="col-span-1 md:col-span-2 border-t border-gray-200 mt-4 pt-4"
                                        x-data="{ experiences: [{id: 1}] }">
                                        <div class="flex items-center justify-between mb-4">
                                            <label class="text-sm font-bold text-gray-700">Enter Experience Details (If
                                                any)</label>
                                            <button type="button" @click="experiences.push({id: Date.now()})"
                                                class="text-xs bg-blue-50 text-blue-600 px-3 py-1 rounded font-medium hover:bg-blue-100 transition-colors">
                                                + Add Record
                                            </button>
                                        </div>

                                        <template x-for="(exp, index) in experiences" :key="exp.id">
                                            <div class="bg-gray-50 border border-gray-200 rounded p-4 mb-4 relative group">
                                                <button type="button"
                                                    @click="experiences = experiences.filter(e => e.id !== exp.id)"
                                                    class="absolute top-2 right-2 text-gray-400 hover:text-red-500"
                                                    x-show="experiences.length > 1">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M6 18L18 6M6 6l12 12"></path>
                                                    </svg>
                                                </button>
                                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                                    <div class="flex flex-col">
                                                        <label class="text-[10px] font-medium text-gray-500 uppercase">Company
                                                            Name</label>
                                                        <div class="relative">
                                                            <div
                                                                class="absolute inset-y-0 left-0 pl-2 flex items-center pointer-events-none">
                                                                <svg class="h-3 w-3 text-gray-400"
                                                                    xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                    viewBox="0 0 24 24" stroke="currentColor">
                                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                                        stroke-width="2"
                                                                        d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                                                </svg>
                                                            </div>
                                                            <input type="text" :name="`experience[${index}][company]`"
                                                                class="w-full text-xs border-gray-300 rounded focus:ring-blue-500 focus:border-blue-500 py-1 pl-7 px-2">
                                                        </div>
                                                    </div>
                                                    <div class="flex flex-col">
                                                        <label class="text-[10px] font-medium text-gray-500 uppercase">Document
                                                            Proof</label>
                                                        <input type="file" :name="`experience[${index}][proof]`"
                                                            class="w-full text-xs text-gray-500 file:mr-2 file:py-0.5 file:px-2 file:rounded-full file:border-0 file:text-[10px] file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                                                    </div>
                                                    <div class="flex flex-col">
                                                        <label class="text-[10px] font-medium text-gray-500 uppercase">Start
                                                            Date</label>
                                                        <div class="relative">
                                                            <div
                                                                class="absolute inset-y-0 left-0 pl-2 flex items-center pointer-events-none">
                                                                <svg class="h-3 w-3 text-gray-400"
                                                                    xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                    viewBox="0 0 24 24" stroke="currentColor">
                                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                                        stroke-width="2"
                                                                        d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                                </svg>
                                                            </div>
                                                            <input type="date" :name="`experience[${index}][start_date]`"
                                                                class="w-full text-xs border-gray-300 rounded focus:ring-blue-500 focus:border-blue-500 py-1 pl-7 px-2">
                                                        </div>
                                                    </div>
                                                    <div class="flex flex-col">
                                                        <label class="text-[10px] font-medium text-gray-500 uppercase">End
                                                            Date</label>
                                                        <div class="relative">
                                                            <div
                                                                class="absolute inset-y-0 left-0 pl-2 flex items-center pointer-events-none">
                                                                <svg class="h-3 w-3 text-gray-400"
                                                                    xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                    viewBox="0 0 24 24" stroke="currentColor">
                                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                                        stroke-width="2"
                                                                        d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                                </svg>
                                                            </div>
                                                            <input type="date" :name="`experience[${index}][end_date]`"
                                                                class="w-full text-xs border-gray-300 rounded focus:ring-blue-500 focus:border-blue-500 py-1 pl-7 px-2">
                                                        </div>
                                                    </div>
                                                    <div class="flex flex-col col-span-1 md:col-span-2">
                                                        <label class="text-[10px] font-medium text-gray-500 uppercase">Reason
                                                            for Leaving</label>
                                                        <div class="relative">
                                                            <div
                                                                class="absolute inset-y-0 left-0 pl-2 flex items-center pointer-events-none">
                                                                <svg class="h-3 w-3 text-gray-400"
                                                                    xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                    viewBox="0 0 24 24" stroke="currentColor">
                                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                                        stroke-width="2"
                                                                        d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                                </svg>
                                                            </div>
                                                            <input type="text" :name="`experience[${index}][reason]`"
                                                                class="w-full text-xs border-gray-300 rounded focus:ring-blue-500 focus:border-blue-500 py-1 pl-7 px-2">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                    </div>

                                    <!-- Tags -->
                                    <div class="flex flex-col col-span-1 md:col-span-2">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Tags</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="tags" placeholder="e.g. Developer, Full-time"
                                                class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                        </div>
                                    </div>

                                    <!-- Fax -->
                                    <div class="flex flex-col col-span-1 md:col-span-2 border-b border-gray-100 pb-4">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Fax</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="fax"
                                                class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                        </div>
                                    </div>

                                    <!-- Employment Date -->
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Employment Date</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                </svg>
                                            </div>
                                            <input type="date" name="employment_date"
                                                class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                        </div>
                                    </div>

                                    <!-- Birthday -->
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Birthday</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M21 15.546c-.523 0-1.046.151-1.5.454a2.704 2.704 0 01-3 0 2.704 2.704 0 00-3 0 2.704 2.704 0 01-3 0 2.704 2.704 0 00-3 0 2.704 2.704 0 01-3 0 2.701 2.701 0 00-1.5-.454M9 6v2m3-2v2m3-2v2M9 3h.01M12 3h.01M15 3h.01M21 21v-7a2 2 0 00-2-2H5a2 2 0 00-2 2v7h18zm-3-9v-2a2 2 0 00-2-2H8a2 2 0 00-2 2v2h12z" />
                                                </svg>
                                            </div>
                                            <input type="date" name="birthday"
                                                class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                        </div>
                                    </div>

                                    <!-- Terminated Date -->
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Terminated Date</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M6 18L18 6M6 6l12 12"></path>
                                                </svg>
                                            </div>
                                            <input type="date" name="terminated_date"
                                                class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Skills & Attributes Tab -->
                            <div x-show="activeTab === 'skills'" class="space-y-6" x-cloak>
                                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                                    @forelse($skills as $skill)
                                        <div
                                            class="flex items-center gap-3 p-4 border border-gray-100 rounded hover:bg-gray-50 transition-colors">
                                            <input type="checkbox" name="skills[]" value="{{ $skill->id }}"
                                                id="skill_{{ $skill->id }}"
                                                class="rounded text-blue-600 focus:ring-blue-500 w-4 h-4">
                                            <label for="skill_{{ $skill->id }}"
                                                class="text-xs font-medium text-gray-700 cursor-pointer flex-1">
                                                {{ $skill->name }}
                                                @if ($skill->category)
                                                    <span
                                                        class="block text-[10px] text-gray-400 font-normal">{{ $skill->category }}</span>
                                                @endif
                                            </label>
                                        </div>
                                    @empty
                                        <div class="col-span-full text-center py-12">
                                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                    d="M13 10V3L4 14h7v7l9-11h-7z" />
                                            </svg>
                                            <h3 class="mt-2 text-sm font-medium text-gray-900">No skills found</h3>
                                        </div>
                                    @endforelse
                                </div>
                            </div>

                        </form>
                    </div>

                    <!-- Form Actions -->
                    <div class="mt-8 pt-6 border-t border-gray-100 flex justify-end gap-3" x-cloak>
                        <!-- Next Button (for Work Details) -->
                        <button type="button" @click="activeTab = 'skills'" x-show="activeTab === 'other'"
                            class="bg-slate-800 hover:bg-slate-700 text-white px-6 py-2.5 rounded-md text-xs font-bold uppercase tracking-wider transition-all shadow-md hover:shadow-lg flex items-center gap-2">
                            Next Step
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M14 5l7 7m0 0l-7 7m7-7H3" />
                            </svg>
                        </button>

                        <!-- Submit Button (for Skills Tab) -->
                        <button type="submit" form="employee-form" x-show="activeTab === 'skills'"
                            class="bg-[#2a9fd8] hover:bg-blue-600 text-white px-8 py-3 rounded-md text-sm font-bold uppercase tracking-wider transition-all shadow-md hover:shadow-lg flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                            </svg>
                            Save New Employee
                        </button>
                    </div>
                </div>



            </div>
        </div>

        <style>
            [x-cloak] {
                display: none !important;
            }
        </style>
@endsection