@extends('layouts.employee')

@section('title', 'Request Details')

@section('content')
    <div class="px-4 py-6 max-w-2xl mx-auto space-y-6">
        <!-- Header -->
        <div class="flex items-center gap-3 mb-6">
            <a href="{{ route('employee.requests.index') }}" class="text-gray-400 hover:text-gray-600 transition-colors">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                </svg>
            </a>
            <div class="flex-1">
                <h1 class="font-bold text-gray-900 text-xl">{{ ucfirst($request->type) }}</h1>
                <p class="text-sm text-gray-500 font-medium">{{ $request->created_at->format('M d, Y • h:i A') }}</p>
            </div>
            <div>
                <span class="px-3 py-1.5 rounded-lg text-xs font-bold uppercase tracking-wider
                        @if($request->status == 'pending') bg-amber-50 text-amber-600
                        @elseif($request->status == 'replied') bg-blue-50 text-blue-600
                        @elseif($request->status == 'approved') bg-emerald-50 text-emerald-600
                        @elseif($request->status == 'rejected') bg-rose-50 text-rose-600
                        @endif">
                    {{ $request->status }}
                </span>
            </div>
        </div>

        <!-- Original Message -->
        <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100">
            @if($request->subject)
                <h2 class="font-bold text-gray-900 mb-3 text-lg">{{ $request->subject }}</h2>
            @else
                <h2 class="font-bold text-gray-400 mb-3 text-sm uppercase tracking-wide">Original Request</h2>
            @endif
            <p class="text-gray-600 whitespace-pre-wrap leading-relaxed">{{ $request->message }}</p>
        </div>

        <!-- Conversation Loop -->
        <div class="space-y-4 py-2">
            @foreach($request->replies as $reply)
                <div class="flex {{ $reply->is_employee_reply ? 'justify-end' : 'justify-start' }}">
                    <div
                        class="{{ $reply->is_employee_reply ? 'bg-blue-600 text-white rounded-tr-none' : 'bg-white text-gray-800 border border-gray-100 rounded-tl-none' }} rounded-2xl px-5 py-3 max-w-[85%] shadow-sm">
                        <p class="whitespace-pre-wrap text-sm leading-relaxed">{{ $reply->message }}</p>
                        <p
                            class="text-[10px] mt-1.5 {{ $reply->is_employee_reply ? 'text-blue-100' : 'text-gray-400' }} text-right font-medium">
                            {{ $reply->created_at->format('M d, h:i A') }}
                            @if(!$reply->is_employee_reply) • Admin @endif
                        </p>
                    </div>
                </div>
            @endforeach
        </div>

        <!-- Reply Form -->
        <div class="bg-white p-4 rounded-2xl shadow-sm border border-gray-100 mt-6 md:sticky md:bottom-6 z-10">
            <form action="{{ route('employee.requests.reply', $request) }}" method="POST">
                @csrf
                <label class="block text-xs font-bold text-gray-400 uppercase mb-2">Write a Reply</label>
                <textarea name="message" rows="3"
                    class="w-full border-gray-200 rounded-xl focus:ring-blue-500 focus:border-blue-500 mb-3 text-sm resize-none bg-gray-50 focus:bg-white transition-all"
                    placeholder="Type your message here..." required></textarea>
                <div class="flex justify-end">
                    <button type="submit"
                        class="px-6 py-2.5 bg-blue-600 text-white text-sm font-bold rounded-xl hover:bg-blue-700 transition-all shadow-lg shadow-blue-500/20 active:scale-95">
                        Send Reply
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection