<!DOCTYPE html>
<html>

<head>
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            font-size: 10px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        h2 {
            margin-bottom: 0px;
        }

        p {
            margin-top: 5px;
            color: #666;
            font-size: 12px;
        }

        .meta {
            margin-bottom: 20px;
        }
    </style>
</head>

<body>
    <div class="meta">
        <h2>Operational Report: {{ ucfirst($reportType) }}</h2>
        <p>Employee: {{ $employee->first_name }} {{ $employee->last_name }} ({{ $employee->employee_id ?? 'N/A' }})</p>
        <p>Date Generated: {{ now()->format('M d, Y H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Duty #</th>
                <th>Site</th>
                <th>Sched. Start</th>
                <th>Sched. End</th>
                <th>Act. Start</th>
                <th>Act. End</th>
                @if($reportType === 'scans')
                    <th>Scans</th>
                @endif
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($reports as $schedule)
                @php 
                    $schedule = (object) $schedule; 
                    $fromDate = \Carbon\Carbon::parse($schedule->from_datetime);
                    $toDate = \Carbon\Carbon::parse($schedule->to_datetime);
                @endphp
                <tr>
                    <td>{{ $fromDate->format('M d, Y') }}</td>
                    <td>{{ $schedule->duty_number }} ({{ $schedule->type }})</td>
                    <td>{{ $schedule->site_name }}</td>
                    <td>{{ $fromDate->format('H:i') }}</td>
                    <td>{{ $toDate->format('H:i') }}</td>
                    <td>
                        {{ $schedule->actual_start_at ? \Carbon\Carbon::parse($schedule->actual_start_at)->format('H:i') : '--' }}
                    </td>
                    <td>
                        {{ $schedule->actual_end_at ? \Carbon\Carbon::parse($schedule->actual_end_at)->format('H:i') : '--' }}
                    </td>
                    @if($reportType === 'scans')
                        <td>{{ $schedule->scans_count }}</td>
                    @endif
                    <td>{{ ucfirst($schedule->status) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>