@extends('layouts.employee')

@section('title', 'Location Request')

@section('content')
    <div class="max-w-2xl mx-auto">
        <div class="bg-white rounded-xl shadow-lg border border-gray-200 overflow-hidden">
            {{-- Header --}}
            <div class="bg-gradient-to-r from-green-600 to-green-700 px-6 py-5">
                <div class="flex items-center gap-3">
                    <div class="bg-white/20 p-3 rounded-lg">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                            </path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <h1 class="text-2xl font-bold text-white">Location & Evidence Request</h1>
                        <p class="text-green-100 text-sm mt-1">{{ $jobName }} ({{ $jobRef }})</p>
                    </div>
                </div>
            </div>

            {{-- Form --}}
            <form action="{{ route('employee.location-request.submit') }}" method="POST" enctype="multipart/form-data"
                class="p-6 space-y-6">
                @csrf
                <input type="hidden" name="type" value="{{ $type }}">
                <input type="hidden" name="job_id" value="{{ $jobId }}">

                @if($errors->any())
                    <div class="bg-red-50 border border-red-200 rounded-lg p-4">
                        <div class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-red-600 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                    clip-rule="evenodd"></path>
                            </svg>
                            <div class="flex-1">
                                <h3 class="font-semibold text-red-800">Error</h3>
                                @foreach($errors->all() as $error)
                                    <p class="text-sm text-red-700">{{ $error }}</p>
                                @endforeach
                            </div>
                        </div>
                    </div>
                @endif

                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                    <p class="text-sm text-blue-800">
                        <strong>📌 Note:</strong> Please provide <strong>either</strong> your location information
                        <strong>or</strong> upload evidence photos (or both).
                    </p>
                </div>

                {{-- Location Section --}}
                <div class="space-y-4">
                    <h3 class="text-lg font-semibold text-gray-900 flex items-center gap-2">
                        <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                            </path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                        Location Information
                    </h3>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Location Description</label>
                        <input type="text" name="location_reported"
                            class="w-full rounded-lg border-gray-300 shadow-sm focus:border-green-500 focus:ring-green-500"
                            placeholder="e.g., Main Entrance, Building A, Floor 2">
                        <p class="text-xs text-gray-500 mt-1">Describe where you are currently located</p>
                    </div>

                    <div class="grid grid-cols-2 gap-3">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Latitude</label>
                            <input type="text" name="latitude" id="latitude"
                                class="w-full rounded-lg border-gray-300 shadow-sm focus:border-green-500 focus:ring-green-500"
                                placeholder="28.7041">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Longitude</label>
                            <input type="text" name="longitude" id="longitude"
                                class="w-full rounded-lg border-gray-300 shadow-sm focus:border-green-500 focus:ring-green-500"
                                placeholder="77.1025">
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Google Maps Link</label>
                        <input type="url" name="maps_link" id="maps_link"
                            class="w-full rounded-lg border-gray-300 shadow-sm focus:border-green-500 focus:ring-green-500"
                            placeholder="Paste your Google Maps location link">
                        <p class="text-xs text-gray-500 mt-1">Share your live location from Google Maps</p>
                    </div>

                    <button type="button" onclick="getCurrentLocation()"
                        class="w-full py-2.5 bg-green-100 hover:bg-green-200 text-green-700 font-semibold rounded-lg transition-colors flex items-center justify-center gap-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path>
                        </svg>
                        Use My Current Location
                    </button>
                </div>

                {{-- Evidence Photos --}}
                <div class="space-y-4">
                    <h3 class="text-lg font-semibold text-gray-900 flex items-center gap-2">
                        <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3 9a2 2 0 012-2h.93a2 2 0 001.664-.89l.812-1.22A2 2 0 0110.07 4h3.86a2 2 0 011.664.89l.812 1.22A2 2 0 0018.07 7H19a2 2 0 012 2v9a2 2 0 01-2 2H5a2 2 0 01-2-2V9z">
                            </path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M15 13a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                        Evidence Photos
                    </h3>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Upload Photos</label>
                        <input type="file" name="images[]" multiple accept="image/*"
                            class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-semibold file:bg-green-50 file:text-green-700 hover:file:bg-green-100">
                        <p class="text-xs text-gray-500 mt-1">You can select multiple photos (max 10MB each)</p>
                    </div>
                </div>

                {{-- Remarks --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Remarks (Optional)</label>
                    <textarea name="remarks" rows="3"
                        class="w-full rounded-lg border-gray-300 shadow-sm focus:border-green-500 focus:ring-green-500"
                        placeholder="Any additional information..."></textarea>
                </div>

                {{-- Submit Button --}}
                <div class="flex gap-3">
                    <a href="{{ route('employee.dashboard') }}"
                        class="flex-1 py-3 bg-gray-100 hover:bg-gray-200 text-gray-700 font-semibold rounded-lg transition-colors text-center">
                        Cancel
                    </a>
                    <button type="submit"
                        class="flex-1 py-3 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-lg transition-colors flex items-center justify-center gap-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                        Submit Response
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function getCurrentLocation() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function (position) {
                    document.getElementById('latitude').value = position.coords.latitude.toFixed(6);
                    document.getElementById('longitude').value = position.coords.longitude.toFixed(6);

                    // Show success message
                    alert('✓ Location captured successfully!');
                }, function (error) {
                    alert('Unable to get your location. Please enter manually or use Google Maps link.');
                });
            } else {
                alert('Geolocation is not supported by your browser.');
            }
        }

        // Auto-extract coordinates from Google Maps link
        document.getElementById('maps_link').addEventListener('input', function (e) {
            const url = e.target.value.trim();
            if (!url) return;

            let lat = null, lng = null;

            // Try different Google Maps URL formats
            let match = url.match(/[?&]q=(-?\d+\.?\d*),(-?\d+\.?\d*)/);
            if (match) {
                lat = match[1];
                lng = match[2];
            }

            if (!lat) {
                match = url.match(/@(-?\d+\.?\d*),(-?\d+\.?\d*)/);
                if (match) {
                    lat = match[1];
                    lng = match[2];
                }
            }

            if (!lat) {
                match = url.match(/place\/[^/]+\/@(-?\d+\.?\d*),(-?\d+\.?\d*)/);
                if (match) {
                    lat = match[1];
                    lng = match[2];
                }
            }

            if (!lat) {
                match = url.match(/[?&]ll=(-?\d+\.?\d*),(-?\d+\.?\d*)/);
                if (match) {
                    lat = match[1];
                    lng = match[2];
                }
            }

            if (lat && lng) {
                document.getElementById('latitude').value = lat;
                document.getElementById('longitude').value = lng;

                // Visual feedback
                document.getElementById('latitude').classList.add('bg-green-50', 'border-green-300');
                document.getElementById('longitude').classList.add('bg-green-50', 'border-green-300');

                setTimeout(() => {
                    document.getElementById('latitude').classList.remove('bg-green-50', 'border-green-300');
                    document.getElementById('longitude').classList.remove('bg-green-50', 'border-green-300');
                }, 2000);
            }
        });
    </script>
@endsection