@extends('layouts.public')

@section('content')
    <style>
        .employee-login-wrapper {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background-color: #f8fafc;
            min-height: calc(100vh - 15rem);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 3rem 1rem;
        }

        .container-custom {
            max-width: 28rem;
            width: 100%;
        }

        .card {
            background: white;
            border-radius: 0.75rem;
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            border: 1px solid #f1f5f9;
            padding: 2rem;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .input-label {
            display: block;
            font-size: 0.75rem;
            font-weight: 700;
            color: #64748b;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            margin-bottom: 0.5rem;
        }

        .input-wrapper {
            position: relative;
        }

        .custom-input {
            display: block;
            width: 100%;
            padding: 0.75rem 1rem;
            background-color: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 0.5rem;
            color: #0f172a;
            font-weight: 700;
            font-size: 0.875rem;
            transition: all 0.2s;
        }

        .custom-input:focus {
            outline: none;
            border-color: #0f172a;
            box-shadow: 0 0 0 3px rgba(15, 23, 42, 0.1);
        }

        .submit-btn {
            width: 100%;
            background-color: #0f172a;
            color: white;
            font-weight: 700;
            padding: 1rem;
            border-radius: 0.75rem;
            box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
            border: none;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            font-size: 0.75rem;
            transition: all 0.2s;
        }

        .submit-btn:hover {
            background-color: #000000;
        }
    </style>

    <div class="employee-login-wrapper">
        <div class="container-custom">
            <div class="card">
                <h2 class="text-2xl font-bold text-center mb-6">Reset Password</h2>

                @if (session('status'))
                    <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4" role="alert">
                        {{ session('status') }}
                    </div>
                @endif

                <form action="{{ route('employee.password.email') }}" method="POST">
                    @csrf
                    <div class="form-group">
                        <label class="input-label">Email Address</label>
                        <div class="input-wrapper">
                            <input type="email" name="email" value="{{ old('email') }}" required autofocus
                                placeholder="operative@example.com" class="custom-input">
                        </div>
                        @error('email')
                            <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span>
                        @enderror
                    </div>

                    <button type="submit" class="submit-btn">
                        Send Password Reset Link
                    </button>
                </form>

                <div class="mt-4 text-center">
                    <a href="{{ route('employee.login') }}" class="text-sm font-bold text-gray-500 hover:text-gray-900">Back
                        to Login</a>
                </div>
            </div>
        </div>
    </div>
@endsection