<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
        }

        .header {
            background: #1e293b;
            color: white;
            padding: 20px;
            text-align: center;
            border-radius: 8px 8px 0 0;
        }

        .content {
            background: #ffffff;
            padding: 20px;
            border: 1px solid #e2e8f0;
        }

        .footer {
            background: #f8fafc;
            padding: 15px;
            text-align: center;
            font-size: 12px;
            color: #64748b;
            border-radius: 0 0 8px 8px;
        }

        .details {
            margin: 20px 0;
            padding: 15px;
            background: #f1f5f9;
            border-radius: 6px;
        }

        .button {
            display: inline-block;
            background: #2563eb;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
        }
    </style>
</head>

<body>
    <div class="header">
        <h2>Duty Performance Report</h2>
    </div>
    <div class="content">
        <p>Dear {{ $schedule->site->contact_first_name ?? 'Client' }},</p>
        <p>Please find the attached duty performance report for the following schedule:</p>

        <div class="details">
            <strong>Duty Number:</strong> {{ $schedule->duty_number }}<br>
            <strong>Site:</strong> {{ $schedule->site->name }}<br>
            <strong>Date:</strong> {{ $schedule->from_datetime->format('M d, Y') }}<br>
            <strong>Time:</strong> {{ $schedule->from_datetime->format('H:i A') }} -
            {{ $schedule->to_datetime->format('H:i A') }}
        </div>

        <p>The detailed report includes guard activities, check-ins, and any incidents reported during the shift.</p>

        <p>Best Regards,<br>
            {{ $schedule->company->name ?? config('app.name') }} Team</p>
    </div>
    <div class="footer">
        &copy; {{ date('Y') }} {{ $schedule->company->name ?? config('app.name') }}. All rights reserved.
    </div>
</body>

</html>