<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
        }

        .header {
            background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
            color: white;
            padding: 30px;
            text-align: center;
            border-radius: 8px 8px 0 0;
        }

        .header h1 {
            margin: 0;
            font-size: 24px;
        }

        .content {
            background: #ffffff;
            padding: 30px;
            border: 1px solid #e2e8f0;
            border-top: none;
        }

        .quotation-box {
            background: #f8fafc;
            border-left: 4px solid #3b82f6;
            padding: 20px;
            margin: 20px 0;
            border-radius: 4px;
        }

        .quotation-box h2 {
            margin: 0 0 10px 0;
            color: #1e293b;
            font-size: 18px;
        }

        .quotation-box p {
            margin: 5px 0;
        }

        .amount {
            font-size: 32px;
            font-weight: bold;
            color: #3b82f6;
            margin: 10px 0;
        }

        .button {
            display: inline-block;
            background: #3b82f6;
            color: white;
            padding: 12px 30px;
            text-decoration: none;
            border-radius: 6px;
            margin: 20px 0;
            font-weight: bold;
        }

        .footer {
            background: #f8fafc;
            padding: 20px;
            text-align: center;
            font-size: 12px;
            color: #64748b;
            border-radius: 0 0 8px 8px;
        }

        .details-table {
            width: 100%;
            margin: 20px 0;
        }

        .details-table td {
            padding: 8px 0;
            border-bottom: 1px solid #e2e8f0;
        }

        .details-table td:first-child {
            color: #64748b;
            width: 130px;
        }

        .details-table td:last-child {
            font-weight: 600;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1>{{ $quotation->company->name ?? 'Company' }}</h1>
        <p>Quotation Request</p>
    </div>

    <div class="content">
        <p>Dear {{ $quotation->client_name }},</p>

        <p>Thank you for your interest in our services. Please find attached the detailed quotation for your review.</p>

        <div class="quotation-box">
            <h2>Quotation {{ $quotation->quotation_number }}</h2>

            <table class="details-table">
                <tr>
                    <td>Issue Date:</td>
                    <td>{{ $quotation->issue_date->format('M d, Y') }}</td>
                </tr>
                @if($quotation->valid_until)
                    <tr>
                        <td>Valid Until:</td>
                        <td>{{ $quotation->valid_until->format('M d, Y') }}</td>
                    </tr>
                @endif
                <tr>
                    <td>Number of Items:</td>
                    <td>{{ $quotation->items->count() }}</td>
                </tr>
            </table>

            <div class="amount">
                ${{ number_format($quotation->total_amount, 2) }}
            </div>
        </div>

        <p><strong>What's Included:</strong></p>
        <ul style="margin: 10px 0; padding-left: 20px;">
            @foreach($quotation->items->take(5) as $item)
                <li>{{ $item->description }}</li>
            @endforeach
            @if($quotation->items->count() > 5)
                <li><em>... and {{ $quotation->items->count() - 5 }} more items</em></li>
            @endif
        </ul>

        <p>The complete quotation is attached to this email as a PDF document. Please review it at your convenience.</p>

        <p>If you have any questions or would like to discuss this quotation further, please don't hesitate to contact
            us.</p>

        <p style="margin-top: 30px;">Best regards,<br>
            <strong>{{ $quotation->user->name ?? 'The Team' }}</strong><br>
            {{ $quotation->company->name ?? 'Company' }}
        </p>

        @if($quotation->company && ($quotation->company->phone || $quotation->company->email))
            <p style="font-size: 12px; color: #64748b; margin-top: 10px;">
                @if($quotation->company->phone)
                    Phone: {{ $quotation->company->phone }}<br>
                @endif
                @if($quotation->company->email)
                    Email: {{ $quotation->company->email }}
                @endif
            </p>
        @endif
    </div>

    <div class="footer">
        <p>&copy; {{ date('Y') }} {{ $quotation->company->name ?? 'Company' }}. All rights reserved.</p>
        <p>This is an automated email. Please do not reply to this message.</p>
    </div>
</body>

</html>