@extends('layouts.user')

@section('title', 'Create Email Template')

@section('content')
    <!-- Breadcrumb & Header -->
    <div
        class="flex flex-col md:flex-row md:items-center justify-between gap-4 bg-slate-900 p-8 rounded-[2rem] text-white shadow-2xl mb-6">
        <div>
            <div class="flex items-center gap-2 text-[10px] font-bold uppercase tracking-widest text-blue-400 mb-1">
                <a href="{{ route('email-templates.index') }}" class="hover:text-white transition-colors">Email
                    Templates</a>
                <svg class="w-3 h-3 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
                <span class="text-white">Create New</span>
            </div>
            <h1 class="text-3xl font-black tracking-tight">Create Email Template</h1>
            <p class="text-xs text-slate-400 font-medium mt-1">Design a new email template with custom content.</p>
        </div>
        <a href="{{ route('email-templates.index') }}"
            class="flex items-center gap-2 px-6 py-2.5 bg-white/10 hover:bg-white/20 text-white text-xs font-bold rounded-2xl backdrop-blur-md transition-all border border-white/10">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18">
                </path>
            </svg>
            Back to List
        </a>
    </div>

    <div class="bg-white border border-slate-100 rounded-[2rem] shadow-2xl overflow-hidden">
        <form action="{{ route('email-templates.store') }}" method="POST" class="p-10 space-y-8">
            @csrf

            <!-- Basic Information Section -->
            <div>
                <div class="flex items-center gap-2 mb-6">
                    <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                    <h2 class="text-xs font-black text-slate-900 uppercase tracking-widest">Template Details</h2>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Template
                            Name <span class="text-red-500 ml-1">*</span></label>
                        <input type="text" name="name" required placeholder="e.g., Welcome Email"
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all text-sm">
                        <p class="text-[10px] text-slate-400 mt-1.5 font-medium">Internal name for identifying this
                            template.</p>
                    </div>

                    <div>
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Subject Line
                            <span class="text-red-500 ml-1">*</span></label>
                        <input type="text" name="subject" required placeholder="e.g., Welcome to the Team!"
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all text-sm">
                    </div>
                </div>
            </div>

            <!-- Content Section -->
            <div class="pt-6 border-t border-slate-100">
                <div class="flex items-center gap-2 mb-6">
                    <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                    <h2 class="text-xs font-black text-slate-900 uppercase tracking-widest">Email Content</h2>
                </div>

                <div>
                    <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Template Content
                        <span class="text-red-500 ml-1">*</span></label>
                    <div id="content-editor" style="height: 400px; background: white;"></div>
                    <textarea name="content" id="content-hidden" style="display: none;"></textarea>
                    <div class="mt-3 text-[10px] text-slate-500 bg-slate-50 p-4 rounded-xl border border-slate-200">
                        <div class="flex items-start gap-2">
                            <svg class="w-4 h-4 mt-0.5 text-blue-600 flex-shrink-0" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <div>
                                <span class="font-bold text-slate-700">Available Placeholders:</span>
                                <div class="mt-1 flex flex-wrap gap-2">
                                    <code
                                        class="px-2 py-1 bg-white border border-slate-300 rounded text-blue-600 font-bold">@{{name}}</code>
                                    <code
                                        class="px-2 py-1 bg-white border border-slate-300 rounded text-blue-600 font-bold">@{{first_name}}</code>
                                    <code
                                        class="px-2 py-1 bg-white border border-slate-300 rounded text-blue-600 font-bold">@{{last_name}}</code>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="pt-8 border-t border-slate-100 flex items-center gap-4">
                <button type="submit" onclick="console.log('Button clicked!'); return true;"
                    class="px-10 py-3 bg-blue-600 text-white font-bold rounded-xl hover:bg-blue-700 transition-all shadow-lg shadow-blue-500/20 flex items-center gap-2 text-sm">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3 3m0 0l-3-3m3 3V4">
                        </path>
                    </svg>
                    Save Template
                </button>
                <a href="{{ route('email-templates.index') }}"
                    class="px-8 py-3 bg-slate-100 text-slate-600 font-bold rounded-xl hover:bg-slate-200 transition-all text-sm">
                    Cancel
                </a>
            </div>
        </form>
    </div>

    <!-- Quill Editor CSS -->
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">

    <!-- Quill Editor JS -->
    <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            console.log('DOM Loaded - Initializing Quill Editor');
            const signatureContent = @json($defaultSignature->content ?? '');

            // Initialize Quill Editor
            var quill = new Quill('#content-editor', {
                theme: 'snow',
                modules: {
                    toolbar: [
                        [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
                        ['bold', 'italic', 'underline', 'strike'],
                        [{ 'color': [] }, { 'background': [] }],
                        [{ 'align': [] }],
                        [{ 'list': 'ordered' }, { 'list': 'bullet' }],
                        ['blockquote', 'code-block'],
                        ['link', 'image'],
                        ['clean']
                    ]
                },
                placeholder: 'Start typing your email content here...'
            });

            console.log('Quill Editor initialized');

            // Add signature content after editor is initialized
            if (signatureContent) {
                quill.root.innerHTML = signatureContent;
                console.log('Signature content added');
                // Also set it in the hidden field immediately
                const hiddenInput = document.getElementById('content-hidden');
                if (hiddenInput) {
                    hiddenInput.value = signatureContent;
                }
            }

            // Get the hidden textarea
            const form = document.querySelector('form');
            const hiddenInput = document.getElementById('content-hidden');

            console.log('Form:', form);
            console.log('Hidden Input:', hiddenInput);

            // Update hidden textarea whenever content changes
            quill.on('text-change', function () {
                hiddenInput.value = quill.root.innerHTML;
                console.log('Content updated in hidden field');
            });

            // Also update on form submission
            form.addEventListener('submit', function (e) {
                console.log('Form submit triggered');
                const content = quill.root.innerHTML;
                const textContent = quill.getText().trim();

                console.log('Content HTML:', content);
                console.log('Content Text:', textContent);
                console.log('Text Length:', textContent.length);

                // Update hidden field
                hiddenInput.value = content;
                console.log('Hidden input value:', hiddenInput.value.substring(0, 100));

                // Check if editor has actual content (not just empty tags)
                if (!textContent || textContent.length === 0) {
                    e.preventDefault();
                    alert('Please enter email content before submitting.');
                    console.log('Form submission prevented - no content');
                    return false;
                }

                console.log('Form will now submit');
            });
        });
    </script>
@endsection